/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.config;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.util.config.IPropertyStore;
import com.sapportals.trex.util.config.file.PropertyStoreFile;
import com.sapportals.trex.util.config.service.ServicePropertyStore;
import com.sapportals.trex.util.string.StrUtil;
import java.io.File;
import java.net.URLDecoder;
import java.util.StringTokenizer;

public class PropertyStoreFactory {
    private static PropertyStoreFactory m_factory = new PropertyStoreFactory();
    private static IPropertyStore m_store = null;
    private static String CONFIG_FILE = "trexjavaclient.properties";

    private PropertyStoreFactory() {
    }

    public static PropertyStoreFactory getInstance() {
        return m_factory;
    }

    public synchronized IPropertyStore getPropertyStore() throws TrexException {
        if (m_store != null) {
            return m_store;
        }
        boolean useFileSystem = false;
        String path = PropertyStoreFactory.findConfigurationFilePath(PropertyStoreFactory.getClassPath(this.getClass()), CONFIG_FILE);
        File f = path != null ? new File(new File(path), CONFIG_FILE) : new File(CONFIG_FILE);
        if (f.exists()) {
            useFileSystem = true;
        }
        m_store = useFileSystem ? PropertyStoreFile.getInstance() : new ServicePropertyStore();
        return m_store;
    }

    private static String getClassPath(Class cls) {
        try {
            ClassLoader cl = cls.getClassLoader();
            String rsrc = URLDecoder.decode(cls.getName().replace('.', '/') + ".class");
            String url = cl.getResource(rsrc).toString();
            if (url.startsWith("jar:file:")) {
                return url.substring(9, url.length() - rsrc.length() - 2);
            }
            if (url.startsWith("file:")) {
                return url.substring(5);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String findConfigurationFilePath(String classpath, String confFile) {
        boolean found = false;
        String path = classpath;
        Object file = null;
        if (path != null) {
            String dir = new File(path).getParent();
            found = new File(dir, confFile).exists();
            if (found) {
                return dir;
            }
            System.out.println("PropertyStoreFactory before unescaping: dir: " + dir + " confFile : " + confFile);
            dir = StrUtil.replace(dir, "%20", " ", true);
            found = new File(dir, confFile).exists();
            System.out.println("PropertyStoreFactory after unescaping: dir: " + dir + " confFile : " + confFile + " found:" + found);
            if (found) {
                return dir;
            }
        }
        StringTokenizer paths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        confFile = System.getProperty("file.separator") + confFile;
        while (!found && paths.hasMoreTokens()) {
            path = paths.nextToken();
            found = new File(path, confFile).exists();
            if (found) {
                return path;
            }
            path = new File(path).getParent();
            found = new File(path, confFile).exists();
            System.out.println("PropertyStoreFactory: path(one up): " + path + " confFile : " + confFile);
            if (!found) continue;
            return path;
        }
        return null;
    }
}

