/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigurationManager {
    private static final String CONFIG_INCLUDE = "include";
    private static ConfigurationManager s_configurationManager;

    public File getFile(String configurationName) {
        return null;
    }

    public void clearAllProperties() {
    }

    public Properties loadProperties(String configurationName) throws Exception {
        return this.loadProperties(configurationName, (Properties)null);
    }

    public Properties loadProperties(Object caller, String configurationName) throws Exception {
        return this.loadProperties(caller, configurationName, null);
    }

    public Properties loadProperties(String configurationName, Properties replaceStrings) throws Exception {
        return this.loadProperties(this, configurationName, replaceStrings);
    }

    public Properties loadProperties(Object caller, String configurationName, Properties replaceStrings) throws Exception {
        return this.lowLoadProperties(caller, configurationName, replaceStrings);
    }

    public Properties loadPropertiesFromPath(String path, String configurationName) throws Exception {
        return this.loadPropertiesFromPath(path, configurationName, null);
    }

    public Properties loadPropertiesFromPath(String path, String configurationName, Properties replaceStrings) throws Exception {
        File configurationFile = new File(path, configurationName);
        Properties properties = new Properties();
        FileInputStream input = new FileInputStream(configurationFile);
        try {
            properties.load(input);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((InputStream)input).close();
            throw throwable;
        }
        ((InputStream)input).close();
        properties = this.trimProperties(properties);
        if (replaceStrings != null) {
            this.replacePropertyStrings(properties, replaceStrings);
        }
        properties = this.importProperties(configurationFile, replaceStrings, properties);
        return properties;
    }

    protected Properties lowLoadProperties(Object caller, String configurationFile, Properties replaceStrings) throws Exception {
        return this.readConfigurationFile(caller, configurationFile, replaceStrings);
    }

    private String getParentDirectory(File file) {
        File parentDirectoryFile = file.getParentFile();
        if (parentDirectoryFile != null) {
            return parentDirectoryFile.getAbsolutePath();
        }
        return "/";
    }

    private Properties readConfigurationFile(File configurationFile, Properties replaceStrings) throws Exception {
        Properties properties = new Properties();
        FileInputStream input = new FileInputStream(configurationFile);
        try {
            properties.load(input);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ((InputStream)input).close();
            throw throwable;
        }
        ((InputStream)input).close();
        properties = this.trimProperties(properties);
        if (replaceStrings != null) {
            this.replacePropertyStrings(properties, replaceStrings);
        }
        properties = this.importProperties(configurationFile, replaceStrings, properties);
        return properties;
    }

    private Properties readConfigurationFile(Object caller, String configurationFile, Properties replaceStrings) throws Exception {
        Properties properties = new Properties();
        File file = new File(this.findConfigurationFilePath(this.getClassPath(caller.getClass()), configurationFile), configurationFile);
        InputStream input = null;
        input = file.exists() ? new FileInputStream(file) : caller.getClass().getClassLoader().getResourceAsStream(configurationFile);
        if (input == null) {
            throw new FileNotFoundException("failed to load " + configurationFile);
        }
        properties.load(input);
        properties = this.trimProperties(properties);
        if (replaceStrings != null) {
            this.replacePropertyStrings(properties, replaceStrings);
        }
        properties = this.importProperties(caller, configurationFile, replaceStrings, properties);
        return properties;
    }

    private Properties trimProperties(Properties properties) {
        Enumeration keys = ((Hashtable)properties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            properties.setProperty(key, properties.getProperty(key).trim());
        }
        return properties;
    }

    private void replacePropertyStrings(Properties properties, Properties replaceStrings) {
        String REPLACE_STRING_PREFIX = "<%";
        String REPLACE_STRING_POSTFIX = "%>";
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String placeHolder;
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            int start = value.indexOf("<%");
            int end = value.indexOf("%>");
            if (start < 0 || end < 0 || end <= start + "<%".length() || (placeHolder = value.substring(start + "<%".length(), end).trim()).length() <= 0) continue;
            String before = value.substring(0, start);
            String after = end + "%>".length() < value.length() ? value.substring(end + "%>".length()) : "";
            String replaceValue = replaceStrings.getProperty(placeHolder);
            if (replaceValue == null) continue;
            properties.setProperty(name, before + replaceValue + after);
        }
    }

    private String findConfigurationFilePath(String classpath, String confFile) {
        String dir;
        boolean found = false;
        String path = classpath;
        Object file = null;
        if (path != null && (found = new File(dir = new File(path).getParent(), confFile).exists())) {
            return dir;
        }
        StringTokenizer paths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        confFile = System.getProperty("file.separator") + confFile;
        while (!found && paths.hasMoreTokens()) {
            File nFile;
            path = paths.nextToken();
            File cFile = new File(path);
            if (!(cFile.isFile() ? (nFile = new File(cFile.getParent(), confFile)).exists() : (nFile = new File(cFile.getAbsolutePath(), confFile)).exists())) continue;
            return nFile.getParent();
        }
        return null;
    }

    private String getClassPath(Class aClass) {
        String JAR_FILE_PREFIX = "jar:file:";
        String FILE_PREFIX = "file:";
        try {
            String className = aClass.getName().replace('.', '/') + ".class";
            ClassLoader classLoader = aClass.getClassLoader();
            String url = classLoader.getResource(className).toString();
            if (url.startsWith("jar:file:")) {
                return url.substring("jar:file:".length(), url.length() - className.length() - 2);
            }
            if (url.startsWith("file:")) {
                return url.substring("file:".length());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Properties importProperties(File configurationFile, Properties replaceStrings, Properties properties) throws Exception {
        String includeFiles = (String)((Hashtable)properties).get(CONFIG_INCLUDE);
        if (includeFiles == null || includeFiles.length() <= 0) {
            return properties;
        }
        StringTokenizer tok = new StringTokenizer(includeFiles, ",");
        while (tok.hasMoreTokens()) {
            String includeFilename = tok.nextToken().trim();
            File includeFile = new File(this.getParentDirectory(configurationFile), includeFilename);
            if (!includeFile.exists()) continue;
            Properties includeProperties = this.readConfigurationFile(includeFile, replaceStrings);
            Enumeration includePropertiesEnum = ((Hashtable)includeProperties).keys();
            while (includePropertiesEnum.hasMoreElements()) {
                String includeKey;
                String include = (String)includePropertiesEnum.nextElement();
                if (include.startsWith("+")) {
                    StringBuffer newValue;
                    includeKey = include.substring(1);
                    if (((Hashtable)properties).containsKey(includeKey)) {
                        newValue = new StringBuffer((String)((Hashtable)properties).get(includeKey));
                        newValue.append(",");
                        newValue.append(((Hashtable)includeProperties).get(include));
                    } else {
                        newValue = new StringBuffer((String)((Hashtable)includeProperties).get(include));
                    }
                    properties.setProperty(includeKey, newValue.toString());
                    continue;
                }
                if (include.startsWith("-")) {
                    includeKey = include.substring(1);
                    if (!((Hashtable)properties).containsKey(includeKey)) continue;
                    String includeValue = (String)((Hashtable)includeProperties).get(include);
                    if (includeValue == null || includeValue.trim().length() <= 0) {
                        ((Hashtable)properties).remove(includeKey);
                        continue;
                    }
                    StringBuffer newValue = new StringBuffer();
                    StringTokenizer includeTokenizer = new StringTokenizer(includeValue, ",");
                    HashSet<String> includeTokens = new HashSet<String>();
                    while (includeTokenizer.hasMoreElements()) {
                        String token = (String)includeTokenizer.nextElement();
                        includeTokens.add(token.trim());
                    }
                    String oldValue = (String)((Hashtable)properties).get(includeKey);
                    StringTokenizer tokenizer = new StringTokenizer(oldValue, ",");
                    boolean isFirstValue = true;
                    while (tokenizer.hasMoreElements()) {
                        String token = (String)tokenizer.nextElement();
                        if (includeTokens.contains(token.trim())) continue;
                        if (!isFirstValue) {
                            newValue.append(',');
                        }
                        newValue.append(token);
                        isFirstValue = false;
                    }
                    properties.setProperty(includeKey, newValue.toString());
                    continue;
                }
                if (include.startsWith("=")) {
                    include = include.substring(1);
                }
                properties.setProperty(include, (String)((Hashtable)includeProperties).get(include));
            }
        }
        return properties;
    }

    private Properties importProperties(Object caller, String configurationFile, Properties replaceStrings, Properties properties) throws Exception {
        String includeFiles = (String)((Hashtable)properties).get(CONFIG_INCLUDE);
        if (includeFiles == null || includeFiles.length() <= 0) {
            return properties;
        }
        StringTokenizer tok = new StringTokenizer(includeFiles, ",");
        while (tok.hasMoreTokens()) {
            String includeFilename = tok.nextToken().trim();
            try {
                Properties includeProperties = this.readConfigurationFile(caller, includeFilename, replaceStrings);
                Enumeration includePropertiesEnum = ((Hashtable)includeProperties).keys();
                while (includePropertiesEnum.hasMoreElements()) {
                    String includeKey;
                    String include = (String)includePropertiesEnum.nextElement();
                    if (include.startsWith("+")) {
                        StringBuffer newValue;
                        includeKey = include.substring(1);
                        if (((Hashtable)properties).containsKey(includeKey)) {
                            newValue = new StringBuffer((String)((Hashtable)properties).get(includeKey));
                            newValue.append(",");
                            newValue.append(((Hashtable)includeProperties).get(include));
                        } else {
                            newValue = new StringBuffer((String)((Hashtable)includeProperties).get(include));
                        }
                        properties.setProperty(includeKey, newValue.toString());
                        continue;
                    }
                    if (include.startsWith("-")) {
                        includeKey = include.substring(1);
                        if (!((Hashtable)properties).containsKey(includeKey)) continue;
                        String includeValue = (String)((Hashtable)includeProperties).get(include);
                        if (includeValue == null || includeValue.trim().length() <= 0) {
                            ((Hashtable)properties).remove(includeKey);
                            continue;
                        }
                        StringBuffer newValue = new StringBuffer();
                        StringTokenizer includeTokenizer = new StringTokenizer(includeValue, ",");
                        HashSet<String> includeTokens = new HashSet<String>();
                        while (includeTokenizer.hasMoreElements()) {
                            String token = (String)includeTokenizer.nextElement();
                            includeTokens.add(token.trim());
                        }
                        String oldValue = (String)((Hashtable)properties).get(includeKey);
                        StringTokenizer tokenizer = new StringTokenizer(oldValue, ",");
                        boolean isFirstValue = true;
                        while (tokenizer.hasMoreElements()) {
                            String token = (String)tokenizer.nextElement();
                            if (includeTokens.contains(token.trim())) continue;
                            if (!isFirstValue) {
                                newValue.append(',');
                            }
                            newValue.append(token);
                            isFirstValue = false;
                        }
                        properties.setProperty(includeKey, newValue.toString());
                        continue;
                    }
                    if (include.startsWith("=")) {
                        include = include.substring(1);
                    }
                    properties.setProperty(include, (String)((Hashtable)includeProperties).get(include));
                }
            }
            catch (FileNotFoundException x) {
                // empty catch block
            }
        }
        return properties;
    }

    public static synchronized ConfigurationManager getInstance() {
        if (s_configurationManager == null) {
            s_configurationManager = new ConfigurationManager();
        }
        return s_configurationManager;
    }

    public static Properties getSubProperties(Properties properties, String base) {
        if (properties == null) {
            return null;
        }
        Properties result = new Properties();
        Properties propertiesClone = (Properties)((Hashtable)properties).clone();
        String prefix = base + ".";
        Enumeration<?> keys = propertiesClone.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(base)) {
                ((Hashtable)result).put("", ((Hashtable)propertiesClone).get(key));
                continue;
            }
            if (!key.startsWith(prefix)) continue;
            ((Hashtable)result).put(key.substring(prefix.length()), ((Hashtable)propertiesClone).get(key));
        }
        return result;
    }
}

