/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.cache.memory;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.util.cache.CacheEntryList;
import com.sapportals.trex.util.cache.ICache;
import com.sapportals.trex.util.cache.ICacheEntry;
import com.sapportals.trex.util.cache.ICacheStatistics;
import com.sapportals.trex.util.cache.memory.MemoryCacheEntry;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MemoryLRUCache
implements ICache,
ICacheStatistics {
    private static Location s_log = Location.getLocation((String)(class$com$sapportals$trex$util$cache$memory$MemoryLRUCache == null ? (class$com$sapportals$trex$util$cache$memory$MemoryLRUCache = MemoryLRUCache.class$("com.sapportals.trex.util.cache.memory.MemoryLRUCache")) : class$com$sapportals$trex$util$cache$memory$MemoryLRUCache).getName());
    private final String m_id;
    private final int m_capacity;
    private final long m_maxCacheSize;
    private final long m_maxEntrySize;
    private final long m_averageEntrySize;
    private final int m_defaultTimeToLive;
    private final Map m_cache;
    private final MemoryCacheEntry[] m_entries;
    private final int[] m_next;
    private final int[] m_prev;
    private int m_head;
    private int m_tail;
    private int m_free;
    private long m_size;
    private int m_entryCount;
    private long m_addCount;
    private long m_removeCount;
    private long m_getCount;
    private long m_hitCount;
    static /* synthetic */ Class class$com$sapportals$trex$util$cache$memory$MemoryLRUCache;

    public MemoryLRUCache(String cacheID, Properties properties) throws TrexException {
        this.m_id = cacheID;
        int capacity = 1000;
        long maxCacheSize = 0L;
        long maxEntrySize = 0L;
        long averageEntrySize = 0L;
        int defaultTimeToLive = 300;
        if (properties == null) {
            s_log.warningT("properties for cache " + cacheID + " missing in WCM configuration");
        } else {
            try {
                capacity = Integer.parseInt(properties.getProperty("capacity"));
            }
            catch (Exception e) {
                s_log.warningT("property capacity for cache " + cacheID + " missing in WCM configuration");
            }
            try {
                maxCacheSize = Long.parseLong(properties.getProperty("maxsize"));
            }
            catch (Exception e) {
                s_log.warningT("property maxsize for cache " + cacheID + " missing in WCM configuration");
            }
            try {
                maxEntrySize = Long.parseLong(properties.getProperty("maxentrysize"));
            }
            catch (Exception e) {
                s_log.warningT("property maxentrysize for cache " + cacheID + " missing in WCM configuration");
            }
            try {
                averageEntrySize = Long.parseLong(properties.getProperty("averageentrysize"));
            }
            catch (Exception e) {
                s_log.warningT("property averageentrysize for cache " + cacheID + " missing in WCM configuration");
            }
            try {
                defaultTimeToLive = Integer.parseInt(properties.getProperty("defaulttimetolive"));
            }
            catch (Exception e) {
                s_log.warningT("property defaulttimetolive for cache " + cacheID + " missing in WCM configuration");
            }
        }
        this.m_capacity = capacity;
        this.m_maxCacheSize = maxCacheSize;
        this.m_maxEntrySize = maxEntrySize;
        this.m_averageEntrySize = averageEntrySize;
        this.m_defaultTimeToLive = defaultTimeToLive;
        this.m_cache = new HashMap(this.m_capacity);
        this.m_entries = new MemoryCacheEntry[this.m_capacity];
        this.m_next = new int[this.m_capacity];
        this.m_prev = new int[this.m_capacity];
        this.clearCache();
        this.resetCounters();
    }

    public String getID() {
        return null;
    }

    public long getMaximumEntryCount() {
        return 0L;
    }

    public void addEntry(ICacheEntry entry) throws TrexException {
        if (entry == null) {
            throw new NullPointerException();
        }
        this.localAddEntry(entry.getKey(), entry.getObject(), entry.getTimeToLive(), entry.getExpirationTime(), entry.getSize(), entry.isAutoDelaying());
    }

    public void addEntry(String key, Object object) throws TrexException {
        this.addEntry(key, object, this.m_defaultTimeToLive, this.m_averageEntrySize);
    }

    public void addEntry(String key, Object object, int timeToLive) throws TrexException {
        this.addEntry(key, object, timeToLive, this.m_averageEntrySize);
    }

    public void addEntryAutoDelay(String key, Object object, int timeToLive) throws TrexException {
        this.addEntryAutoDelay(key, object, timeToLive, this.m_averageEntrySize);
    }

    public void addEntry(String key, Object object, int timeToLive, long size) throws TrexException {
        this.localAddEntry(key, object, timeToLive, timeToLive == 0 ? 0L : System.currentTimeMillis() + (long)timeToLive * 1000L, size, false);
    }

    public void addEntryAutoDelay(String key, Object object, int timeToLive, long size) throws TrexException {
        this.localAddEntry(key, object, timeToLive, timeToLive == 0 ? 0L : System.currentTimeMillis() + (long)timeToLive * 1000L, size, true);
    }

    public ICacheEntry getEntry(String key) throws TrexException {
        if (s_log.beDebug()) {
            s_log.debugT("cache " + this.m_id + " get " + key);
        }
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            ++this.m_getCount;
            Object cachedObject = this.m_cache.get(key);
            if (cachedObject == null) {
                ICacheEntry iCacheEntry = null;
                return iCacheEntry;
            }
            MemoryCacheEntry entry = (MemoryCacheEntry)cachedObject;
            if (entry.isExpired()) {
                if (s_log.beDebug()) {
                    s_log.debugT("cache " + this.m_id + " initiale removal " + key + " (expired)");
                }
                this.removeEntry(entry);
                ICacheEntry iCacheEntry = null;
                return iCacheEntry;
            }
            if (entry.isAutoDelaying()) {
                if (s_log.beDebug()) {
                    s_log.debugT("cache " + this.m_id + " delay " + key);
                }
                entry.delayExpiration();
            }
            this.moveToFront(entry.getIndex());
            ++this.m_hitCount;
            MemoryCacheEntry memoryCacheEntry = entry;
            return memoryCacheEntry;
        }
    }

    public boolean removeEntry(ICacheEntry entry) throws TrexException {
        if (entry == null) {
            throw new NullPointerException();
        }
        return this.removeEntry(entry.getKey());
    }

    public boolean removeEntry(String key) throws TrexException {
        if (s_log.beDebug()) {
            s_log.debugT("cache " + this.m_id + " remove " + key);
        }
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            Object cachedObject = this.m_cache.get(key);
            if (cachedObject == null) {
                boolean bl = false;
                return bl;
            }
            MemoryCacheEntry entry = (MemoryCacheEntry)cachedObject;
            this.m_size -= entry.getSize();
            this.m_cache.remove(key);
            this.remove(entry.getIndex());
            entry.setObject(null);
            entry.setKey(null);
            ++this.m_removeCount;
            boolean bl = true;
            return bl;
        }
    }

    public boolean removeEntriesStartingWith(String prefix) throws TrexException {
        boolean result = false;
        LinkedList<String> keysToRemove = new LinkedList<String>();
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            int i = this.m_head;
            while (i >= 0) {
                String key;
                MemoryCacheEntry entry = this.m_entries[i];
                if (entry != null && (key = entry.getKey()) != null && key.startsWith(prefix)) {
                    keysToRemove.add(key);
                }
                i = this.m_next[i];
            }
        }
        Iterator iter = keysToRemove.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            result |= this.removeEntry(key);
        }
        return result;
    }

    public boolean containsEntry(String key) throws TrexException {
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            boolean bl = this.m_cache.containsKey(key);
            return bl;
        }
    }

    public Enumeration keys() throws TrexException {
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            IterEnumeration iterEnumeration = new IterEnumeration(this.m_cache.keySet().iterator());
            return iterEnumeration;
        }
    }

    public Set keySet() {
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            Set set = this.m_cache.keySet();
            return set;
        }
    }

    public CacheEntryList elements() throws TrexException {
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            CacheEntryList list = new CacheEntryList();
            int i = this.m_head;
            while (i >= 0) {
                list.add(this.m_entries[i]);
                i = this.m_next[i];
            }
            CacheEntryList cacheEntryList = list;
            return cacheEntryList;
        }
    }

    public void clearCache() throws TrexException {
        if (s_log.beDebug()) {
            s_log.debugT("cache " + this.m_id + " cleared");
        }
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            this.m_cache.clear();
            this.m_size = 0L;
            this.m_entryCount = 0;
            this.m_head = -1;
            this.m_tail = -1;
            this.m_free = 0;
            int i = 0;
            while (i < this.m_capacity) {
                this.m_next[i] = i + 1;
                ++i;
            }
            this.m_next[this.m_capacity - 1] = -1;
        }
    }

    public void refresh() throws TrexException {
        LinkedList<MemoryCacheEntry> entriesToRemove = new LinkedList<MemoryCacheEntry>();
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            int i = this.m_head;
            while (i >= 0) {
                MemoryCacheEntry entry = this.m_entries[i];
                if (entry != null && entry.getKey() != null && entry.isExpired()) {
                    entriesToRemove.add(entry);
                }
                i = this.m_next[i];
            }
        }
        Iterator iter = entriesToRemove.iterator();
        while (iter.hasNext()) {
            ICacheEntry entry = (ICacheEntry)iter.next();
            if (s_log.beDebug()) {
                s_log.debugT("cache " + this.m_id + " initiale removal " + entry.getKey() + " (expired)");
            }
            this.removeEntry(entry);
        }
    }

    public int getCapacity() {
        return this.m_capacity;
    }

    public long getMaxEntrySize() {
        return this.m_maxEntrySize;
    }

    public long getEntryCount() {
        return this.m_entryCount;
    }

    public long getAddCount() {
        return this.m_addCount;
    }

    public long getRemoveCount() {
        return this.m_removeCount;
    }

    public long getGetCount() {
        return this.m_getCount;
    }

    public long getHitCount() {
        return this.m_hitCount;
    }

    public void resetCounters() {
        this.m_addCount = 0L;
        this.m_removeCount = 0L;
        this.m_getCount = 0L;
        this.m_hitCount = 0L;
    }

    private void localAddEntry(String key, Object object, long timeToLive, long expirationTime, long size, boolean autoDelay) throws TrexException {
        if (key == null) {
            throw new NullPointerException();
        }
        MemoryLRUCache memoryLRUCache = this;
        synchronized (memoryLRUCache) {
            if (this.m_maxEntrySize > 0L && size > this.m_maxEntrySize) {
                return;
            }
            Object cachedObject = this.m_cache.get(key);
            if (cachedObject != null) {
                if (s_log.beDebug()) {
                    s_log.debugT("cache " + this.m_id + " add " + key + " (exists)");
                }
                MemoryCacheEntry entry = (MemoryCacheEntry)cachedObject;
                this.m_size -= entry.getSize();
                entry.setObject(object);
                entry.setTimeToLive(timeToLive);
                entry.setExpirationTime(expirationTime);
                entry.updateModificationTime();
                entry.setSize(size);
                entry.setAutoDelay(autoDelay);
                this.moveToFront(entry.getIndex());
            } else {
                if (this.m_free >= 0) {
                    if (s_log.beDebug()) {
                        s_log.debugT("cache " + this.m_id + " add " + key + " (new)");
                    }
                    int index = this.m_free;
                    this.m_free = this.m_next[this.m_free];
                    this.insertAtHead(index);
                    if (this.m_entries[this.m_head] == null) {
                        this.m_entries[this.m_head] = new MemoryCacheEntry(this.m_head);
                    }
                } else {
                    if (s_log.beDebug()) {
                        s_log.debugT("cache " + this.m_id + " add " + key + " replacing " + this.m_entries[this.m_tail].getKey());
                    }
                    this.m_size -= this.m_entries[this.m_tail].getSize();
                    this.m_cache.remove(this.m_entries[this.m_tail].getKey());
                    this.moveToFront(this.m_tail);
                }
                this.m_entries[this.m_head].setKey(key);
                this.m_entries[this.m_head].setObject(object);
                this.m_entries[this.m_head].setTimeToLive(timeToLive);
                this.m_entries[this.m_head].setExpirationTime(expirationTime);
                this.m_entries[this.m_head].updateModificationTime();
                this.m_entries[this.m_head].setSize(size);
                this.m_entries[this.m_head].setAutoDelay(autoDelay);
                this.m_cache.put(key, this.m_entries[this.m_head]);
            }
            this.m_size += size;
            while (this.m_maxCacheSize > 0L && this.m_size > this.m_maxCacheSize) {
                if (s_log.beDebug()) {
                    s_log.debugT("cache " + this.m_id + " initiale removal " + this.m_entries[this.m_tail].getKey() + " (cache full)");
                }
                this.removeEntry(this.m_entries[this.m_tail].getKey());
            }
            ++this.m_addCount;
        }
    }

    private void insertAtHead(int index) {
        if (this.m_head < 0) {
            this.m_head = this.m_tail = index;
            this.m_prev[index] = -1;
            this.m_next[index] = -1;
            this.m_entryCount = 1;
        } else {
            this.m_prev[this.m_head] = index;
            this.m_prev[index] = -1;
            this.m_next[index] = this.m_head;
            this.m_head = index;
            ++this.m_entryCount;
        }
    }

    private void moveToFront(int index) {
        if (this.m_head != index) {
            int previndex = this.m_prev[index];
            int nextindex = this.m_next[index];
            if (previndex >= 0) {
                this.m_next[previndex] = nextindex;
                if (this.m_tail == index) {
                    this.m_tail = previndex;
                }
            }
            if (nextindex >= 0) {
                this.m_prev[nextindex] = previndex;
            }
            if (this.m_head >= 0) {
                this.m_prev[this.m_head] = index;
            }
            this.m_prev[index] = -1;
            this.m_next[index] = this.m_head;
            this.m_head = index;
        }
    }

    private void append(int index) {
        if (this.m_head < 0) {
            this.m_head = this.m_tail = index;
            this.m_next[index] = -1;
            this.m_prev[index] = -1;
            this.m_entryCount = 1;
        } else {
            this.m_next[this.m_tail] = index;
            this.m_next[index] = -1;
            this.m_prev[index] = this.m_tail;
            this.m_tail = index;
            ++this.m_entryCount;
        }
    }

    private void remove(int index) {
        int previndex = this.m_prev[index];
        int nextindex = this.m_next[index];
        if (previndex >= 0) {
            this.m_next[previndex] = nextindex;
        }
        if (nextindex >= 0) {
            this.m_prev[nextindex] = previndex;
        }
        if (this.m_head == index) {
            this.m_head = nextindex;
        }
        if (this.m_tail == index) {
            this.m_tail = previndex;
        }
        this.m_next[index] = this.m_free;
        this.m_free = index;
        --this.m_entryCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IterEnumeration
    implements Enumeration {
        private final Iterator m_iter;

        public IterEnumeration(Iterator iter) {
            this.m_iter = iter;
        }

        public boolean hasMoreElements() {
            return this.m_iter.hasNext();
        }

        public Object nextElement() {
            return this.m_iter.next();
        }
    }
}

