/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.cache.memory;

import com.sapportals.trex.util.cache.ICacheEntry;
import java.util.Date;

public class MemoryCacheEntry
implements ICacheEntry {
    private String m_key = null;
    private Object m_object = null;
    private long m_timeToLive = 0L;
    private long m_expirationTime = 0L;
    private long m_modificationTime;
    private long m_size = 0L;
    private boolean m_autoDelay = false;
    private int m_index = 0;

    protected MemoryCacheEntry(int index) {
        this.m_index = index;
        this.updateModificationTime();
    }

    public String getKey() {
        return this.m_key;
    }

    public Object getObject() {
        return this.m_object;
    }

    public long getSize() {
        return this.m_size;
    }

    public long getTimeToLive() {
        return this.m_timeToLive;
    }

    public long getExpirationTime() {
        return this.m_expirationTime;
    }

    public long getModificationTime() {
        return this.m_modificationTime;
    }

    public boolean isExpired() {
        return this.m_expirationTime == 0L ? false : this.m_expirationTime < new Date().getTime();
    }

    public boolean isAutoDelaying() {
        return this.m_autoDelay;
    }

    protected void setKey(String key) {
        this.m_key = key;
    }

    protected void setObject(Object object) {
        this.m_object = object;
    }

    protected void setSize(long size) {
        this.m_size = size;
    }

    protected void setTimeToLive(long timeToLive) {
        this.m_timeToLive = timeToLive;
    }

    protected void setExpirationTime(long expirationTime) {
        this.m_expirationTime = expirationTime;
    }

    protected void updateModificationTime() {
        this.m_modificationTime = new Date().getTime();
    }

    protected int getIndex() {
        return this.m_index;
    }

    protected void setAutoDelay(boolean newState) {
        this.m_autoDelay = newState;
    }

    protected boolean delayExpiration() {
        if (this.m_expirationTime == 0L) {
            return false;
        }
        this.m_expirationTime += this.m_timeToLive * 1000L;
        return true;
    }
}

