/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.cache;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.util.cache.CacheEntryList;
import com.sapportals.trex.util.cache.ICacheEntry;
import java.util.Enumeration;
import java.util.Set;

public interface ICache {
    public static final String DEFAULT_CACHE_TYPE = "memory";
    public static final String DEFAULT_CACHE_CLASS = "com.sapportals.trex.util.cache.memory.MemoryLRUCache";
    public static final int DEFAULT_CAPACITY = 1000;
    public static final long DEFAULT_MAX_CACHE_SIZE = 0L;
    public static final long DEFAULT_MAX_ENTRY_SIZE = 0L;
    public static final long DEFAULT_AVG_ENTRY_SIZE = 0L;
    public static final int DEFAULT_TIME_TO_LIVE = 300;
    public static final String DEFAULT_STORAGE_CLASS = "com.sapportals.trex.util.cache.persistent.filesystem.FilesystemMap";
    public static final String DEFAULT_FOLDER = "/tmp";
    public static final String DEFAULT_FILE_PREFIX = "cache_";
    public static final boolean DEFAULT_SECURE = false;
    public static final boolean DEFAULT_CLEAR_CACHE_ON_INIT = true;
    public static final boolean DEFAULT_SINGLETON = true;
    public static final boolean DEFAULT_AUTO_DELAY_EXPIRATION = true;

    public void addEntry(ICacheEntry var1) throws TrexException;

    public void addEntry(String var1, Object var2) throws TrexException;

    public void addEntry(String var1, Object var2, int var3) throws TrexException;

    public void addEntryAutoDelay(String var1, Object var2, int var3) throws TrexException;

    public void addEntry(String var1, Object var2, int var3, long var4) throws TrexException;

    public void addEntryAutoDelay(String var1, Object var2, int var3, long var4) throws TrexException;

    public String getID();

    public ICacheEntry getEntry(String var1) throws TrexException;

    public boolean removeEntry(ICacheEntry var1) throws TrexException;

    public boolean removeEntry(String var1) throws TrexException;

    public boolean removeEntriesStartingWith(String var1) throws TrexException;

    public boolean containsEntry(String var1) throws TrexException;

    public Enumeration keys() throws TrexException;

    public Set keySet() throws TrexException;

    public CacheEntryList elements() throws TrexException;

    public void clearCache() throws TrexException;

    public void refresh() throws TrexException;

    public int getCapacity();

    public long getMaxEntrySize();
}

