/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.cache;

import com.sap.tc.logging.Location;
import com.sapportals.trex.util.cache.CacheFactory;
import com.sapportals.trex.util.cache.ICache;
import com.sapportals.trex.util.cache.WrappedCache;
import java.io.File;
import java.io.FileInputStream;

public class CacheManager {
    private static CacheManager m_instance = null;
    private static boolean m_useFileSystem = true;
    private static Object m_cacheFactory = null;
    private static String CONFIG_FILE = "trexcache.properties";
    public static String CONTENTS = "configManager=com.sapportals.trex.util.config.fwk.CfwPropertyStore";
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$util$cache$CacheManager == null ? (class$com$sapportals$trex$util$cache$CacheManager = CacheManager.class$("com.sapportals.trex.util.cache.CacheManager")) : class$com$sapportals$trex$util$cache$CacheManager).getName());
    static /* synthetic */ Class class$com$sapportals$trex$util$cache$CacheManager;

    private CacheManager() {
    }

    public synchronized WrappedCache getCache(String cacheId) {
        WrappedCache cache = null;
        if (m_cacheFactory == null) {
            m_useFileSystem = this.useFileSystem();
            try {
                m_cacheFactory = m_useFileSystem ? CacheFactory.getInstance() : CacheFactory.getInstancePropsService();
                log.debugT("Used CacheFactory: " + m_cacheFactory.getClass());
            }
            catch (Exception e) {
                log.debugT("Cannot get CacheFactory. Reason: " + e.toString());
            }
        }
        ICache tmpcache = null;
        if (m_cacheFactory != null) {
            try {
                tmpcache = ((CacheFactory)m_cacheFactory).getCache(cacheId);
                return new WrappedCache(m_useFileSystem, tmpcache);
            }
            catch (Exception e) {
                log.debugT("Cannot get Cache. Reason: " + e.toString());
            }
        }
        return cache;
    }

    public static synchronized CacheManager getInstance() {
        if (m_instance == null) {
            m_instance = new CacheManager();
        }
        return m_instance;
    }

    protected synchronized boolean useFileSystem() {
        boolean useFileSystem = false;
        String path = CacheManager.getClassPath(this.getClass());
        File f = path != null ? new File(new File(path).getParent(), CONFIG_FILE) : new File(CONFIG_FILE);
        if (f.exists()) {
            byte[] buffer = new byte[CONTENTS.length() + 1];
            try {
                FileInputStream fs = new FileInputStream(f);
                fs.read(buffer);
                fs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            useFileSystem = true;
        }
        return useFileSystem;
    }

    private static String getClassPath(Class cls) {
        try {
            ClassLoader cl = cls.getClassLoader();
            String rsrc = cls.getName().replace('.', '/') + ".class";
            String url = cl.getResource(rsrc).toString();
            if (url.startsWith("jar:file:")) {
                return url.substring(9, url.length() - rsrc.length() - 2);
            }
            if (url.startsWith("file:")) {
                return url.substring(6);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

