/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.cache;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.util.cache.ICache;
import com.sapportals.trex.util.config.ConfigurationManager;
import com.sapportals.trex.util.string.StrUtil;
import com.sapportals.trex.util.uuid.UUID;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CacheFactory {
    private static final String CFG_INCLUDE = "include";
    public static final String CFG_FILE_NAME = "trexcache.properties";
    public static final String CFG_KEY_PREFIX = "cache";
    public static final String CFG_KEY_TEMPLATE_PREFIX = "template";
    public static final String CFG_CACHES_KEY = "caches";
    public static final String CFG_TEMPLATES_KEY = "templates";
    public static final String CFG_TEMPLATE_KEY = "template";
    public static final String CFG_CAPACITY_KEY = "capacity";
    public static final String CFG_MAX_CACHE_SIZE_KEY = "maxsize";
    public static final String CFG_AVERAGE_ENTRY_SIZE_KEY = "averageentrysize";
    public static final String CFG_MAX_ENTRY_SIZE_KEY = "maxentrysize";
    public static final String CFG_CACHE_CLASS_KEY = "class";
    public static final String CFG_CACHE_TYPE_KEY = "type";
    public static final String CFG_STORAGE_CLASS_KEY = "storageclass";
    public static final String CFG_FOLDER_KEY = "folder";
    public static final String CFG_FILE_PREFIX_KEY = "fileprefix";
    public static final String CFG_SECURE_KEY = "secure";
    public static final String CFG_CLEAR_CACHE_ON_INIT_KEY = "clearcacheoninit";
    public static final String CFG_PERSISTENT_KEY = "persistent";
    public static final String CFG_MEMORY_KEY = "memory";
    public static final String CFG_DEFAULT_TIME_TO_LIVE_KEY = "defaulttimetolive";
    public static final String CFG_SINGLETON_KEY = "singleton";
    private static final int CFG_MAX_READ_RECURSION_LEVEL = 10;
    private static Location s_log = Location.getLocation((String)(class$com$sapportals$trex$util$cache$CacheFactory == null ? (class$com$sapportals$trex$util$cache$CacheFactory = CacheFactory.class$("com.sapportals.trex.util.cache.CacheFactory")) : class$com$sapportals$trex$util$cache$CacheFactory).getName());
    private static CacheFactory s_cacheFactory = null;
    private Properties m_properties = null;
    private Properties m_templateProperties = null;
    private Set m_configuredCaches = null;
    private Set m_configuredTemplates = null;
    private Hashtable m_singletonCaches = null;
    private Hashtable m_allCaches = null;
    private RefreshThread m_refreshThread = null;
    static /* synthetic */ Class class$com$sapportals$trex$util$cache$CacheFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    private CacheFactory(Properties templateProperties, Properties properties) throws ClassNotFoundException, TrexException {
        String configuredCaches;
        if (properties == null) {
            throw new NullPointerException();
        }
        this.m_properties = properties;
        this.m_templateProperties = templateProperties;
        String configuredTemplates = (String)((Hashtable)properties).get(CFG_TEMPLATES_KEY);
        if (configuredTemplates != null) {
            this.m_configuredTemplates = StrUtil.extractStringComponentsToSet(configuredTemplates, 44, true);
        }
        if ((configuredCaches = (String)((Hashtable)properties).get(CFG_CACHES_KEY)) == null) {
            s_log.warningT("no supported cache list - check TREX Cache configuration");
        } else {
            this.m_configuredCaches = StrUtil.extractStringComponentsToSet(configuredCaches, 44, true);
            if (this.m_configuredCaches == null || this.m_configuredCaches.isEmpty()) {
                s_log.warningT("supported cache list is empty -  check TREX Cache configuration");
            } else {
                this.checkConfiguredCachesProperties();
            }
        }
        this.m_singletonCaches = new Hashtable();
        this.m_allCaches = new Hashtable();
        this.m_refreshThread = new RefreshThread();
        this.m_refreshThread.setName("SAPEngine_TREXRefreshCache_0");
        this.startRefreshThread();
    }

    public void finalize() {
        this.stopRefreshThread();
    }

    public static synchronized CacheFactory getInstance() throws ClassNotFoundException, TrexException {
        if (s_cacheFactory == null) {
            s_cacheFactory = new CacheFactory(CacheFactory.readTemplateConfiguration(), CacheFactory.readConfiguration());
        }
        return s_cacheFactory;
    }

    public static synchronized CacheFactory getInstancePropsService() throws ClassNotFoundException, TrexException {
        if (s_cacheFactory == null) {
            TrexConfigManager config = TrexFactory.getTrexConfigManager();
            Properties props = config.getCacheProperties();
            if (props != null) {
                s_cacheFactory = new CacheFactory(CacheFactory.readTemplateConfiguration(false), props);
            } else {
                s_log.errorT("Cache properties cannot be read. -> null");
            }
        }
        return s_cacheFactory;
    }

    public synchronized ICache getCache(String cacheID) throws ClassNotFoundException, TrexException {
        if (cacheID == null) {
            throw new NullPointerException();
        }
        Object cachedCache = this.m_singletonCaches.get(cacheID = cacheID.trim());
        if (cachedCache != null) {
            return (ICache)cachedCache;
        }
        String className = (String)((Hashtable)this.m_properties).get(cacheID + "." + CFG_CACHE_CLASS_KEY);
        if (className == null) {
            s_log.warningT("cache " + cacheID + " class not found - check WCM configuration");
            className = "com.sapportals.trex.util.cache.memory.MemoryLRUCache";
        }
        className = className.trim();
        ICache result = null;
        try {
            Class<?> cacheClass = Class.forName(className);
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CacheFactory.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = CacheFactory.class$("java.util.Properties")) : class$java$util$Properties};
            Constructor<?> cacheConstructor = cacheClass.getConstructor(paramTypes);
            Properties cacheProperties = this.AddTemplateProperties(cacheID, ConfigurationManager.getSubProperties(this.m_properties, cacheID));
            Object[] initArgs = new Object[]{cacheID, cacheProperties};
            result = (ICache)cacheConstructor.newInstance(initArgs);
            if (result != null) {
                if (this.isPersistent(cacheProperties) || this.isMemory(cacheProperties) && this.isSingleton(cacheProperties)) {
                    this.m_singletonCaches.put(cacheID, result);
                    this.m_allCaches.put(cacheID, result);
                } else {
                    this.m_allCaches.put(cacheID + "_" + new UUID().toString(), result);
                }
            }
        }
        catch (ClassNotFoundException e) {
            s_log.throwing("class " + className + " not found", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            s_log.throwing("can't load class " + className, (Throwable)e);
            return null;
        }
        return result;
    }

    public static String getUniqueCacheID() {
        return new UUID().toString();
    }

    public synchronized ICache getCache(String cacheID, Properties properties) throws ClassNotFoundException, TrexException {
        String className;
        if (cacheID == null || properties == null) {
            throw new NullPointerException();
        }
        Object cachedCache = this.m_singletonCaches.get(cacheID = cacheID.trim());
        if (cachedCache != null) {
            return (ICache)cachedCache;
        }
        if (this.m_configuredCaches.contains(cacheID)) {
            s_log.warningT("passed properties override preconfigured properties for cache " + cacheID);
        }
        if ((className = (String)((Hashtable)properties).get(CFG_CACHE_CLASS_KEY)) == null) {
            s_log.warningT("cache class not found");
            className = "com.sapportals.trex.util.cache.memory.MemoryLRUCache";
        }
        className = className.trim();
        ICache result = null;
        try {
            Class<?> cacheClass = Class.forName(className);
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CacheFactory.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = CacheFactory.class$("java.util.Properties")) : class$java$util$Properties};
            Constructor<?> cacheConstructor = cacheClass.getConstructor(paramTypes);
            Object[] initArgs = new Object[]{cacheID, properties};
            result = (ICache)cacheConstructor.newInstance(initArgs);
            if (result != null) {
                if (this.isPersistent(properties) || this.isMemory(properties) && this.isSingleton(properties)) {
                    this.m_singletonCaches.put(cacheID, result);
                    this.m_allCaches.put(cacheID, result);
                } else {
                    this.m_allCaches.put(cacheID + "_" + new UUID().toString(), result);
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            s_log.errorT("class " + className + " not found");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            s_log.errorT("can't load class " + className);
            return null;
        }
        return result;
    }

    public Hashtable getAllCaches() {
        return this.m_allCaches;
    }

    private static Properties readTemplateConfiguration() throws TrexException {
        try {
            return ConfigurationManager.getSubProperties(ConfigurationManager.getInstance().loadProperties(CFG_FILE_NAME), "template");
        }
        catch (Exception e) {
            throw new TrexException(7204, e.getMessage());
        }
    }

    private static Properties readTemplateConfiguration(boolean nofile) throws TrexException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new TrexException(7204, e.getMessage());
        }
    }

    private static Properties readConfiguration() throws TrexException {
        try {
            return ConfigurationManager.getSubProperties(ConfigurationManager.getInstance().loadProperties(CFG_FILE_NAME), CFG_KEY_PREFIX);
        }
        catch (Exception e) {
            throw new TrexException(7204, e.getMessage());
        }
    }

    private String getCacheType(Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        Object cacheTypeObject = ((Hashtable)properties).get(CFG_CACHE_TYPE_KEY);
        if (cacheTypeObject != null) {
            return cacheTypeObject.toString();
        }
        return CFG_MEMORY_KEY;
    }

    private boolean isSingleton(Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        Object singletonObject = ((Hashtable)properties).get(CFG_SINGLETON_KEY);
        if (singletonObject != null) {
            return new Boolean(singletonObject.toString());
        }
        return true;
    }

    private boolean isPersistent(Properties properties) {
        return this.getCacheType(properties).equalsIgnoreCase(CFG_PERSISTENT_KEY);
    }

    private boolean isMemory(Properties properties) {
        return this.getCacheType(properties).equalsIgnoreCase(CFG_MEMORY_KEY);
    }

    private void checkConfiguredCachesProperties() throws TrexException {
        Iterator iterator = this.m_configuredCaches.iterator();
        while (iterator != null && iterator.hasNext()) {
            String cacheID = (String)iterator.next();
            if (cacheID == null) continue;
            this.checkProperties(cacheID, this.AddTemplateProperties(cacheID, ConfigurationManager.getSubProperties(this.m_properties, cacheID)));
        }
    }

    private Properties AddTemplateProperties(String cacheID, Properties properties) throws TrexException {
        String template = properties.getProperty("template");
        if (template == null) {
            return properties;
        }
        if (!this.m_configuredTemplates.contains(template)) {
            throw new TrexException(7204, "cache template " + template + " referenced by cache " + cacheID + " missing in WCM configuration (check templates list/template definition)");
        }
        Properties templateProperties = ConfigurationManager.getSubProperties(this.m_templateProperties, template);
        Enumeration keys = ((Hashtable)templateProperties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (((Hashtable)properties).containsKey(key)) continue;
            ((Hashtable)properties).put(key, ((Hashtable)templateProperties).get(key));
        }
        return properties;
    }

    private Properties checkProperties(String cacheID, Properties properties) throws TrexException {
        String cacheType;
        if (properties == null) {
            throw new TrexException(7204, "properties for cache " + cacheID + " missing in WCM configuration");
        }
        try {
            new Integer(((Hashtable)properties).get(CFG_CAPACITY_KEY).toString()).intValue();
        }
        catch (Exception e) {
            throw new TrexException(7204, "property capacity for cache " + cacheID + " missing in TREX configuration");
        }
        try {
            new Long(((Hashtable)properties).get(CFG_MAX_CACHE_SIZE_KEY).toString()).longValue();
        }
        catch (Exception e) {
            throw new TrexException(7204, "property maxsize for cache " + cacheID + " missing in TREX configuration");
        }
        try {
            new Long(((Hashtable)properties).get(CFG_MAX_ENTRY_SIZE_KEY).toString()).longValue();
        }
        catch (Exception e) {
            throw new TrexException(7204, "property maxentrysize for cache " + cacheID + " missing in TREX configuration");
        }
        try {
            new Integer(((Hashtable)properties).get(CFG_DEFAULT_TIME_TO_LIVE_KEY).toString()).intValue();
        }
        catch (Exception e) {
            throw new TrexException(7204, "property defaulttimetolive for cache " + cacheID + " missing in TREX configuration");
        }
        try {
            cacheType = ((Hashtable)properties).get(CFG_CACHE_TYPE_KEY).toString();
        }
        catch (Exception e) {
            throw new TrexException(7204, "property type for cache " + cacheID + " missing in WTREXCM configuration");
        }
        if (cacheType.equals(CFG_PERSISTENT_KEY)) {
            try {
                ((Hashtable)properties).get(CFG_STORAGE_CLASS_KEY).toString();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property storageclass for cache " + cacheID + " missing in TREX configuration");
            }
            try {
                ((Hashtable)properties).get(CFG_FOLDER_KEY).toString();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property folder for cache " + cacheID + " missing in TREX configuration");
            }
            try {
                ((Hashtable)properties).get(CFG_FILE_PREFIX_KEY).toString();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property fileprefix for cache " + cacheID + " missing in TREX configuration");
            }
            try {
                new Boolean(((Hashtable)properties).get(CFG_SECURE_KEY).toString()).booleanValue();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property secure for cache " + cacheID + " missing in TREX configuration");
            }
            try {
                new Boolean(((Hashtable)properties).get(CFG_CLEAR_CACHE_ON_INIT_KEY).toString()).booleanValue();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property clearcacheoninit for cache " + cacheID + " missing in TREX configuration");
            }
        }
        if (cacheType.equals(CFG_MEMORY_KEY)) {
            try {
                new Long(((Hashtable)properties).get(CFG_AVERAGE_ENTRY_SIZE_KEY).toString()).longValue();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property averageentrysize for cache " + cacheID + " missing in WCM configuration");
            }
            try {
                new Boolean(((Hashtable)properties).get(CFG_SINGLETON_KEY).toString()).booleanValue();
            }
            catch (Exception e) {
                throw new TrexException(7204, "property singleton for cache " + cacheID + " missing in WCM configuration");
            }
        }
        throw new TrexException(7204, "invalid type property for cache " + cacheID + " - check WCM configuration");
        return properties;
    }

    private void privateRefreshCaches() {
        Enumeration caches = this.m_allCaches.elements();
        while (caches != null && caches.hasMoreElements()) {
            ICache cache = (ICache)caches.nextElement();
            if (cache == null) continue;
            try {
                cache.refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static void refreshCaches() {
        if (s_cacheFactory != null) {
            s_cacheFactory.privateRefreshCaches();
        }
    }

    private void startRefreshThread() {
        this.m_refreshThread.start();
    }

    private void stopRefreshThread() {
        this.m_refreshThread.terminate();
    }

    public synchronized void resetFactory() {
        this.finalize();
        s_cacheFactory = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RefreshThread
    extends Thread {
        private static final long REFRESH_INTERVAL = 300L;
        private static final long SLEEP = 10L;
        private long m_nextTime = 0L;
        private boolean m_terminate = false;

        RefreshThread() {
        }

        public void run() {
            while (!this.m_terminate) {
                if (new Date().getTime() >= this.m_nextTime) {
                    CacheFactory.refreshCaches();
                    this.m_nextTime = new Date().getTime() + 300000L;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void terminate() {
            this.m_terminate = true;
            this.interrupt();
        }
    }
}

