/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.tns;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.net.BufferedInput;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.SAP_BOOL;
import com.sapportals.trex.core.net.SAP_INT;
import com.sapportals.trex.core.net.SAP_STRING;
import com.sapportals.trex.core.net.SAP_UINT;
import com.sapportals.trex.core.net.Serializable;
import com.sapportals.trex.core.net.StreamTypeException;
import com.sapportals.trex.core.net.UIntValueException;
import com.sapportals.trex.tns.TNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Transferable
implements Serializable {
    private String m_sMethod;
    private int m_errorCode;
    private String m_sMessage;
    private Hashtable m_StringParams;
    private Hashtable m_IntParams;
    private Hashtable m_BoolParams;
    private Hashtable m_StringVectorParams;
    private Hashtable m_NodeParams;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$tns$Transferable == null ? (class$com$sapportals$trex$tns$Transferable = Transferable.class$("com.sapportals.trex.tns.Transferable")) : class$com$sapportals$trex$tns$Transferable).getName());
    static /* synthetic */ Class class$com$sapportals$trex$tns$Transferable;

    public Transferable(String method) {
        this.m_sMethod = method;
        this.m_sMessage = "";
        this.m_errorCode = 0;
        this.m_StringParams = new Hashtable();
        this.m_IntParams = new Hashtable();
        this.m_BoolParams = new Hashtable();
        this.m_StringVectorParams = new Hashtable();
        this.m_NodeParams = new Hashtable();
    }

    public String getMethod() {
        return this.m_sMethod;
    }

    public synchronized boolean serialize(BufferedOutput theDestination) throws TrexException {
        TNode node = new TNode();
        try {
            theDestination.write(new SAP_STRING(this.m_sMethod));
            log.debugT("Request to NS: written method: " + this.m_sMethod);
        }
        catch (IOException ex) {
            log.errorT("writing method " + this.m_sMethod + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        try {
            theDestination.write(new SAP_INT(this.m_errorCode));
            log.debugT("Request to NS: written m_errorCode: " + this.m_errorCode);
        }
        catch (IOException ex) {
            log.errorT("writing errorcode " + this.m_errorCode + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        try {
            theDestination.write(new SAP_STRING(this.m_sMessage));
            log.debugT("Request to NS: written message: " + this.m_sMessage);
        }
        catch (IOException ex) {
            log.errorT("writing message " + this.m_sMessage + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        try {
            theDestination.write(new SAP_UINT(this.m_StringParams.size()));
            log.debugT("Request to NS: written StringParams size: " + this.m_StringParams.size());
        }
        catch (IOException ex) {
            log.errorT("writing " + this.m_StringParams.size() + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        catch (UIntValueException ex) {
            log.errorT("converting StringParams size " + this.m_StringParams.size() + ": " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        Enumeration e = this.m_StringParams.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            String sValue = (String)this.m_StringParams.get(sKey);
            try {
                theDestination.write(new SAP_STRING(sKey));
                log.debugT("Request to NS: written StringParams Name: " + sKey);
            }
            catch (IOException ex) {
                log.errorT("writing StringParams key " + sKey + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
            try {
                theDestination.write(new SAP_STRING(sValue));
                log.debugT("Request to NS: written StringParams Value: " + sValue);
            }
            catch (IOException ex) {
                log.errorT("writing StringParams value " + sValue + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
        }
        try {
            theDestination.write(new SAP_UINT(this.m_IntParams.size()));
            log.debugT("Request to NS: written IntParams size: " + this.m_IntParams.size());
        }
        catch (UIntValueException ex) {
            log.errorT("converting IntParams size " + this.m_IntParams.size() + ": " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        catch (IOException ex) {
            log.errorT("writing IntParams size " + this.m_IntParams.size() + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        Enumeration e2 = this.m_IntParams.keys();
        while (e2.hasMoreElements()) {
            String sKey = (String)e2.nextElement();
            int iValue = 0;
            try {
                iValue = (Integer)this.m_IntParams.get(sKey);
            }
            catch (Exception ex) {
                log.errorT("value not int : " + ex.getMessage() + ". Therefore set to '0'");
            }
            try {
                theDestination.write(new SAP_STRING(sKey));
                log.debugT("Request to NS: written IntParams Name: " + sKey);
            }
            catch (IOException ex) {
                log.errorT("writing IntParams key " + sKey + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
            try {
                theDestination.write(new SAP_UINT(iValue));
                log.debugT("Request to NS: written IntParams Value: " + iValue);
            }
            catch (UIntValueException ex) {
                log.errorT(ex.getMessage());
            }
            catch (IOException ex) {
                log.errorT("writing IntParams value" + iValue + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
        }
        try {
            theDestination.write(new SAP_UINT(this.m_BoolParams.size()));
            log.debugT("Request to NS: written BoolParams size: " + this.m_BoolParams.size());
        }
        catch (UIntValueException ex) {
            log.errorT(ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            log.errorT("writing BoolParams size " + this.m_BoolParams.size() + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        Enumeration e3 = this.m_BoolParams.keys();
        while (e3.hasMoreElements()) {
            String sKey = (String)e3.nextElement();
            boolean bValue = false;
            try {
                bValue = new Boolean((String)this.m_BoolParams.get(sKey));
            }
            catch (Exception ex) {
                log.errorT(ex.getMessage());
            }
            try {
                theDestination.write(new SAP_STRING(sKey));
                log.debugT("Request to NS: written BoolParams Name: " + sKey);
            }
            catch (IOException ex) {
                log.errorT("writing BoolParams key " + sKey + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
            try {
                theDestination.write(new SAP_BOOL(bValue));
                log.debugT("Request to NS: written BoolParams Name: " + bValue);
            }
            catch (IOException ex) {
                log.errorT("writing BoolParams value" + bValue + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
        }
        try {
            theDestination.write(new SAP_UINT(this.m_NodeParams.size()));
            log.debugT("Request to NS: written NodeParams size: " + this.m_NodeParams.size());
        }
        catch (IOException ex) {
            log.errorT("writing NodeParams size " + this.m_NodeParams.size() + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        catch (UIntValueException ex) {
            log.errorT(ex.getMessage());
        }
        Enumeration e4 = this.m_NodeParams.keys();
        while (e4.hasMoreElements()) {
            String sKey = (String)e4.nextElement();
            node = (TNode)this.m_NodeParams.get(sKey);
            try {
                theDestination.write(new SAP_STRING(sKey));
            }
            catch (IOException ex) {
                log.errorT(ex.getMessage());
            }
            boolean ret = node.serialize(theDestination);
            if (ret) continue;
            return false;
        }
        try {
            theDestination.write(new SAP_UINT(this.m_StringVectorParams.size()));
            log.debugT("Request to NS: written NodeParams size: " + this.m_NodeParams.size());
        }
        catch (IOException ex) {
            log.errorT("writing StringVectorParams size " + this.m_StringVectorParams.size() + " to Nameserver: " + ex.getMessage());
            throw new TrexException(7702, ex.getMessage());
        }
        catch (UIntValueException ex) {
            log.errorT(ex.getMessage());
        }
        Enumeration ei = this.m_StringVectorParams.keys();
        while (ei.hasMoreElements()) {
            String sKeyi = (String)ei.nextElement();
            try {
                theDestination.write(new SAP_STRING(sKeyi));
                log.debugT("Request to NS: written StringVectorParam Key: " + sKeyi);
            }
            catch (IOException ex) {
                log.errorT("writing StringVectorParams Key" + sKeyi + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
            ArrayList sVector = (ArrayList)this.m_StringVectorParams.get(sKeyi);
            try {
                theDestination.write(new SAP_UINT(sVector.size()));
            }
            catch (UIntValueException e5) {
                log.errorT(e5.getMessage() + ". " + sVector.size());
            }
            catch (IOException ex) {
                log.errorT("writing sVector size " + sVector.size() + " to Nameserver: " + ex.getMessage());
                throw new TrexException(7702, ex.getMessage());
            }
            int i = 0;
            while (i < sVector.size()) {
                String s = (String)sVector.get(i);
                try {
                    theDestination.write(new SAP_STRING(s));
                }
                catch (IOException ex) {
                    log.errorT("writing sVector size " + sVector.size() + " to Nameserver: " + ex.getMessage());
                    throw new TrexException(7702, ex.getMessage());
                }
                ++i;
            }
        }
        return true;
    }

    public synchronized boolean deserialize(BufferedInput theSource) throws TrexException {
        this.m_sMethod = "";
        this.m_sMessage = "";
        this.m_StringParams.clear();
        this.m_IntParams.clear();
        this.m_BoolParams.clear();
        this.m_NodeParams.clear();
        this.m_StringVectorParams.clear();
        SAP_STRING strDummy = new SAP_STRING();
        SAP_INT intDummy = new SAP_INT();
        SAP_UINT uintDummy = new SAP_UINT();
        SAP_BOOL boolDummy = new SAP_BOOL();
        boolean ret = true;
        try {
            String strValue;
            String key;
            theSource.read(strDummy);
            this.m_sMethod = strDummy.getValue();
            log.debugT("Response from NS: read method: " + this.m_sMethod);
            theSource.read(intDummy);
            this.m_errorCode = intDummy.getValue();
            log.debugT("Response from NS: read errorcode: " + this.m_errorCode);
            theSource.read(strDummy);
            this.m_sMessage = strDummy.getValue();
            log.debugT("Response from NS: read message: " + this.m_sMessage);
            try {
                theSource.read(uintDummy);
            }
            catch (UIntValueException e2) {
                // empty catch block
            }
            int size = (int)uintDummy.getValue();
            log.debugT("Response from NS: read m_StringParams size: " + size);
            int i = 0;
            while (i < size) {
                theSource.read(strDummy);
                key = strDummy.getValue();
                log.debugT("Response from NS: read m_StringParams key: " + key);
                theSource.read(strDummy);
                strValue = strDummy.getValue();
                log.debugT("Response from NS: read m_StringParams value: " + strValue);
                this.m_StringParams.put(key, strValue);
                ++i;
            }
            size = 0;
            key = "";
            int intValue = 0;
            try {
                theSource.read(uintDummy);
            }
            catch (UIntValueException e2) {
                // empty catch block
            }
            size = (int)uintDummy.getValue();
            log.debugT("Response from NS: read m_IntParams size: " + size);
            int i2 = 0;
            while (i2 < size) {
                theSource.read(strDummy);
                key = strDummy.getValue();
                try {
                    theSource.read(uintDummy);
                }
                catch (UIntValueException e3) {
                    // empty catch block
                }
                intValue = (int)uintDummy.getValue();
                this.m_IntParams.put(key, new Integer(intValue));
                ++i2;
            }
            try {
                theSource.read(uintDummy);
            }
            catch (UIntValueException e2) {
                // empty catch block
            }
            size = (int)uintDummy.getValue();
            int i3 = 0;
            while (i3 < size) {
                theSource.read(strDummy);
                key = strDummy.getValue();
                theSource.read(boolDummy);
                intValue = (int)uintDummy.getValue();
                boolean boolValue = boolDummy.getValue();
                this.m_BoolParams.put(key, new Boolean(boolValue));
                ++i3;
            }
            key = "";
            String name = "";
            strValue = "";
            size = 0;
            boolean flags = false;
            try {
                theSource.read(uintDummy);
            }
            catch (UIntValueException e2) {
                // empty catch block
            }
            size = (int)uintDummy.getValue();
            if (size > 0) {
                theSource.read(strDummy);
                key = strDummy.getValue();
            }
            int i4 = 0;
            while (i4 < size) {
                TNode node = new TNode();
                node.deserialize(theSource);
                this.m_NodeParams.put(key, node);
                ++i4;
            }
            key = "";
            strValue = "";
            size = 0;
            int size2 = 0;
            ArrayList<String> sVector = new ArrayList<String>();
            try {
                uintDummy.setValue(0L);
                theSource.read(uintDummy);
            }
            catch (UIntValueException e) {
                e.printStackTrace();
            }
            size = (int)uintDummy.getValue();
            int i5 = 0;
            while (i5 < size) {
                theSource.read(strDummy);
                key = strDummy.getValue();
                sVector = new ArrayList();
                try {
                    theSource.read(uintDummy);
                }
                catch (UIntValueException e3) {
                    return false;
                }
                size2 = (int)uintDummy.getValue();
                int j = 0;
                while (j < size2) {
                    theSource.read(strDummy);
                    strValue = strDummy.getValue();
                    sVector.add(strValue);
                    ++j;
                }
                this.m_StringVectorParams.put(key, sVector);
                ++i5;
            }
        }
        catch (IOException ex) {
            log.errorT("IOException while reading data from Nameserver: " + ex.getMessage());
            return false;
        }
        catch (StreamTypeException ex2) {
            log.errorT("StreamTypeException while reading data from Nameserver: " + ex2.getMessage());
            return false;
        }
        return ret;
    }

    public void add(String name, String value) {
        this.m_StringParams.put(name, value);
    }

    public void add(String name, int value) {
        this.m_IntParams.put(name, new Integer(value));
    }

    public void add(String name, boolean value) {
        this.m_BoolParams.put(name, new Boolean(value));
    }

    public void add(String name, ArrayList list) {
        this.m_StringVectorParams.put(name, list);
    }

    public void add(String name, TNode node) {
        this.m_NodeParams.put(name, node);
    }

    public TNode getTNode(String name) {
        return (TNode)this.m_NodeParams.get(name);
    }

    public Hashtable getStringVectorParams() {
        return this.m_StringVectorParams;
    }

    public Hashtable getStringParams() {
        return this.m_StringParams;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

