/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.tns;

import com.sap.tc.logging.Location;
import com.sapportals.trex.core.net.BufferedInput;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.SAP_STRING;
import com.sapportals.trex.core.net.SAP_UINT;
import com.sapportals.trex.core.net.Serializable;
import com.sapportals.trex.core.net.StreamTypeException;
import com.sapportals.trex.core.net.UIntValueException;
import com.sapportals.trex.tns.NodeList;
import java.io.IOException;

public class TNode
implements Serializable {
    private String name;
    private String value;
    private int flags;
    private NodeList nodes = new NodeList(this);
    private NodeList parents;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$tns$Transferable == null ? (class$com$sapportals$trex$tns$Transferable = TNode.class$("com.sapportals.trex.tns.Transferable")) : class$com$sapportals$trex$tns$Transferable).getName());
    static /* synthetic */ Class class$com$sapportals$trex$tns$Transferable;

    public TNode() {
        this.flags = 0;
        this.name = "";
        this.value = "";
    }

    public TNode(String theName) {
        this.flags = 0;
        this.name = theName;
        this.value = "";
    }

    public TNode(String theName, String theValue, int flags) {
        this.name = theName;
        this.flags = 0;
        this.value = theValue;
    }

    public void add(TNode anode) {
        this.nodes.add(anode);
    }

    public void add(String name, String value, int flags) {
        this.nodes.add(new TNode(name, value, flags));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public void setValue(String theValue) {
        this.value = theValue;
    }

    public void setNameValue(String theName, String theValue) {
        this.name = theName;
        this.value = theValue;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public NodeList getNodes() {
        return this.nodes;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public TNode getNode(int index) {
        return (TNode)this.nodes.get(index);
    }

    public void setContainer(NodeList container) {
        this.parents = container;
    }

    public boolean serialize(BufferedOutput theDestination) {
        try {
            theDestination.write(new SAP_STRING(this.name));
            log.debugT("Wrote to NS NodeParams Name: " + this.name);
            theDestination.write(new SAP_STRING(this.value));
            log.debugT("Wrote to NS NodeParams Value: " + this.value);
            SAP_UINT fl = null;
            try {
                fl = new SAP_UINT(this.flags);
            }
            catch (UIntValueException e1) {
                log.errorT("Casting flags to SAP_UINT. Continuing setting flags=0");
                try {
                    fl = new SAP_UINT(0L);
                }
                catch (UIntValueException e2) {
                    // empty catch block
                }
            }
            theDestination.write(fl);
            log.debugT("Wrote to NS NodeParams Value: " + this.flags);
            try {
                theDestination.write(new SAP_UINT(this.getNodeCount()));
            }
            catch (UIntValueException e) {
                // empty catch block
            }
            int i = 0;
            while (i < this.getNodeCount()) {
                this.getNode(i).serialize(theDestination);
                ++i;
            }
        }
        catch (IOException e) {
            log.errorT("writing tnode parameters to nameserver. " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean deserialize(BufferedInput theSource) {
        SAP_STRING str = new SAP_STRING();
        SAP_UINT uint = new SAP_UINT();
        boolean ret = true;
        try {
            theSource.read(str);
            this.name = str.getValue();
            theSource.read(str);
            this.value = str.getValue();
            theSource.read(uint);
            this.flags = (int)uint.getValue();
            theSource.read(uint);
            long size = uint.getValue();
            int i = 0;
            while ((long)i < size) {
                TNode node = new TNode();
                ret = node.deserialize(theSource);
                this.nodes.add(node);
                ++i;
            }
        }
        catch (UIntValueException ste) {
            this.nodes.clear();
        }
        catch (StreamTypeException ste) {
            this.nodes.clear();
        }
        catch (IOException e) {
            this.nodes.clear();
        }
        return ret;
    }

    public String toString() {
        String result = "";
        String sSize = "";
        if (this.nodes.size() > 0) {
            sSize = "[" + this.nodes.size() + "]";
        }
        result = this.value == "" ? result + this.name + sSize : result + this.name + "=" + this.value + sSize;
        if (this.nodes.size() > 0) {
            result = result + "(";
            int i = 0;
            while (i < this.nodes.size()) {
                result = result + this.nodes.get(i);
                if (i < this.nodes.size() - 1) {
                    result = result + ",";
                }
                ++i;
            }
            result = result + ")";
        }
        return result;
    }

    public static void main(String[] args) {
        TNode root = new TNode("ROOT");
        TNode n1 = new TNode("n1");
        TNode n2 = new TNode("n2");
        TNode n3 = new TNode("n3");
        root.add(n1);
        root.add(n2);
        root.add(n3);
        System.out.println(root);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

