/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.tns;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.admin.ServerInfo;
import com.sapportals.trex.core.net.BufferedInput;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.Communication;
import com.sapportals.trex.core.net.Request;
import com.sapportals.trex.core.net.SAP_STRING;
import com.sapportals.trex.core.net.StreamTypeException;
import com.sapportals.trex.tns.TNode;
import com.sapportals.trex.tns.Transferable;
import com.sapportals.trex.util.cache.CacheManager;
import com.sapportals.trex.util.cache.WrappedCache;
import com.sapportals.trex.util.cache.WrappedCacheEntry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TNSClient {
    public static final String TNS_COMMAND_GETSERVER = "getserver";
    public static final String TNS_COMMAND_GETSERVERS = "getservers";
    public static final String TNS_COMMAND_SETACTIVE = "setactive";
    public static final String TNS_COMMAND_SETINACTIVE = "setinactive";
    public static final String TNS_COMMAND_EXECUTETREEQUERY = "executetreequery";
    public static final int TNS_SERVICETYPE_CLIENT = 0;
    public static final int TNS_SERVICETYPE_INDEXSERVER = 1;
    public static final int TNS_SERVICETYPE_QUEUESERVER = 2;
    public static final int TNS_SERVICETYPE_PREPROCESSOR = 3;
    public static final int TNS_SERVICETYPE_NAMESERVER = 4;
    public static final int TNS_SERVICETYPE_HTTPSERVER = 5;
    public static final int TNS_SERVICETYPE_RFCSERVER = 6;
    public static final int TNS_SERVICETYPE_ALLSERVERS = 7;
    public static final int TNS_SERVICEMODE_ANYMODE = 0;
    public static final int TNS_SERVICEMODE_SEARCHMODE = 1;
    public static final int TNS_SERVICEMODE_INDEXMODE = 2;
    public static final int TNS_QUERYMODE_QUERYAND = 0;
    public static final int TNS_QUERYMODE_QUERYOR = 1;
    public static final String TNS_NSSERVICENAME_BLANK = "";
    public static final String TNS_NSSERVICENAME_INDEXSERVER = "indexserver";
    public static final String TNS_NSSERVICENAME_QUEUESERVER = "queueserver";
    public static final String TNS_NSSERVICENAME_PREPROCESSOR = "preprocessor";
    public static final String TNS_NSSERVICENAME_NAMESERVER = "nameserver";
    public static final String TNS_NSSERVICENAME_HTTPSERVER = "httpserver";
    public static final String TNS_NSSERVICENAME_RFCSERVER = "rfcserver";
    public static final String TNS_NSSERVICENAME_ALL = "*";
    public static final String TNS_NSGETSERVER_RESULTKEY_URL = "url";
    public static final String TNS_NSGETSERVER_RESULTKEY_SERVER = "server";
    private static TrexConfigManager trexConfig;
    private static Location log;
    static /* synthetic */ Class class$com$sapportals$trex$tns$TNSClient;

    public TNode executeTreeQuery(TNode query, int mode) throws TrexException {
        Transferable request = new Transferable(TNS_COMMAND_EXECUTETREEQUERY);
        TNode resNode = new TNode();
        log.debugT("Start executeTreeQuery: " + query.toString());
        request.add("query", query);
        request.add("mode", mode);
        Transferable response = this.sendRequest(request);
        resNode = response.getTNode("result");
        return resNode;
    }

    public ArrayList getServers(int serviceType, boolean withInactive) throws TrexException {
        TNode response = new TNode();
        ArrayList serverList = new ArrayList();
        TNode query = new TNode("host/*/" + this.getServiceName(serviceType) + "/*");
        query.add("active", withInactive ? TNS_NSSERVICENAME_ALL : "yes", 0);
        query.add(TNS_NSGETSERVER_RESULTKEY_URL, TNS_NSSERVICENAME_ALL, 0);
        response = this.executeTreeQuery(query, 1);
        return serverList;
    }

    public ArrayList getAllHttpServers() throws TrexException {
        Transferable response = null;
        ServerInfo serverinfo = null;
        ArrayList tmp = new ArrayList();
        ArrayList<ServerInfo> result = new ArrayList<ServerInfo>();
        Transferable request = new Transferable("gethttpservers");
        Hashtable m_StringParams = null;
        String key = TNS_NSSERVICENAME_BLANK;
        response = this.sendRequest(request);
        m_StringParams = response.getStringVectorParams();
        Enumeration e = m_StringParams.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            tmp = (ArrayList)m_StringParams.get(key);
            int i = 0;
            while (i < tmp.size()) {
                serverinfo = key.equals("active") ? new ServerInfo(TNS_NSSERVICENAME_BLANK, 0, true) : new ServerInfo(TNS_NSSERVICENAME_BLANK, 0, false);
                serverinfo.setURL((String)tmp.get(i));
                result.add(serverinfo);
                ++i;
            }
        }
        request = null;
        m_StringParams = null;
        response = null;
        tmp = null;
        serverinfo = null;
        return result;
    }

    public synchronized String getHttpServer() throws TrexException {
        String server = null;
        server = this.getCachedHttpServer();
        if (server != null) {
            return server;
        }
        Transferable response = null;
        Hashtable m_StringParams = null;
        Transferable request = new Transferable("getserver_11");
        request.add("indexname", TNS_NSSERVICENAME_BLANK);
        request.add("servicetype", 5);
        request.add("servicemode", 0);
        response = this.sendRequest(request);
        if (response != null) {
            m_StringParams = response.getStringParams();
            server = (String)m_StringParams.get(TNS_NSGETSERVER_RESULTKEY_URL);
        }
        if (server == null) {
            throw new TrexException(7218);
        }
        this.cacheHttpServer(server);
        return server;
    }

    public boolean clearHttpServerCache() {
        CacheManager cm = CacheManager.getInstance();
        WrappedCache cache = null;
        cache = cm.getCache("trexadmin");
        try {
            cache.clearCache();
        }
        catch (Exception e) {
            log.errorT("Warning clearing cache 'trexadmin' " + e.getMessage());
            return false;
        }
        return true;
    }

    private String getCachedHttpServer() {
        boolean useCacheHttpServer = true;
        try {
            trexConfig = TrexFactory.getTrexConfigManager();
            useCacheHttpServer = trexConfig.getCacheHttpServer();
        }
        catch (TrexException e) {
            useCacheHttpServer = true;
        }
        CacheManager cm = CacheManager.getInstance();
        WrappedCache cache = null;
        cache = cm.getCache("trexadmin");
        String server = null;
        if (useCacheHttpServer) {
            try {
                WrappedCacheEntry wrappedEntry = cache.getEntry("HttpServer");
                if (wrappedEntry != null && wrappedEntry.getObject() != null) {
                    server = (String)wrappedEntry.getObject();
                }
                log.debugT("Successfully cached HttpServer: " + server);
            }
            catch (NullPointerException npe) {
                log.warningT("Cache object is null.");
            }
            catch (Exception e) {
                server = null;
                log.warningT("Could not read cache for Httpserver: " + e.getMessage());
            }
        }
        return server;
    }

    private void cacheHttpServer(String server) {
        boolean useCacheHttpServer = true;
        try {
            trexConfig = TrexFactory.getTrexConfigManager();
            useCacheHttpServer = trexConfig.getCacheHttpServer();
        }
        catch (TrexException e) {
            useCacheHttpServer = true;
        }
        if (useCacheHttpServer) {
            CacheManager cm = CacheManager.getInstance();
            WrappedCache cache = null;
            cache = cm.getCache("trexadmin");
            try {
                cache.addEntry("HttpServer", server);
                log.debugT("Added HttpServer: " + server + " to Cache 'trexadmin'.");
            }
            catch (Exception e) {
                log.warningT("Could not cache Httpserver: " + server + ". " + e.getMessage());
            }
        }
    }

    public ArrayList getActiveHttpServers() throws TrexException {
        ArrayList a = new ArrayList();
        Transferable response = null;
        ArrayList tmp = new ArrayList();
        Transferable request = new Transferable("gethttpservers");
        Hashtable m_StringParams = null;
        String key = TNS_NSSERVICENAME_BLANK;
        response = this.sendRequest(request);
        m_StringParams = response.getStringVectorParams();
        Enumeration e = m_StringParams.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            tmp = (ArrayList)m_StringParams.get(key);
            int i = 0;
            while (i < tmp.size()) {
                if (key.equals("active")) {
                    a.add(tmp.get(i));
                }
                ++i;
            }
        }
        tmp = null;
        response = null;
        m_StringParams = null;
        return a;
    }

    private String getServiceName(int serviceType) {
        switch (serviceType) {
            case 0: {
                return TNS_NSSERVICENAME_BLANK;
            }
            case 1: {
                return TNS_NSSERVICENAME_INDEXSERVER;
            }
            case 2: {
                return TNS_NSSERVICENAME_QUEUESERVER;
            }
            case 3: {
                return TNS_NSSERVICENAME_PREPROCESSOR;
            }
            case 4: {
                return TNS_NSSERVICENAME_NAMESERVER;
            }
            case 5: {
                return TNS_NSSERVICENAME_HTTPSERVER;
            }
            case 6: {
                return TNS_NSSERVICENAME_RFCSERVER;
            }
            case 7: {
                return TNS_NSSERVICENAME_ALL;
            }
            case 8: {
                return TNS_NSSERVICENAME_BLANK;
            }
        }
        return TNS_NSSERVICENAME_BLANK;
    }

    private int getServiceType(char serviceName) {
        if (serviceName == ' ') {
            return 0;
        }
        if (serviceName == 'i') {
            return 1;
        }
        if (serviceName == 'q') {
            return 2;
        }
        if (serviceName == 'p') {
            return 3;
        }
        if (serviceName == 'n') {
            return 4;
        }
        if (serviceName == 'h') {
            return 5;
        }
        if (serviceName == 'r') {
            return 6;
        }
        return 0;
    }

    private synchronized Transferable sendRequest(Transferable request) throws TrexException {
        ArrayList backupNS;
        String masterNS = TNS_NSSERVICENAME_BLANK;
        Transferable response = null;
        InetAddress inetaddress = null;
        String hostname = null;
        String backup = null;
        try {
            inetaddress = InetAddress.getLocalHost();
            hostname = inetaddress.getHostName();
        }
        catch (UnknownHostException e1) {
            hostname = TNS_NSSERVICENAME_BLANK;
            e1.printStackTrace();
        }
        String client_id_text = "JavaClient on: " + hostname + ": " + System.getProperty("os.name") + ":" + System.getProperty("os.version");
        log.debugT("client_id sent to name server: " + client_id_text);
        request.add("client_id", client_id_text);
        try {
            trexConfig = TrexFactory.getTrexConfigManager();
            masterNS = trexConfig.getMasterNameServer();
        }
        catch (TrexException e) {
            masterNS = TNS_NSSERVICENAME_BLANK;
            log.errorT("Master Nameserver Configuration Error: " + e.getCode() + ": " + e.getMsg());
            log.errorT("Use Nameserver Backup List");
        }
        try {
            backupNS = trexConfig.getSlaveNameServers();
        }
        catch (TrexException e) {
            backupNS = new ArrayList();
            log.errorT("Nameserver BackupList Configuration Error: " + e.getCode() + ": " + e.getMsg());
        }
        String masterHost = TNS_NSSERVICENAME_BLANK;
        int masterPort = 0;
        if (masterNS.equals(TNS_NSSERVICENAME_BLANK) && backupNS == null) {
            throw new TrexException(7213, TNS_NSSERVICENAME_NAMESERVER);
        }
        if (!masterNS.equals(TNS_NSSERVICENAME_BLANK)) {
            masterHost = masterNS.trim().substring(8, masterNS.lastIndexOf(":"));
            try {
                masterPort = Integer.valueOf(masterNS.trim().substring(masterNS.lastIndexOf(":") + 1));
            }
            catch (Exception ex) {
                log.errorT("Invalid Port: " + ex.getMessage());
                masterPort = 0;
            }
        }
        int i = 0;
        while (i < 5) {
            try {
                response = this.sendRequestToServer(request, masterHost, masterPort);
                if (response != null) {
                    break;
                }
            }
            catch (Exception ex) {
                log.errorT("Failed to send request to master NS: " + masterHost + ":" + masterPort + ". " + ex.getMessage());
            }
            ++i;
        }
        if (response == null && backupNS.size() > 0) {
            int j = 0;
            while (j < backupNS.size()) {
                backup = (String)backupNS.get(j);
                String h = backup.trim().substring(8, backup.lastIndexOf(":"));
                int p = 0;
                try {
                    p = Integer.valueOf(backup.trim().substring(backup.lastIndexOf(":") + 1));
                }
                catch (Exception ex) {
                    log.errorT("Invalid Backup Port: " + ex.getMessage());
                    p = 0;
                }
                try {
                    response = this.sendRequestToServer(request, h, p);
                }
                catch (Exception e2) {
                    log.errorT("Failed to send request to backup NS: " + h + ":" + p + ". " + e2.getMessage());
                }
                if (response != null) break;
                ++j;
            }
        }
        if (response == null) {
            throw new TrexException(7217);
        }
        return response;
    }

    private synchronized Transferable sendRequestToServer(Transferable request, String host, int port) throws Exception {
        Request aRequest = new Request();
        Transferable response = new Transferable(request.getMethod());
        log.debugT("Opening TNS request. Host: " + host + ". Port: " + port);
        try {
            aRequest.open("TNS", host, port);
        }
        catch (Exception ex) {
            log.errorT("Error opening port to " + host + ":" + port + ". " + ex.getMessage());
            return null;
        }
        BufferedOutput reqOut = aRequest.out();
        reqOut.write(new SAP_STRING("(OBJ)"));
        log.debugT("Start serializing request: " + request.toString());
        try {
            request.serialize(reqOut);
            reqOut.end();
            reqOut.flush();
        }
        catch (TrexException ex) {
            aRequest.close();
            log.errorT(ex.getCode() + ":" + ex.getMessage());
            throw ex;
        }
        log.debugT("End serializing request. Request sent.");
        if (reqOut != null) {
            log.debugT("Start deserializing response.");
            BufferedInput resIn = aRequest.in();
            boolean ret = response.deserialize(resIn);
            aRequest.close();
            if (!ret) {
                throw new TrexException(7701);
            }
        }
        log.debugT("Finished deserializing response.");
        try {
            aRequest.close();
        }
        catch (IOException e) {
            log.errorT("closing connection to name server " + e.getMessage());
        }
        catch (StreamTypeException e) {
            log.errorT(TNS_NSSERVICENAME_BLANK + e.getMessage());
        }
        return response;
    }

    public boolean checkNameServerAvailability(String host, int port) {
        Request aRequest = new Request();
        log.debugT("Opening TNS request. Host: " + host + ". Port: " + port);
        try {
            aRequest.open("TNS", host, port);
        }
        catch (Exception ex) {
            log.errorT("Error opening port to " + host + ":" + port + ". " + ex.getMessage());
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = Location.getLocation((String)(class$com$sapportals$trex$tns$TNSClient == null ? (class$com$sapportals$trex$tns$TNSClient = TNSClient.class$("com.sapportals.trex.tns.TNSClient")) : class$com$sapportals$trex$tns$TNSClient).getName());
        Communication.initialize();
    }
}

