/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.xparser;

import com.sapportals.trex.core.xparser.XParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.xml.sax.SAXException;

public abstract class XParserState {
    public XParserState parent;
    public XParser parser;
    public int level;
    private static final boolean useOwnMethodTable = true;

    public void begin(XParserState newstate) {
        this.parser.begin(newstate);
    }

    public Method findMethod(String methodName) {
        Method[] methods = this.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(methodName)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public void startElement(String name) throws SAXException {
        Object[] args = new Object[]{};
        String methodname = "start_" + name;
        Method method = this.findMethod(methodname);
        if (method == null) {
            throw new SAXException("unexpected tag <" + name + "> found");
        }
        try {
            this.callMethod(method, args);
        }
        catch (InvocationTargetException ite) {
            Exception e;
            try {
                e = (Exception)ite.getTargetException();
            }
            catch (Throwable t) {
                e = ite;
            }
            e.printStackTrace();
            throw new SAXException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public void endElement(String name, Object data) throws SAXException {
        Object[] args = new Object[]{data};
        String methodname = "end_" + name;
        Method method = this.findMethod(methodname);
        if (method == null) {
            throw new SAXException("unexpected tag </" + name + "> found");
        }
        try {
            this.callMethod(method, args);
        }
        catch (InvocationTargetException ite) {
            Exception e;
            try {
                e = (Exception)ite.getTargetException();
            }
            catch (Throwable t) {
                e = ite;
            }
            e.printStackTrace();
            throw new SAXException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public Method getStartMethod(String tagname) {
        Class[] parameterTypes = new Class[]{};
        try {
            return this.getClass().getMethod("start_" + tagname, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Method getEndMethod(String tagname) {
        Class[] parameterTypes = new Class[]{new Object().getClass()};
        try {
            return this.getClass().getMethod("end_" + tagname, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Hashtable makeMethodTable() {
        Hashtable<String, Method> methodTable = new Hashtable<String, Method>();
        Method[] methods = this.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("start_") || methodName.startsWith("end_")) {
                methodTable.put(methodName, methods[i]);
            }
            ++i;
        }
        return methodTable;
    }

    public Object finish() throws SAXException {
        return null;
    }

    public String getText() {
        return this.parser.getText();
    }

    public abstract void callMethod(Method var1, Object[] var2) throws IllegalAccessException, InvocationTargetException;
}

