/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.util.jARM;

import com.sap.jdsr.writer.DsrIPassport;
import com.sap.tc.logging.Location;
import com.sapportals.trex.core.base64.BASE64Encoder;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import com.sapportals.trex.core.util.jARM.TREXRuntimeProperties;
import java.net.HttpURLConnection;

public class JarmData {
    private static final String constJarmIsActive = "JarmIsActive";
    private static final String constSATIsActive = "SATIsActive";
    private static final String constJarmSession = "JarmSession";
    private static final String constJarmUser = "JarmUser";
    private static final String constJarmApplication = "JarmApplication";
    private static final String constJarmThreadName = "JarmThreadName";
    private static final String constJarmCurrentTime = "JarmCurrentTime";
    private static final String constJarmPassport = "SAP-PASSPORT";
    private static final String constJ2eeVersion = "J2eeVersion";
    private static final String constJarmRequestName = "JarmRequestName";
    private static final String constJarmRequestTimeStamp = "JarmRequestTimeStamp";
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$util$jARM$JarmData == null ? (class$com$sapportals$trex$core$util$jARM$JarmData = JarmData.class$("com.sapportals.trex.core.util.jARM.JarmData")) : class$com$sapportals$trex$core$util$jARM$JarmData).getName());
    private DsrIPassport myPassport = null;
    private String m_strSession = null;
    private String m_strUser = null;
    private String m_strApplication = null;
    private String m_strThreadName = null;
    private String m_strCurrentTime = null;
    private String m_strJarmIsActive = null;
    private String m_strSATIsActive = null;
    private String m_strPassport = null;
    private String m_strVersion = null;
    private String m_strRequestTimeStamp = null;
    private String m_strRequestName = null;
    static /* synthetic */ Class class$com$sapportals$trex$core$util$jARM$JarmData;

    public JarmData(DsrIPassport pass) {
        this.myPassport = pass;
    }

    private void setMembers(boolean bJARMOn, boolean bSATOn) {
        byte[] byteArrPassport = null;
        this.m_strJarmIsActive = bJARMOn ? "YES" : "NO";
        this.m_strSATIsActive = bSATOn ? "YES" : "NO";
        this.m_strThreadName = Thread.currentThread().getName();
        long currentTime = System.currentTimeMillis();
        this.m_strCurrentTime = String.valueOf(currentTime);
        TREXRuntimeProperties rtProp = new TREXRuntimeProperties();
        this.m_strVersion = rtProp.getKernelVersion();
        this.m_strUser = rtProp.getUser();
        this.m_strSession = rtProp.getSession();
        this.m_strApplication = rtProp.getApplication();
        if (this.m_strVersion != null && !this.m_strVersion.startsWith("6.20")) {
            TREXIMonitor monitor = new TREXIMonitor();
            try {
                this.m_strRequestName = monitor.getRequestName();
                this.m_strRequestTimeStamp = String.valueOf(monitor.getRequestTimeStamp());
                try {
                    if (this.myPassport != null && (byteArrPassport = this.myPassport.getNetPassport()) == null) {
                        log.infoT("NetPassport is null");
                    }
                }
                catch (Exception e) {
                    log.warningT("Exception caught for DSRPassport: ", e.getMessage());
                }
                Object var10_8 = null;
                monitor = null;
                this.myPassport = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                monitor = null;
                this.myPassport = null;
                throw throwable;
            }
        }
        if (byteArrPassport != null) {
            BASE64Encoder base64 = new BASE64Encoder();
            this.m_strPassport = base64.encode(byteArrPassport);
        }
    }

    public void setJarmHeaderData(HttpURLConnection connection, boolean bJARMOn, boolean bSATOn) {
        this.setMembers(bJARMOn, bSATOn);
        if (this.m_strJarmIsActive != null) {
            connection.setRequestProperty(constJarmIsActive, this.m_strJarmIsActive);
            log.debugT("JarmIsActive: " + this.m_strJarmIsActive);
        }
        if (this.m_strSATIsActive != null) {
            connection.setRequestProperty(constSATIsActive, this.m_strSATIsActive);
            log.debugT("SATIsActive: " + this.m_strSATIsActive);
        }
        if (bJARMOn) {
            if (this.m_strSession != null) {
                connection.setRequestProperty(constJarmSession, this.m_strSession);
                log.debugT("JarmSession: " + this.m_strSession);
            }
            if (this.m_strUser != null) {
                connection.setRequestProperty(constJarmUser, this.m_strUser);
                log.debugT("JarmUser: " + this.m_strUser);
            }
            if (this.m_strApplication != null) {
                connection.setRequestProperty(constJarmApplication, this.m_strApplication);
                log.debugT("JarmApplication: " + this.m_strApplication);
            }
            if (this.m_strThreadName != null) {
                connection.setRequestProperty(constJarmThreadName, this.m_strThreadName);
                log.debugT("JarmThreadName: " + this.m_strThreadName);
            }
            if (this.m_strCurrentTime != null) {
                connection.setRequestProperty(constJarmCurrentTime, this.m_strCurrentTime);
                log.debugT("JarmCurrentTime: " + this.m_strCurrentTime);
            }
            if (this.m_strPassport != null) {
                connection.setRequestProperty(constJarmPassport, this.m_strPassport);
                log.debugT("SAP-PASSPORT: " + this.m_strPassport);
            }
            if (this.m_strVersion != null) {
                connection.setRequestProperty(constJ2eeVersion, this.m_strVersion);
                log.debugT("J2eeVersion: " + this.m_strVersion);
            }
            if (this.m_strRequestName != null) {
                connection.setRequestProperty(constJarmRequestName, this.m_strRequestName);
                log.debugT("JarmRequestName: " + this.m_strRequestName);
            }
            if (this.m_strRequestTimeStamp != null) {
                connection.setRequestProperty(constJarmRequestTimeStamp, this.m_strRequestTimeStamp);
                log.debugT("JarmRequestTimeStamp: " + this.m_strRequestTimeStamp);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

