/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.util;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.util.HttpsConnectionFactory;
import java.util.HashMap;

public class SSLConfigurationManager {
    private HashMap m_factories = new HashMap();
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$util$SSLConfigurationManager == null ? (class$com$sapportals$trex$core$util$SSLConfigurationManager = SSLConfigurationManager.class$("com.sapportals.trex.core.util.SSLConfigurationManager")) : class$com$sapportals$trex$core$util$SSLConfigurationManager).getName());
    private static SSLConfigurationManager m_factory = new SSLConfigurationManager();
    static /* synthetic */ Class class$com$sapportals$trex$core$util$SSLConfigurationManager;

    private SSLConfigurationManager() {
    }

    public static SSLConfigurationManager getInstance() {
        return m_factory;
    }

    public synchronized void invalidateCache() {
        this.m_factories = new HashMap();
    }

    public HttpsConnectionFactory getHttpsConnectionFactory(String keystore, String truststore) throws TrexException {
        TrexConfigManager conf;
        if (keystore == null) {
            String aKeystore = null;
            try {
                conf = TrexFactory.getTrexConfigManager();
                aKeystore = conf.getKeyStore();
            }
            catch (Exception e) {
                throw new TrexException(7282, "no trex keystore found");
            }
            if (aKeystore == null || aKeystore.length() < 1) {
                throw new TrexException(7282, "no trex keystore found");
            }
            keystore = aKeystore;
        }
        if (truststore == null) {
            String aTruststore = null;
            try {
                conf = TrexFactory.getTrexConfigManager();
                aTruststore = conf.getTrustStore();
            }
            catch (Exception e) {
                aTruststore = "TrustedCAs";
                log.debugT("no truststore specified: set to " + aTruststore);
            }
            truststore = aTruststore == null || aTruststore.length() < 1 ? "TrustedCAs" : aTruststore;
        }
        HashMap hashMap = this.m_factories;
        synchronized (hashMap) {
            if (this.m_factories.containsKey(keystore + truststore)) {
                HttpsConnectionFactory e = (HttpsConnectionFactory)this.m_factories.get(keystore + truststore);
                return e;
            }
            try {
                log.debugT("Try to create object HttpsConnectionFactory with " + keystore + " and truststore " + truststore + "...");
                HttpsConnectionFactory factory = new HttpsConnectionFactory(keystore, truststore);
                log.debugT("Object of HttpsConnectionFactory created");
                this.m_factories.put(keystore + truststore, factory);
                HttpsConnectionFactory httpsConnectionFactory = factory;
                return httpsConnectionFactory;
            }
            catch (Exception e) {
                log.errorT(e.getMessage());
                throw new TrexException(7282, e.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

