/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.util;

import com.sap.engine.services.dsr.trex.ClientPassportManager;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.HttpsConnectionFactory;
import com.sapportals.trex.core.util.SSLConfigurationManager;
import com.sapportals.trex.core.util.jARM.JarmData;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import com.sapportals.trex.tns.TNSClient;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.xml.sax.InputSource;

public abstract class HttpRequest {
    private String m_ticket = null;
    private String m_indexUser = null;
    private String m_keystore = null;
    private String m_truststore = null;
    private TNSClient client = new TNSClient();
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$util$HttpRequest == null ? (class$com$sapportals$trex$core$util$HttpRequest = HttpRequest.class$("com.sapportals.trex.core.util.HttpRequest")) : class$com$sapportals$trex$core$util$HttpRequest).getName());
    private static ClientPassportManager myDsrPassportManager;
    private DsrIPassport pass = null;
    static /* synthetic */ Class class$com$sapportals$trex$core$util$HttpRequest;

    public static void registerClientPassportManager(ClientPassportManager m) {
        myDsrPassportManager = m;
    }

    public static void unregisterClientPassportManager() {
        myDsrPassportManager = null;
    }

    public void run(URL url) throws TrexException {
        this.run(url, true);
    }

    public void run() throws TrexException {
        this.run(null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(URL url, boolean useManualHttp) throws TrexException {
        ClientPassportManager cpm = myDsrPassportManager;
        try {
            try {
                this.run_it(url, useManualHttp, cpm);
                if (cpm != null && this.pass != null) {
                    cpm.trexCallFinished(0, 0);
                }
                this.pass = null;
                return;
            }
            catch (TrexException ex) {
                block16: {
                    if (cpm != null && this.pass != null) {
                        cpm.trexCallFinished(0, 0);
                    }
                    this.pass = null;
                    if (ex.getCode() != 7262) {
                        if (ex.getCode() != 7266) throw ex;
                    }
                    if (url != null) {
                        log.warningT("http server not reachable : " + url.toString());
                    } else {
                        log.warningT("http server not reachable");
                    }
                    boolean useCacheHttpServer = true;
                    try {
                        TrexConfigManager trexConfig = TrexFactory.getTrexConfigManager();
                        useCacheHttpServer = trexConfig.getCacheHttpServer();
                    }
                    catch (TrexException ex2) {
                        useCacheHttpServer = true;
                    }
                    if (!useCacheHttpServer) throw ex;
                    this.client.clearHttpServerCache();
                    url = this.getServerUrl();
                    if (url != null) {
                        log.warningT("old url was not reachable try again with new url" + url.toString());
                    }
                    try {
                        this.run_it(url, useManualHttp, cpm);
                        Object var8_11 = null;
                        if (cpm != null && this.pass != null) {
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (cpm != null && this.pass != null) {
                            cpm.trexCallFinished(0, 0);
                        }
                        this.pass = null;
                        throw throwable;
                    }
                    cpm.trexCallFinished(0, 0);
                }
                this.pass = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            cpm = null;
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public void run_it(URL url, boolean useManualHttp, ClientPassportManager cpm) throws TrexException {
        block45: {
            IOException ex42;
            InputStream in;
            OutputStreamWriter osw;
            HttpURLConnection connection;
            int errorCode;
            block42: {
                TREXIMonitor monitor = new TREXIMonitor();
                boolean bMonitorOn = monitor.isJarmActiveForRequest();
                boolean bSATOn = monitor.isSATSwitchedOnForRequest();
                errorCode = 0;
                connection = null;
                osw = null;
                in = null;
                if (!useManualHttp) {
                    url = this.getServerUrl();
                }
                if (cpm != null) {
                    this.pass = cpm.trexCallStarted(url.toExternalForm(), "TREXWebServer");
                }
                if (url.getProtocol().equals("https")) {
                    errorCode = 7282;
                    SSLConfigurationManager conf = SSLConfigurationManager.getInstance();
                    HttpsConnectionFactory factory = conf.getHttpsConnectionFactory(this.m_keystore, this.m_truststore);
                    errorCode = 7262;
                    try {
                        connection = factory.getConnection(url);
                    }
                    catch (IOException ex2) {
                        log.errorT("HttpServer: " + url.toString() + " is down or not accessable. Read server from nameserver. ");
                        throw ex2;
                    }
                }
                errorCode = 7262;
                try {
                    connection = (HttpURLConnection)url.openConnection();
                }
                catch (IOException ex3) {
                    log.errorT("HttpServer: " + url.toString() + " is down or not accessable. Read server from nameserver. ");
                    throw ex3;
                }
                try {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    if (this.m_ticket != null) {
                        connection.setRequestProperty("Cookie", "MYSAPSSO2=" + this.m_ticket);
                        log.debugT("Ticket was set");
                    }
                    if (this.m_indexUser != null) {
                        connection.setRequestProperty("TREXUser", this.m_indexUser);
                        log.debugT("TREX user was set");
                    }
                    if (bMonitorOn && monitor.getUseJarm()) {
                        try {
                            JarmData JarmDat = new JarmData(this.pass);
                            JarmDat.setJarmHeaderData(connection, bMonitorOn, bSATOn);
                        }
                        catch (Exception e) {
                            log.errorT(e.getMessage());
                        }
                    }
                    osw = new OutputStreamWriter(connection.getOutputStream());
                }
                catch (Exception e) {
                    if (osw != null) {
                        osw.close();
                        osw = null;
                    }
                    throw new TrexException(7262, url.toString(), e.getMessage());
                }
                XMLWriter w = new XMLWriter();
                String strHostPort = ":" + url.getHost() + ":" + String.valueOf(url.getPort());
                int iResponseCode = 409;
                try {
                    monitor.startComponent("EP:KM:TREX:HTTP" + strHostPort);
                    w.setOutput(osw);
                    this.formatRequest(w);
                    osw.close();
                    if (log.beWarning()) {
                        this.logConnectionData(connection);
                    }
                    iResponseCode = connection.getResponseCode();
                    Object var15_20 = null;
                    monitor.endComponent("EP:KM:TREX:HTTP" + strHostPort);
                    monitor.endRequest();
                    monitor = null;
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    monitor.endComponent("EP:KM:TREX:HTTP" + strHostPort);
                    monitor.endRequest();
                    monitor = null;
                    throw throwable;
                }
                errorCode = 7260;
                if (iResponseCode == 200) {
                    in = connection.getInputStream();
                    if (log.beDebug()) {
                        in = this.logResponse("XMLResponse: ", in);
                    }
                    InputSource is = new InputSource(in);
                    monitor = new TREXIMonitor();
                    try {
                        monitor.startComponent("EP:KM:TREX:PARSE");
                        this.parseResponse(is);
                        Object var17_24 = null;
                        monitor.endComponent("EP:KM:TREX:PARSE");
                        monitor.endRequest();
                        monitor = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_25 = null;
                        monitor.endComponent("EP:KM:TREX:PARSE");
                        monitor.endRequest();
                        monitor = null;
                        throw throwable;
                    }
                    if (in != null) {
                        in.close();
                        in = null;
                    }
                } else {
                    log.errorT("Connection Response Code: " + connection.getResponseCode() + " " + connection.getResponseMessage());
                    this.clearInputStream(connection);
                    throw new TrexException(7266, String.valueOf(connection.getResponseCode()));
                }
                connection.disconnect();
                Object var19_27 = null;
                if (osw == null) break block42;
                try {
                    osw.close();
                }
                catch (IOException ex42) {
                    log.warningT("catched IOException while trying to close OutputStream:  " + ex42.getMessage());
                }
                osw = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex42) {
                    log.warningT("catched IOException while trying to close InputStream:  " + ex42.getMessage());
                }
                in = null;
            }
            if (connection != null) {
                this.clearInputStream(connection);
                connection.disconnect();
                connection = null;
            }
            break block45;
            {
                catch (TrexException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (errorCode == 7262) {
                        throw new TrexException(7262, url.toString(), e.getMessage());
                    }
                    throw new TrexException(errorCode, e.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException ex42;
                Object var19_28 = null;
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException ex42) {
                        log.warningT("catched IOException while trying to close OutputStream:  " + ex42.getMessage());
                    }
                    osw = null;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex42) {
                        log.warningT("catched IOException while trying to close InputStream:  " + ex42.getMessage());
                    }
                    in = null;
                }
                if (connection != null) {
                    this.clearInputStream(connection);
                    connection.disconnect();
                    connection = null;
                }
                throw throwable;
            }
        }
        TrexReturn ret = this.getReturn();
        if (ret != null && ret.getCode() != 0 && ret.getCode() != 1) {
            throw new TrexException(ret);
        }
    }

    public abstract void formatRequest(XMLWriter var1) throws Exception;

    public abstract void parseResponse(InputSource var1) throws Exception;

    public TrexReturn getReturn() {
        return null;
    }

    public void setTicket(String ticket) {
        this.m_ticket = ticket;
    }

    public void setIndexUser(String user) {
        this.m_indexUser = user;
    }

    public void setSSLData(String keystore, String truststore) {
        this.m_keystore = keystore;
        this.m_truststore = truststore;
    }

    private InputStream logResponse(String intro, InputStream in) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        String encoding = "iso-8859-1";
        byte[] buf = new byte[65536];
        int read = 0;
        while ((read = in.read(buf)) != -1) {
            sbuf.append(new String(buf, 0, read, encoding));
        }
        log.debugT(intro + sbuf);
        ByteArrayInputStream ns = new ByteArrayInputStream(sbuf.toString().getBytes(encoding));
        return ns;
    }

    private void logConnectionData(HttpURLConnection connection) {
        if (connection.usingProxy()) {
            log.warningT("Proxy is used for TREX http connection");
        } else {
            log.debugT("No proxy is used for TREX http connection");
        }
        try {
            log.debugT("Connection response code:    " + connection.getResponseCode());
        }
        catch (IOException e) {
            log.debugT("Connection response code could not be read");
        }
        try {
            log.debugT("Connection response message: " + connection.getResponseMessage());
        }
        catch (IOException e) {
            log.debugT("Connection response message could not be read");
        }
        log.debugT("Date:                        " + connection.getDate());
        log.debugT("Last modified:               " + connection.getLastModified());
        log.debugT("Content length:              " + connection.getContentLength());
    }

    private URL getServerUrl() throws TrexException {
        boolean n = true;
        String s = "";
        Date d = new Date();
        long ms = d.getTime();
        long comp = d.getTime();
        while (n) {
            s = this.client.getHttpServer();
            if (s != null && !s.equals("") || comp > ms * 500L) {
                n = false;
            }
            comp = d.getTime();
        }
        if (s == null || s.equals("")) {
            throw new TrexException(7218);
        }
        URL url = null;
        try {
            url = HttpServerURL.getURL(s);
        }
        catch (TrexException e) {
            log.errorT("MalformedURLException" + e.getMessage());
        }
        log.infoT("Http Server set by Name Server to " + s);
        return url;
    }

    private void clearInputStream(HttpURLConnection connection) {
        if (connection != null) {
            InputStream in = null;
            try {
                in = connection.getInputStream();
                byte[] buf = new byte[65536];
                int read = 0;
                while ((read = in.read(buf)) != -1) {
                }
            }
            catch (IOException ex) {
                log.debugT("catched Exception while trying to clear InputStream:  " + ex.getMessage());
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.debugT("catched Exception while trying to clear InputStream:  " + ex.getMessage());
                }
                Object var2_2 = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

