/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.queueserver;

import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.IndexDocument;
import com.sapportals.trex.core.queueserver.DocStateReturn;
import com.sapportals.trex.core.queueserver.GetEntriesReturn;
import com.sapportals.trex.core.queueserver.QueueDocReturn;
import com.sapportals.trex.core.queueserver.QueueList;
import com.sapportals.trex.core.queueserver.QueueParameter;
import com.sapportals.trex.core.queueserver.QueueParameters;
import com.sapportals.trex.core.queueserver.QueueReturn;
import com.sapportals.trex.core.queueserver.QueueStateList;
import com.sapportals.trex.core.queueserver.QueueStateReturn;
import com.sapportals.trex.core.util.Location;
import java.util.ArrayList;
import java.util.Vector;

public class QueueServerResponseReactor {
    private IndexDocument currentDocument;
    private Vector errorDocumentVector = new Vector();
    private Vector optimizeErrorDocumentVector = new Vector();
    private String indexId;
    private String host;
    private int port;
    private int qState;
    private String since;
    private ArrayList docStateList;
    private TrexReturn trexReturn = null;
    private TrexReturn returnForException;
    private int returnCode = 0;
    private String returnText = "No Error";
    private String docId;
    private ArrayList delQDocList;
    private boolean initialMode;
    private String mergeTime;
    private long maxBytesForIndex;
    private GetEntriesReturn getEntriesReturn;
    private QueueDocReturn queueDocReturn;
    private QueueList queueList;
    private QueueStateList queueStateList;
    private QueueStateReturn queueStateReturn;
    private ArrayList qDocList;
    private DocStateReturn docStateReturn;
    private QueueParameter queueParameter;
    private QueueParameters queueParameterList;
    private QueueReturn queueReturn;
    private String qDocId;
    private int qDocSize;
    private int qDocState;
    private int qDocAction;
    private int qRetryCount;
    private Location indexServerLocation;
    private int traceLevel;
    private String tracePath;
    private int indexBulkSize;
    private int optimizeBulkSize;
    private int maxRetryCount;
    private int scheduleType;
    private String scheduleTime;
    private int scheduleMaxDocs;
    private int agingOKTime;
    private int maxOKDocs;
    private String replicationTime;
    private boolean replicateAfterOptimize;
    private int docState;
    private int docSum;

    public void setIndexId(String id) {
        this.indexId = id;
    }

    public void setQueueStateReturnQState(String qS) {
        this.qState = Integer.valueOf(qS);
    }

    public void setQueueStateReturnSince(String s) {
        this.since = s;
    }

    public void storeDocumentInDocumentList() {
        this.errorDocumentVector.addElement(this.currentDocument);
    }

    public void createNewDocument() {
        this.currentDocument = new IndexDocument();
    }

    public void setDocumentID(String id) {
        try {
            this.currentDocument.setDocumentKey(id);
        }
        catch (Exception e) {
            System.out.println("TrexException while setting document key to '" + id + "'");
        }
    }

    public void setDocumentReturnCode() {
        this.currentDocument.setLastError(this.trexReturn);
    }

    void setReturn(TrexReturn ret_) {
        this.trexReturn = ret_;
    }

    public Vector getErrorDocumentVector() {
        return this.errorDocumentVector;
    }

    public Vector getOptimizeErrorDocumentVector() {
        return this.optimizeErrorDocumentVector;
    }

    TrexReturn getReturn() {
        if (this.trexReturn == null) {
            this.trexReturn = new TrexReturn(0);
        }
        return this.trexReturn;
    }

    public void start_TrexReturn() {
        this.trexReturn = null;
        this.returnCode = 0;
        this.returnText = null;
    }

    public void end_TrexReturn() {
        this.trexReturn = null;
        this.trexReturn = TrexReturn.createExternalError(this.returnCode, this.returnText);
        this.returnCode = 0;
        this.returnText = null;
    }

    public void start_IndexServerLocation() {
        this.host = "";
        this.port = 0;
    }

    public void end_IndexServerLocation() {
        this.indexServerLocation = new Location(this.host, this.port);
    }

    public void start_TrexReturnForException() {
        this.returnForException = null;
        this.returnCode = 0;
        this.returnText = null;
    }

    public void end_TrexReturnForException() {
        this.returnForException = null;
        this.returnForException = TrexReturn.createExternalError(this.returnCode, this.returnText);
        this.returnCode = 0;
        this.returnText = "";
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = Integer.valueOf(returnCode);
    }

    public void setReturnText(String s) {
        this.returnText = s;
    }

    public void storeErrorCodeForException() {
        TrexReturn ret = null;
        this.returnForException = ret = TrexReturn.createExternalError(this.returnCode, this.returnText);
    }

    public TrexReturn getExceptionReturn() {
        return this.returnForException;
    }

    public String getGetEntriesReturnIndexId() {
        return this.getEntriesReturn.getIndexId();
    }

    public void setGetEntriesReturnIndexId(String indexId) {
        this.getEntriesReturn.setIndexId(indexId);
    }

    public void setIndexIdOfQueueList() {
        this.queueList.setIndexId(this.indexId);
    }

    public GetEntriesReturn getGetEntries() {
        return this.getEntriesReturn;
    }

    public QueueStateList getQueues() {
        return this.queueStateList;
    }

    public QueueList suspend() {
        return this.queueList;
    }

    public QueueList deleteEntries() {
        return this.queueList;
    }

    public QueueList activate() {
        return this.queueList;
    }

    public QueueList flushQueue() {
        return this.queueList;
    }

    public void createQueueList() {
        this.queueList = new QueueList();
    }

    public void createQueueStateList() {
        this.queueStateList = new QueueStateList();
    }

    public void addDocIdToDelQDocList() {
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public void createQDocListOfGetEntriesReturn() {
        this.qDocList = new ArrayList();
    }

    public void addQueueReturnToQueueList() {
        this.queueList.addQueueReturn(this.queueReturn);
    }

    public void setIndexIdOfQueueReturn() {
        this.queueReturn = new QueueReturn();
        this.queueReturn.setId(this.indexId);
    }

    public void createGetEntriesReturn() {
        this.getEntriesReturn = new GetEntriesReturn();
    }

    public QueueDocReturn getQueueDocReturn() {
        return this.queueDocReturn;
    }

    public void createQueueDocReturn() {
        this.queueDocReturn = new QueueDocReturn();
    }

    public void setQDocListOfGetEntriesReturn() {
        this.getEntriesReturn.setQDocList(this.qDocList);
    }

    public void setQDocId(String docId) {
        this.qDocId = docId;
    }

    public void setQDocState(String qDocState) {
        this.qDocState = Integer.valueOf(qDocState);
    }

    public void setQDocAction(String qDocAction) {
        this.qDocAction = Integer.valueOf(qDocAction);
    }

    public void setQRetryCount(String retryCount) {
        this.qRetryCount = Integer.valueOf(retryCount);
    }

    public void createQueueDocReturnDocState() {
        this.docStateReturn = new DocStateReturn();
    }

    public void start_QueueStateReturn() {
        this.indexId = null;
        this.qState = 0;
        this.since = null;
        this.docStateList = new ArrayList();
    }

    public void end_QueueStateReturn() {
        this.queueStateReturn = new QueueStateReturn(this.indexId, this.qState, this.since, this.docStateList, this.trexReturn);
    }

    public void createDocStateList() {
        this.docStateList = new ArrayList();
    }

    public void start_QueueDocReturn() {
        this.qDocId = "";
        this.qDocSize = 0;
        this.qDocState = 0;
        this.qDocAction = 0;
        this.qRetryCount = 0;
    }

    public void setDocSize(String ds) {
        this.qDocSize = Integer.valueOf(ds);
    }

    public void end_QueueDocReturn() {
        this.queueDocReturn = new QueueDocReturn(this.qDocId, this.trexReturn, this.qDocSize, this.qDocState, this.qDocAction, this.qRetryCount);
    }

    public void addQDocStateToQDocList() {
        this.qDocList.add(this.queueDocReturn);
    }

    public void addDocStateReturnToDocStateList() {
        this.docStateList.add(this.docStateReturn);
    }

    public void addQueueStateReturnToQueueStateList() {
        this.queueStateList.addQStateReturn(this.queueStateReturn);
    }

    public void addQueueParameterToQueueParameterList() {
        this.queueParameterList.addQueueParameter(this.queueParameter);
    }

    public void setDocStateReturnDocState(String dS) {
        this.docState = Integer.valueOf(dS);
    }

    public void setDocStateReturnDocSum(String s) {
        this.docSum = Integer.valueOf(s);
    }

    public void start_DocStateReturn() {
        this.docState = 0;
        this.docSum = 0;
    }

    public void end_DocStateReturn() {
        this.docStateReturn = new DocStateReturn(this.docState, this.docSum);
    }

    public void start_QueueReturn() {
        this.trexReturn = null;
        this.indexId = "";
        this.docId = "";
    }

    public void end_QueueReturnIndexId() {
        this.queueReturn = new QueueReturn(this.indexId, this.trexReturn);
    }

    public void end_QueueReturnDocId() {
        this.queueReturn = new QueueReturn(this.docId, this.trexReturn);
        this.queueList.addQueueReturn(this.queueReturn);
    }

    public QueueParameters getParameter() {
        return this.queueParameterList;
    }

    public void createQueueParameterList() {
        this.queueParameterList = new QueueParameters();
    }

    public void start_QueueParameter() {
        this.indexId = null;
        this.trexReturn = new TrexReturn(0);
        this.indexServerLocation = null;
        this.traceLevel = 0;
        this.tracePath = "";
        this.indexBulkSize = 0;
        this.optimizeBulkSize = 0;
        this.maxRetryCount = 0;
        this.scheduleType = 0;
        this.scheduleTime = "";
        this.scheduleMaxDocs = 0;
        this.agingOKTime = 0;
        this.maxOKDocs = 0;
        this.mergeTime = "";
        this.maxBytesForIndex = 0L;
        this.replicationTime = "";
        this.replicateAfterOptimize = false;
    }

    public void end_QueueParameter() {
        this.queueParameter = new QueueParameter(this.indexId, this.trexReturn, this.traceLevel, this.indexBulkSize, this.optimizeBulkSize, this.maxRetryCount, this.scheduleType, this.scheduleTime, this.scheduleMaxDocs, this.initialMode, this.mergeTime, this.maxBytesForIndex, this.replicationTime, this.replicateAfterOptimize);
    }

    public void setQueueParameterInitialMode(String data) {
        this.initialMode = data.equalsIgnoreCase("YES");
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = Integer.valueOf(port);
    }

    public void setQueueParameterTraceLevel(String tL) {
        this.traceLevel = Integer.valueOf(tL);
    }

    public void setQueueParameterTracePath(String tP) {
        this.tracePath = tP;
    }

    public void setQueueParameterIndexBulkSize(String iBS) {
        this.indexBulkSize = Integer.valueOf(iBS);
    }

    public void setQueueParameterOptimizeBulkSize(String oBS) {
        this.optimizeBulkSize = Integer.valueOf(oBS);
    }

    public void setQueueParameterMaxRetryCount(String mRC) {
        this.maxRetryCount = Integer.valueOf(mRC);
    }

    public void setQueueParameterScheduleType(String sT) {
        if (sT.equalsIgnoreCase("time")) {
            this.scheduleType = 0;
        }
        if (sT.equalsIgnoreCase("count")) {
            this.scheduleType = 1;
        }
        if (sT.equalsIgnoreCase("both")) {
            this.scheduleType = 2;
        }
    }

    public void setQueueParameterScheduleTime(String sTime) {
        this.scheduleTime = sTime;
    }

    public void setQueueParameterScheduleMaxDocs(String sMD) {
        this.scheduleMaxDocs = Integer.valueOf(sMD);
    }

    public void setQueueParameterAgingOKTime(String aOT) {
        this.agingOKTime = Integer.valueOf(aOT);
    }

    public void setQueueParameterMaxOKDos(String mOD) {
        this.maxOKDocs = Integer.valueOf(mOD);
    }

    public void setQueueParameterMergeTime(String mT) {
        this.mergeTime = mT;
    }

    public void setQueueParameterMaxBytesForIndex(String mBFI) {
        this.maxBytesForIndex = Long.valueOf(mBFI);
    }

    public void setReplicationTime(String repTime) {
        this.replicationTime = repTime;
    }

    public void setReplicateAfterOptimize(String data) {
        this.replicateAfterOptimize = data.equalsIgnoreCase("YES");
    }

    public QueueList deleteQueues() {
        return this.queueList;
    }

    public QueueList resetFailedEntries() {
        return this.queueList;
    }
}

