/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.queueserver;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.queueserver.AbstractQueueServer;
import com.sapportals.trex.core.queueserver.GetEntriesReturn;
import com.sapportals.trex.core.queueserver.HttpQueueServer;
import com.sapportals.trex.core.queueserver.QueueEntryChoice;
import com.sapportals.trex.core.queueserver.QueueList;
import com.sapportals.trex.core.queueserver.QueueParameter;
import com.sapportals.trex.core.queueserver.QueueParameters;
import com.sapportals.trex.core.queueserver.QueueStateList;
import com.sapportals.trex.core.util.HttpServerURL;
import java.util.ArrayList;

public class QueueServerManager
extends BaseManager {
    private String mode;
    private String m_httpserverurl;
    private boolean m_httpserverManuallySet = false;
    private QueueEntryChoice choice;
    private ArrayList indexIdList = new ArrayList();
    private String m_indexId;
    private com.sapportals.trex.core.util.Location queueServerLocation;
    public static final int TREX_QDOC_STATE_TO_RESOLVE = 0;
    public static final int TREX_QDOC_STATE_RESOLVE_URL_FAILED = 1;
    public static final int TREX_QDOC_STATE_TO_TRANSMIT = 2;
    public static final int TREX_QDOC_STATE_TRANSMIT_FAILED = 3;
    public static final int TREX_QDOC_STATE_TO_SYNCHRONIZE = 4;
    public static final int TREX_QDOC_STATE_SYNCHRONIZE_FAILED = 5;
    public static final int TREX_QDOC_STATE_SYNCHRONIZED = 6;
    public static final int TREX_QDOC_STATE_INVALID = 7;
    public static final int TREX_QDOC_STATE_DELAYED = 8;
    public static final int TREX_QDOC_STATE_PREPROCESSING = 9;
    public static final int TREX_QDOC_STATE_TRANSMITTING = 10;
    public static final int TREX_QDOC_STATE_SYNCHRONIZING = 11;
    public static final int TREX_QDOC_ACTION_INDEX_DOC = 0;
    public static final int TREX_QDOC_ACTION_DEINDEX_DOC = 1;
    public static final int TREX_QDOC_ACTION_INVALID = 2;
    public static final int TREX_QUEUE_STATE_IDLE = 0;
    public static final int TREX_QUEUE_STATE_INDEXING = 1;
    public static final int TREX_QUEUE_STATE_INDEXING_SUSPEND_IN_PROGRESS = 2;
    public static final int TREX_QUEUE_STATE_OPTIMIZING = 3;
    public static final int TREX_QUEUE_STATE_OPTIMIZING_SUSPEND_IN_PROGRESS = 4;
    public static final int TREX_QUEUE_STATE_SUSPEND = 5;
    public static final int TREX_QUEUE_STATE_STOPPED = 6;
    public static final int TREX_QUEUE_STATE_INVALID = 7;
    public static final int TREX_QUEUE_STATE_REPAIRING = 8;
    public static final int TREX_QUEUE_STATE_MERGING = 9;
    public static final int TREX_QUEUE_STATE_REPLICATING = 10;
    public static final int TREX_QUEUE_STATE_REPAIRING_SUSPEND_IN_PROGRESS = 11;
    public static final int TREX_QUEUE_STATE_MERGING_SUSPEND_IN_PROGRESS = 12;
    public static final int TREX_QUEUE_STATE_REPLICATING_SUSPEND_IN_PROGRESS = 13;
    public static final int TREX_QUEUE_STATE_TO_BE_ROLLBACKED = 14;
    public static final int TREX_QUEUE_STATE_TO_BE_ROLLBACKED_SUSPENDED = 15;
    public static final int TREX_QUEUE_STATE_ROLLINGBACK = 16;
    public static final int TREX_QUEUE_STATE_ROLLINGBACK_SUSPEND_IN_PROGRESS = 17;
    public static final int TREX_SCHEDULE_TYPE_TIME = 0;
    public static final int TREX_SCHEDULE_TYPE_COUNT = 1;
    public static final int TREX_SCHEDULE_TYPE_BOTH = 2;
    public static final int TREX_SCHEDULE_TYPE_INVALID = 3;
    public static final int QE_CHOICE_CHOICE_UNKNOWN = 0;
    public static final int QE_CHOICE_CHOICE_KEYS = 1;
    public static final int QE_CHOICE_CHOICE_DOCSTATE = 2;
    public static final int QE_CHOICE_CHOICE_RETRY_COUNT = 3;
    public static final int TREX_QDOC_STATE_FAILED_URL_RESOLVE = 0;
    public static final int TREX_QDOC_STATE_FAILED_TRANSMIT = 1;
    public static final int TREX_QDOC_STATE_FAILED_SYNCHRONIZE = 2;
    public static final int TREX_QDOC_STATE_FAILED_INVALID = 3;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$queueserver$QueueServerManager == null ? (class$com$sapportals$trex$core$queueserver$QueueServerManager = QueueServerManager.class$("com.sapportals.trex.core.queueserver.QueueServerManager")) : class$com$sapportals$trex$core$queueserver$QueueServerManager).getName());
    static /* synthetic */ Class class$com$sapportals$trex$core$queueserver$QueueServerManager;

    public void setQueueServerLocation(String queueServerHost, int queueServerPort) throws TrexException {
        this.queueServerLocation = new com.sapportals.trex.core.util.Location(queueServerHost, queueServerPort);
        this.indexIdList = new ArrayList();
    }

    public void setQueueParameter(QueueParameter qp) throws TrexException {
        AbstractQueueServer queueServer = this.getNewQueueServerInstance();
        queueServer.setQueueParam(qp);
        queueServer.setQueueParameter();
    }

    public void setQueueEntryChoice(QueueEntryChoice choice) {
        this.choice = choice;
    }

    public void setIndexId(String indexName) throws TrexException {
        this.m_indexId = indexName;
        this.indexIdList.clear();
        this.indexIdList.add(indexName);
    }

    public void setIndexId(String indexName, String searchEngine, String mode, String host, int port, String file) throws TrexException {
        this.indexIdList.clear();
        this.indexIdList.add(indexName);
        this.m_indexId = indexName;
        this.mode = mode;
        this.m_httpserverManuallySet = true;
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
    }

    public QueueStateList getQueues() throws TrexException {
        QueueStateList result = new QueueStateList();
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        result = queueserver.getQueues();
        return result;
    }

    public QueueStateList getQueuesByIndexId() throws TrexException {
        QueueStateList result = new QueueStateList();
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        queueserver.setIndexIdList(this.indexIdList);
        log.infoT("GetQueues started");
        result = queueserver.getQueues();
        log.infoT("GetQueues finished");
        return result;
    }

    public QueueStateList getQueuesByQueueServerLocation(String nameSpace) throws TrexException {
        AbstractQueueServer queueServer = this.getNewQueueServerInstance();
        queueServer.setNameSpace(nameSpace);
        if (this.queueServerLocation == null) {
            throw new TrexException(7236);
        }
        queueServer.setQueueServerLocation(this.queueServerLocation);
        log.infoT("Start of Get Queues by Location");
        QueueStateList qsl = queueServer.getQueues();
        log.infoT("End of get Queues by Location");
        return qsl;
    }

    public QueueStateList getQueuesByQueueServerLocation() throws TrexException {
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        if (this.queueServerLocation == null) {
            throw new TrexException(7236);
        }
        queueserver.setQueueServerLocation(this.queueServerLocation);
        log.infoT("Start of Get Queues by Location");
        QueueStateList qsl = queueserver.getQueues();
        log.infoT("End of get Queues by Location");
        return qsl;
    }

    public GetEntriesReturn getEntries() throws TrexException {
        if (this.m_indexId == null) {
            throw new TrexException(7230);
        }
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        queueserver.setChoice(this.choice);
        queueserver.setIndex(this.m_indexId);
        log.infoT("Start of Get Entries");
        GetEntriesReturn getEn = queueserver.getEntries();
        log.infoT("End of Get Entries");
        return getEn;
    }

    public QueueParameters getQueueParameter() throws TrexException {
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        queueserver.setIndexIdList(this.indexIdList);
        log.infoT("Start of Get Queue Parameter");
        QueueParameters result = queueserver.getQueueParameter();
        log.infoT("End of Get Queue Parameter");
        return result;
    }

    public void addIndexId(String indexName) throws TrexException {
        this.indexIdList.add(indexName);
    }

    public void addIndexId(String indexName, String searchEngine, String mode, String host, int port, String file) throws TrexException {
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
        this.m_httpserverManuallySet = true;
        this.indexIdList.add(indexName);
    }

    public QueueList suspendQueues() throws TrexException {
        QueueList result = new QueueList();
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        AbstractQueueServer qs = this.getNewQueueServerInstance();
        qs.setIndexIdList(this.indexIdList);
        log.infoT("Suspend Queues started.");
        result = qs.suspendQueues();
        log.infoT("Suspend Queues finished.");
        return result;
    }

    public QueueList flushQueues() throws TrexException {
        QueueList result = new QueueList();
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        AbstractQueueServer qs = this.getNewQueueServerInstance();
        qs.setIndexIdList(this.indexIdList);
        log.infoT("Flush Queues started.");
        result = qs.flushQueues();
        log.infoT("Flush Queues finished.");
        return result;
    }

    public QueueList activateQueues() throws TrexException {
        QueueList result = new QueueList();
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        AbstractQueueServer qs = this.getNewQueueServerInstance();
        qs.setIndexIdList(this.indexIdList);
        log.infoT("Start of Activate Queues");
        result = qs.activateQueues();
        log.infoT("End of Activate Queues");
        return result;
    }

    public QueueList deleteEntries() throws TrexException {
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        queueserver.setChoice(this.choice);
        if (this.m_indexId == null || this.m_indexId.equals("")) {
            throw new TrexException(7230);
        }
        queueserver.setIndex(this.m_indexId);
        log.infoT("Delete Entries started.");
        QueueList delEn = queueserver.deleteEntries();
        log.infoT("Delete Entries finished.");
        return delEn;
    }

    public boolean shutDownServer(String host, int port) throws TrexException {
        throw new UnsupportedOperationException("Method shutDownServer() not yet implemented.");
    }

    public QueueList resetFailedEntries(int failedType, ArrayList errCodes) throws TrexException {
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        if (this.indexIdList == null || this.indexIdList.size() == 0) {
            throw new TrexException(7230);
        }
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        queueserver.setIndexIdList(this.indexIdList);
        queueserver.setErrCodeList(errCodes);
        queueserver.setFailedType(failedType);
        QueueList qsl = queueserver.resetFailedEntries();
        return qsl;
    }

    public QueueList resetFailedEntriesByQueues(int failedType) throws TrexException {
        if (this.indexIdList == null || this.indexIdList.isEmpty()) {
            throw new TrexException(7230);
        }
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        queueserver.setIndexIdList(this.indexIdList);
        queueserver.setFailedType(failedType);
        queueserver.setQueueServerLocation(null);
        QueueList qsl = queueserver.resetFailedEntries();
        return qsl;
    }

    public QueueList resetFailedEntriesByQueueServerLocation(int failedType) throws TrexException {
        AbstractQueueServer queueserver = this.getNewQueueServerInstance();
        if (this.queueServerLocation == null) {
            throw new TrexException(7236);
        }
        queueserver.setQueueServerLocation(this.queueServerLocation);
        queueserver.setIndexIdList(null);
        QueueList qsl = queueserver.resetFailedEntries();
        return qsl;
    }

    private AbstractQueueServer getNewQueueServerInstance() throws TrexException {
        HttpQueueServer httpQueueServer = new HttpQueueServer();
        httpQueueServer.setIndexUser(this.m_indexUser);
        httpQueueServer.setSSLApplicationPath(this.m_SSLApplicationPath);
        if (this.m_httpserverManuallySet) {
            httpQueueServer.setHttpServerManuallySet(this.m_httpserverManuallySet);
            try {
                httpQueueServer.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException e1) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + e1.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        return httpQueueServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

