/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.queueserver;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.queueserver.AbstractQueueServer;
import com.sapportals.trex.core.queueserver.GetEntriesReturn;
import com.sapportals.trex.core.queueserver.HttpActivateRequest;
import com.sapportals.trex.core.queueserver.HttpDeleteEntriesRequest;
import com.sapportals.trex.core.queueserver.HttpDeleteQueuesRequest;
import com.sapportals.trex.core.queueserver.HttpFlushQueueRequest;
import com.sapportals.trex.core.queueserver.HttpGetEntriesRequest;
import com.sapportals.trex.core.queueserver.HttpGetParameterRequest;
import com.sapportals.trex.core.queueserver.HttpGetQueuesRequest;
import com.sapportals.trex.core.queueserver.HttpResetFailedEntriesRequest;
import com.sapportals.trex.core.queueserver.HttpSetParameterRequest;
import com.sapportals.trex.core.queueserver.HttpShutDownServerRequest;
import com.sapportals.trex.core.queueserver.HttpSuspendRequest;
import com.sapportals.trex.core.queueserver.QueueList;
import com.sapportals.trex.core.queueserver.QueueParameters;
import com.sapportals.trex.core.queueserver.QueueStateList;
import com.sapportals.trex.util.xmlwriter.XMLWriter;

class HttpQueueServer
extends AbstractQueueServer {
    HttpQueueServer() {
    }

    public void formatGetEntriesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest", 2);
        w.startElement("GetEntries");
        w.dataElement("IndexID", this.m_index);
        w.startElement("Choice");
        if (this.choice.getChoice() == 2) {
            w.dataElement("DocState", String.valueOf(this.choice.getDocumentState()));
        } else if (this.choice.getChoice() == 3) {
            w.dataElement("RetryLevel", String.valueOf(this.choice.getRetryCount()));
        } else if (this.choice.getChoice() == 1) {
            w.startElement("DocIDList");
            int i = 0;
            while (i < this.choice.getDocIdList().size()) {
                if (!((String)this.choice.getDocIdList().get(i)).equals("")) {
                    w.dataElement("DocID", (String)this.choice.getDocIdList().get(i));
                }
                ++i;
            }
            w.endElement("DocIDList");
        }
        w.endElement("Choice");
        w.endElement("GetEntries");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public GetEntriesReturn getEntries() throws TrexException {
        HttpGetEntriesRequest request = new HttpGetEntriesRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().getGetEntries();
    }

    public void formatGetQueuesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("GetQueues");
        if (this.indexIdList != null) {
            w.startElement("QueueList");
            int i = 0;
            while (i < this.indexIdList.size()) {
                String id = (String)this.indexIdList.get(i);
                w.dataElement("IndexID", id);
                ++i;
            }
            w.endElement("QueueList");
        } else if (this.queueServerLocation != null) {
            w.startElement("QueueServerLocation");
            w.dataElement("Host", this.queueServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.queueServerLocation.getPort()));
            if (this.nameSpace != null) {
                w.dataElement("NameSpace", this.nameSpace);
            }
            w.endElement("QueueServerLocation");
        } else if (this.indexIdList == null && this.queueServerLocation == null) {
            w.startElement("QueueList");
            w.endElement("QueueList");
        }
        w.endElement("GetQueues");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueStateList getQueues() throws TrexException {
        HttpGetQueuesRequest request = new HttpGetQueuesRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().getQueues();
    }

    public void formatSuspendRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("Suspend");
        if (this.indexIdList != null) {
            w.startElement("QueueList");
            int i = 0;
            while (i < this.indexIdList.size()) {
                String id = (String)this.indexIdList.get(i);
                w.dataElement("IndexID", id);
                ++i;
            }
        }
        w.endElement("QueueList");
        w.endElement("Suspend");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueList suspendQueues() throws TrexException {
        HttpSuspendRequest request = new HttpSuspendRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().suspend();
    }

    public void formatActivateRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("Activate");
        if (this.indexIdList != null) {
            w.startElement("QueueList");
            int i = 0;
            while (i < this.indexIdList.size()) {
                String id = (String)this.indexIdList.get(i);
                w.dataElement("IndexID", id);
                ++i;
            }
            w.endElement("QueueList");
        }
        w.endElement("Activate");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueList activateQueues() throws TrexException {
        HttpActivateRequest request = new HttpActivateRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().activate();
    }

    public void formatFlushQueueRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("FlushQueue");
        if (this.indexIdList != null) {
            w.startElement("QueueList");
            int i = 0;
            while (i < this.indexIdList.size()) {
                String id = (String)this.indexIdList.get(i);
                w.dataElement("IndexID", id);
                ++i;
            }
            w.endElement("QueueList");
        }
        w.endElement("FlushQueue");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueList flushQueues() throws TrexException {
        HttpFlushQueueRequest request = new HttpFlushQueueRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().flushQueue();
    }

    public void formatShutDownServerRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("ShutDown");
        w.startElement("QueueServerLocation");
        w.dataElement("Host", this.queueServerLocation.getHost());
        w.dataElement("Port", String.valueOf(this.queueServerLocation.getPort()));
        w.endElement("QueueServerLocation");
        w.endElement("ShutDown");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public void shutDown() throws TrexException {
        HttpShutDownServerRequest request = new HttpShutDownServerRequest(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatGetQueueParameterRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest", 5);
        w.startElement("GetParameter");
        if (this.indexIdList != null) {
            w.startElement("QueueList");
            int i = 0;
            while (i < this.indexIdList.size()) {
                String id = (String)this.indexIdList.get(i);
                w.dataElement("IndexID", id);
                ++i;
            }
            w.endElement("QueueList");
        }
        w.endElement("GetParameter");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueParameters getQueueParameter() throws TrexException {
        HttpGetParameterRequest request = new HttpGetParameterRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().getParameter();
    }

    public void formatSetQueueParameterRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("SetParameter");
        w.dataElement("IndexID", this.queueParam.getIndexId());
        if (this.queueParam.getTraceLevel() != -1) {
            w.dataElement("TraceLevel", String.valueOf(this.queueParam.getTraceLevel()));
        }
        if (this.queueParam.getIndexBulkSize() != -1) {
            w.dataElement("IndexBulkSize", String.valueOf(this.queueParam.getIndexBulkSize()));
        }
        if (this.queueParam.getOptimizeBulkSize() != -1) {
            w.dataElement("OptimizeBulkSize", String.valueOf(this.queueParam.getOptimizeBulkSize()));
        }
        if (this.queueParam.getMaxRetryCount() != -1) {
            w.dataElement("MaxRetryCount", String.valueOf(this.queueParam.getMaxRetryCount()));
        }
        if (this.queueParam.getScheduleType() != -1) {
            switch (this.queueParam.getScheduleType()) {
                case 0: {
                    w.dataElement("ScheduleType", "time");
                    break;
                }
                case 1: {
                    w.dataElement("ScheduleType", "count");
                    break;
                }
                case 2: {
                    w.dataElement("ScheduleType", "both");
                }
            }
        }
        if (this.queueParam.getScheduleTime() != null && !this.queueParam.getScheduleTime().equals("")) {
            w.dataElement("ScheduleTime", this.queueParam.getScheduleTime());
        }
        if (this.queueParam.getScheduleMaxDocs() != -1) {
            w.dataElement("ScheduleMaxDocs", String.valueOf(this.queueParam.getScheduleMaxDocs()));
        }
        if (this.queueParam.getInitialMode()) {
            w.dataElement("InitialMode", "YES");
        } else {
            w.dataElement("InitialMode", "NO");
        }
        if (this.queueParam.getMergeTime() != null || this.queueParam.getMergeTime().equals("")) {
            w.dataElement("MergeTime", this.queueParam.getMergeTime());
        }
        if (this.queueParam.getMaxBytesForIndex() != -1L) {
            w.dataElement("MaxBytesForIndex", String.valueOf(this.queueParam.getMaxBytesForIndex()));
        }
        if (this.queueParam.getReplicationTime() != null && !this.queueParam.getReplicationTime().equals("")) {
            w.dataElement("ReplicationTime", this.queueParam.getReplicationTime());
        }
        if (this.queueParam.getReplicateAfterOptimize()) {
            w.dataElement("ReplicateAfterOptimize", "YES");
        } else {
            w.dataElement("ReplicateAfterOptimize", "NO");
        }
        w.endElement("SetParameter");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public void setQueueParameter() throws TrexException {
        HttpSetParameterRequest request = new HttpSetParameterRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
    }

    public void formatDeleteEntriesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("DeleteEntries");
        w.dataElement("IndexID", this.m_index);
        w.startElement("Choice");
        if (this.choice.getChoice() == 2) {
            w.dataElement("DocState", String.valueOf(this.choice.getDocumentState()));
        } else if (this.choice.getChoice() == 3) {
            w.dataElement("RetryLevel", String.valueOf(this.choice.getRetryCount()));
        } else if (this.choice.getChoice() == 1) {
            w.startElement("DocIDList");
            int i = 0;
            while (i < this.choice.getDocIdList().size()) {
                String docId = (String)this.choice.getDocIdList().get(i);
                w.dataElement("DocID", docId);
                ++i;
            }
            w.endElement("DocIDList");
        }
        w.endElement("Choice");
        w.endElement("DeleteEntries");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueList deleteEntries() throws TrexException {
        HttpDeleteEntriesRequest request = new HttpDeleteEntriesRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().deleteEntries();
    }

    public void formatDeleteQueuesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("DeleteQueues");
        w.startElement("QueueList");
        int i = 0;
        while (i < this.indexIdList.size()) {
            String id = (String)this.indexIdList.get(i);
            w.dataElement("IndexID", id);
            ++i;
        }
        w.endElement("QueueList");
        w.endElement("DeleteQueues");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueList deleteQueues() throws TrexException {
        HttpDeleteQueuesRequest request = new HttpDeleteQueuesRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().deleteQueues();
    }

    public void formatResetFailedEntries(XMLWriter w) throws Exception {
        int i;
        w.startDocument();
        w.startElement("QServerRequest");
        w.startElement("ResetFailedEntries");
        w.startElement("Source");
        if (this.queueServerLocation != null) {
            w.startElement("QueueServerLocation");
            w.dataElement("Host", this.queueServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.queueServerLocation.getPort()));
            w.endElement("QueueServerLocation");
        } else {
            w.startElement("QueueList");
            i = 0;
            while (i < this.indexIdList.size()) {
                w.dataElement("IndexID", (String)this.indexIdList.get(i));
                ++i;
            }
            w.endElement("QueueList");
        }
        w.endElement("Source");
        w.dataElement("FailedDocStateType", String.valueOf(this.failedType));
        if (this.m_errCodeList != null && this.m_errCodeList.size() > 0) {
            w.startElement("RCodeList");
            i = 0;
            while (i < this.m_errCodeList.size()) {
                w.dataElement("RCode", String.valueOf((Integer)this.m_errCodeList.get(i)));
                ++i;
            }
            w.endElement("RCodeList");
        }
        w.endElement("ResetFailedEntries");
        w.endElement("QServerRequest");
        w.endDocument();
    }

    public QueueList resetFailedEntries() throws TrexException {
        HttpResetFailedEntriesRequest request = new HttpResetFailedEntriesRequest(this);
        request.setHttpQueueServer(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().resetFailedEntries();
    }
}

