/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.net;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.net.BufferedIO;
import com.sapportals.trex.core.net.BufferedInput;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.Channel;
import com.sapportals.trex.core.net.SAP_STRING;
import com.sapportals.trex.core.net.StreamTypeException;
import com.sapportals.trex.core.util.HttpsConnectionFactory;
import com.sapportals.trex.core.util.SSLConfigurationManager;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class Request {
    protected String itsMethod;
    protected long itsDuration;
    protected Channel itsChannel = null;
    protected BufferedOutput m_output = null;
    protected BufferedInput m_input = null;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$net$Request == null ? (class$com$sapportals$trex$core$net$Request = Request.class$("com.sapportals.trex.core.net.Request")) : class$com$sapportals$trex$core$net$Request).getName());
    protected Socket socket = null;
    static /* synthetic */ Class class$com$sapportals$trex$core$net$Request;

    public void open(String theMethodName, String theHost, int thePort) throws UnknownHostException, IOException {
        TrexConfigManager config = null;
        boolean isSecure = false;
        try {
            config = TrexFactory.getTrexConfigManager();
            isSecure = config.getIsSecure();
        }
        catch (TrexException ex) {
            log.debugT("Error when trying to read value for isSecure: " + ex.getMessage());
        }
        config = null;
        this.open(theMethodName, theHost, thePort, isSecure, null);
    }

    public void open(String theMethodName, String theHost, int thePort, boolean theSecure, String theCredFile) throws UnknownHostException, IOException {
        this.itsMethod = theMethodName;
        this.itsDuration = System.currentTimeMillis();
        if (!theSecure) {
            this.socket = new Socket(theHost, thePort);
        } else {
            SSLConfigurationManager conf = SSLConfigurationManager.getInstance();
            HttpsConnectionFactory factory = null;
            try {
                factory = conf.getHttpsConnectionFactory(null, null);
                this.socket = factory.createSocket(theHost, thePort);
                log.debugT("secure socket created Port: " + this.socket.getLocalPort());
            }
            catch (TrexException ex) {
                log.debugT("Error when trying to get HttpsConnectionFactory: " + ex.getMessage());
            }
            factory = null;
            conf = null;
        }
        this.socket.getLocalPort();
        log.infoT("Socket Port: " + this.socket.getLocalPort());
        this.socket.setSoLinger(true, 30);
        this.m_output = new BufferedOutput(this.socket);
        this.m_input = new BufferedInput(this.socket);
        this.writeHeader(this.m_output, theMethodName);
    }

    private void writeHeader_old(BufferedOutput theOut, String theMethod) throws IOException {
        theOut.writeIntegral(BufferedIO.TyBOF, 1);
        theOut.writeIntegral(0x18100800L, 4);
        SAP_STRING aStringBuffer = new SAP_STRING(theMethod);
        theOut.writeM(aStringBuffer);
    }

    private void writeHeader(BufferedOutput theOut, String theMethod) throws IOException {
        theOut.writeIntegral(BufferedIO.TyBOF, 1);
        theOut.writeIntegral(0x18100800L, 4);
        SAP_STRING aStringBuffer = new SAP_STRING(theMethod);
        theOut.writeMLen(aStringBuffer);
        theOut.writeIntegral(1L, 1);
        theOut.writeIntegral(1L, 1);
        theOut.writeIntegral(0L, 1);
        theOut.writeIntegral(0L, 1);
        theOut.writeM(aStringBuffer);
        theOut.flush();
    }

    public void close() throws IOException, StreamTypeException {
        this.m_output.close();
        this.m_input.close();
        this.socket.close();
        this.itsChannel = null;
    }

    public String getMethod() {
        return this.itsMethod;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.itsDuration;
    }

    public BufferedInput in() {
        return this.m_input;
    }

    public BufferedOutput out() {
        return this.m_output;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

