/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.net;

import com.sapportals.trex.core.net.BufferedInput;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.Communication;
import com.sapportals.trex.core.net.Request;
import com.sapportals.trex.core.net.SAP_LLONG;

public class PingService {
    public PingService(String theHost, int thePort, int theIterations) {
        try {
            SAP_LLONG aStartTime = new SAP_LLONG(0L);
            SAP_LLONG anEndTime = new SAP_LLONG(0L);
            Communication.initialize();
            int i = 0;
            while (i < theIterations) {
                Request aRequest = new Request();
                aRequest.open("__INT__PING", theHost, thePort);
                BufferedOutput anOut = aRequest.out();
                BufferedInput anIn = aRequest.in();
                aStartTime.setValue(System.currentTimeMillis());
                anOut.write(aStartTime);
                anIn.read(anEndTime);
                aRequest.close();
                System.out.println(aStartTime.getValue());
                System.out.println(anEndTime.getValue());
                ++i;
            }
            Communication.exit();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static void printHelp() {
        System.out.println("PingService -h <host> -p <port> [-i <iterations>]");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) {
        int i = 0;
        String aHost = null;
        int aPort = 0;
        int anIterCount = 1;
        while (i < args.length) {
            if (args[i].compareTo("-h") == 0) {
                if (++i >= args.length) {
                    PingService.printHelp();
                    return;
                }
                aHost = args[i];
            } else if (args[i].compareTo("-p") == 0) {
                if (++i >= args.length) {
                    PingService.printHelp();
                    return;
                }
                aPort = Integer.parseInt(args[i]);
            } else {
                if (args[i].compareTo("-i") != 0) {
                    PingService.printHelp();
                    return;
                }
                if (++i >= args.length) {
                    PingService.printHelp();
                    return;
                }
                anIterCount = Integer.parseInt(args[i]);
            }
            ++i;
        }
        if (aHost != null && aPort != 0) {
            PingService aPingService = new PingService(aHost, aPort, anIterCount);
            return;
        }
        PingService.printHelp();
    }
}

