/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.net;

import com.sapportals.trex.core.net.Channel;
import com.sapportals.trex.core.net.StreamTypeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Communication {
    private boolean itsInited;
    private boolean itsUseSSL;
    private String itsSecDir;
    private short itsMaxChannels;
    private short itsMaxEndPoints;
    private static short itsBufferSize;
    private static HashMap itsChannels;

    public static void initialize() {
        if (itsChannels == null) {
            itsChannels = new HashMap();
        }
        itsBufferSize = (short)8192;
    }

    public static void exit() {
        Set aSet = itsChannels.entrySet();
        Iterator anIterator = aSet.iterator();
        anIterator.hasNext();
    }

    public short getMaxEndPoints() {
        return this.itsMaxEndPoints;
    }

    public short getMaxChannels() {
        return this.itsMaxChannels;
    }

    public static short getBufferSize() {
        return itsBufferSize;
    }

    public boolean isSecure() {
        return this.itsUseSSL;
    }

    public String getSecDir() {
        return this.itsSecDir;
    }

    private static String getUniqHostId(String thePeerName, int thePeerPort) throws UnknownHostException {
        return InetAddress.getByName(thePeerName).getHostAddress() + Integer.toString(thePeerPort);
    }

    public static synchronized Channel getChannel(String thePeerName, int thePeerPort) throws IOException {
        String aKey = Communication.getUniqHostId(thePeerName, thePeerPort);
        Channel aChannel = (Channel)itsChannels.remove(aKey);
        if (aChannel == null) {
            aChannel = new Channel(thePeerName, thePeerPort);
        }
        return aChannel;
    }

    public static synchronized void putChannel(Channel theChannel) throws IOException, StreamTypeException {
        theChannel.clean();
        String aKey = Communication.getUniqHostId(theChannel.getPeerName(), theChannel.getPeerPort());
        theChannel.close();
    }

    static {
        itsChannels = null;
    }
}

