/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.net;

import com.sapportals.trex.core.net.BufferedInput;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.StreamTypeException;
import java.io.IOException;
import java.net.Socket;

class Channel {
    private static int Closed = 0;
    private static int Idle = 1;
    private static int Active = 2;
    private static int Erroneous = 3;
    private Socket itsSocket = null;
    private BufferedInput itsIn = null;
    private BufferedOutput itsOut = null;
    private String itsPeerName = null;
    private int itsPeerPort = 0;
    private int itsStatus = 0;

    public Channel(String thePeerName, int thePeerPort) throws IOException {
        this.itsPeerName = thePeerName;
        this.itsPeerPort = thePeerPort;
        this.itsSocket = new Socket(thePeerName, thePeerPort);
        this.itsIn = new BufferedInput(this.itsSocket);
        this.itsOut = new BufferedOutput(this.itsSocket);
        this.itsIn.tie(this.itsOut);
    }

    public BufferedInput getInput() {
        return this.itsIn;
    }

    public BufferedOutput getOutput() {
        return this.itsOut;
    }

    public void close() throws IOException {
        this.itsSocket.close();
    }

    public void clean() throws IOException, StreamTypeException {
        this.itsIn.readToEOF();
        this.itsOut.close();
        this.itsIn.close();
        this.itsSocket.close();
    }

    public String getPeerName() {
        return this.itsPeerName;
    }

    public int getPeerPort() {
        return this.itsPeerPort;
    }

    public int send(byte[] thePack, int theSize) {
        return theSize;
    }

    public int receive(byte[] theBuf, int theSize, Integer theBytesRead) {
        return theSize;
    }

    public boolean isIdle() {
        return true;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isGood() {
        return true;
    }

    public boolean isAlive() {
        return true;
    }

    public boolean isActive() {
        return false;
    }

    public void setStatus(int theNew) {
        this.itsStatus = theNew;
    }

    public int getStatus() {
        return this.itsStatus;
    }

    public int getBytesSent() {
        return 0;
    }

    public int getBytesReceived() {
        return 0;
    }

    public void resetCounters() {
        this.itsIn.resetCounter();
        this.itsOut.resetCounter();
    }

    public void touch() {
    }

    public long getFirstUsed() {
        return 0L;
    }

    public long getLastUsed() {
        return 0L;
    }
}

