/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.net;

import com.sapportals.trex.core.net.BufferedIO;
import com.sapportals.trex.core.net.SAP_BOOL;
import com.sapportals.trex.core.net.SAP_DOUBLE;
import com.sapportals.trex.core.net.SAP_INT;
import com.sapportals.trex.core.net.SAP_LLONG;
import com.sapportals.trex.core.net.SAP_SHORT;
import com.sapportals.trex.core.net.SAP_STRING;
import com.sapportals.trex.core.net.SAP_UC;
import com.sapportals.trex.core.net.SAP_UINT;
import com.sapportals.trex.core.net.SAP_USHORT;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class BufferedOutput {
    Socket itsSocket = null;
    BufferedOutputStream itsStream = null;
    long itsBytesWritten = 0L;

    public BufferedOutput(Socket theSocket) throws IOException {
        this.itsSocket = theSocket;
        this.itsStream = new BufferedOutputStream(this.itsSocket.getOutputStream());
        this.resetCounter();
    }

    void write(byte[] theBuffer) throws IOException {
        this.itsBytesWritten += (long)theBuffer.length;
        this.itsStream.write(theBuffer);
    }

    private void writeType(int theType) throws IOException {
        byte[] aTypeId = new byte[]{(byte)theType};
        this.write(aTypeId);
    }

    void writeIntegral(long theValue, int theBytes) throws IOException {
        byte[] aBuffer = new byte[theBytes];
        int i = 0;
        while (i < theBytes) {
            aBuffer[i] = (byte)(theValue & 0xFFL);
            theValue >>= 8;
            ++i;
        }
        this.write(aBuffer);
    }

    public BufferedOutput write(SAP_BOOL v) throws IOException {
        this.writeType(BufferedIO.TyBool);
        long aValue = v.getValue() ? 1L : 0L;
        this.writeIntegral(aValue, 1);
        return this;
    }

    public BufferedOutput write(SAP_UC v) throws IOException {
        this.writeType(BufferedIO.TyChar);
        long aValue = v.getValue();
        this.writeIntegral(aValue, 1);
        return this;
    }

    public BufferedOutput write(SAP_SHORT v) throws IOException {
        this.writeType(BufferedIO.TyShort);
        long aValue = v.getValue();
        this.writeIntegral(aValue, 2);
        return this;
    }

    public BufferedOutput write(SAP_USHORT v) throws IOException {
        this.writeType(BufferedIO.TyUShort);
        long aValue = v.getValue();
        this.writeIntegral(aValue, 2);
        return this;
    }

    public BufferedOutput write(SAP_INT v) throws IOException {
        this.writeType(BufferedIO.TyInt);
        long aValue = v.getValue();
        this.writeIntegral(aValue, 4);
        return this;
    }

    public BufferedOutput write(SAP_UINT v) throws IOException {
        this.writeType(BufferedIO.TyUInt);
        long aValue = v.getValue();
        this.writeIntegral(aValue, 4);
        return this;
    }

    public BufferedOutput write(SAP_LLONG v) throws IOException {
        this.writeType(BufferedIO.TyLLong);
        long aValue = v.getValue();
        this.writeIntegral(aValue, 8);
        return this;
    }

    public BufferedOutput write(SAP_DOUBLE v) throws IOException {
        this.writeType(BufferedIO.TyDouble);
        long aValue = Double.doubleToLongBits(v.getValue());
        this.writeIntegral(aValue, 8);
        return this;
    }

    public BufferedOutput write(SAP_STRING v) throws IOException {
        this.writeType(BufferedIO.TyString);
        byte[] aBuffer = v.getValue().getBytes();
        this.writeIntegral(aBuffer.length, 4);
        this.write(aBuffer);
        return this;
    }

    public BufferedOutput writeM(SAP_STRING v) throws IOException {
        byte[] aBuffer = v.getValue().getBytes();
        this.write(aBuffer);
        return this;
    }

    public BufferedOutput writeMLen(SAP_STRING v) throws IOException {
        byte[] aBuffer = v.getValue().getBytes();
        this.writeIntegral(aBuffer.length, 4);
        return this;
    }

    public BufferedOutput writeStream(OutputStream v) throws IOException {
        return this;
    }

    public void flush() throws IOException {
        this.itsStream.flush();
    }

    public void end() throws IOException {
        this.writeType(BufferedIO.TyEOF);
    }

    public long getBytesWritten() {
        return this.itsBytesWritten;
    }

    public void resetCounter() {
        this.itsBytesWritten = 0L;
    }

    public void close() throws IOException {
        this.itsStream.close();
    }
}

