/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.net;

import com.sapportals.trex.core.net.BufferedIO;
import com.sapportals.trex.core.net.BufferedOutput;
import com.sapportals.trex.core.net.SAP_BOOL;
import com.sapportals.trex.core.net.SAP_DOUBLE;
import com.sapportals.trex.core.net.SAP_INT;
import com.sapportals.trex.core.net.SAP_LLONG;
import com.sapportals.trex.core.net.SAP_SHORT;
import com.sapportals.trex.core.net.SAP_STRING;
import com.sapportals.trex.core.net.SAP_UC;
import com.sapportals.trex.core.net.SAP_UINT;
import com.sapportals.trex.core.net.SAP_USHORT;
import com.sapportals.trex.core.net.StreamTypeException;
import com.sapportals.trex.core.net.UIntValueException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Socket;

public class BufferedInput {
    Socket itsSocket = null;
    BufferedInputStream itsStream = null;
    long itsBytesRead = 0L;
    BufferedOutput itsTiedStream = null;

    public BufferedInput(Socket theSocket) throws IOException {
        this.itsSocket = theSocket;
        this.itsStream = new BufferedInputStream(this.itsSocket.getInputStream());
        this.resetCounter();
    }

    private byte[] read(int theLength) throws IOException {
        if (this.itsTiedStream != null) {
            this.itsTiedStream.flush();
        }
        byte[] aBuffer = new byte[theLength];
        int aByteCounter = 0;
        while (aByteCounter < theLength) {
            int aLen = this.itsStream.read(aBuffer, aByteCounter, theLength - aByteCounter);
            if (aLen < 0) {
                throw new ProtocolException();
            }
            aByteCounter += aLen;
        }
        this.itsBytesRead += (long)aByteCounter;
        return aBuffer;
    }

    private int getType() throws IOException {
        byte[] aBuffer = this.read(1);
        return aBuffer[0];
    }

    private void checkType(int theType) throws IOException, StreamTypeException {
        int aType = this.getType();
        if (aType != theType) {
            throw new StreamTypeException(theType, aType);
        }
    }

    /*
     * WARNING - void declaration
     */
    void readToEOF() throws IOException, StreamTypeException {
        int aType;
        while ((aType = this.getType()) != BufferedIO.TyEOF) {
            byte[] aBuffer;
            void var2_2;
            if (var2_2 == BufferedIO.TyBool) {
                aBuffer = this.read(1);
                continue;
            }
            if (var2_2 == BufferedIO.TyChar) {
                aBuffer = this.read(1);
                continue;
            }
            if (var2_2 == BufferedIO.TyShort) {
                aBuffer = this.read(2);
                continue;
            }
            if (var2_2 == BufferedIO.TyUShort) {
                aBuffer = this.read(2);
                continue;
            }
            if (var2_2 == BufferedIO.TyInt) {
                aBuffer = this.read(4);
                continue;
            }
            if (var2_2 == BufferedIO.TyUInt) {
                aBuffer = this.read(4);
                continue;
            }
            if (var2_2 == BufferedIO.TyLLong) {
                aBuffer = this.read(8);
                continue;
            }
            if (var2_2 == BufferedIO.TyDouble) {
                aBuffer = this.read(8);
                continue;
            }
            if (var2_2 == BufferedIO.TyString) {
                long aStrLen = this.readIntegral(4);
                aBuffer = this.read((int)aStrLen);
                continue;
            }
            if (var2_2 == BufferedIO.TyStream || var2_2 == BufferedIO.TyEOF || var2_2 != BufferedIO.TyBOF) continue;
            throw new StreamTypeException(BufferedIO.TyEOF, BufferedIO.TyBOF);
        }
    }

    long readIntegral(int theBytes) throws IOException {
        byte[] aBuffer = this.read(theBytes);
        long aValue = 0L;
        int i = theBytes - 1;
        while (i >= 0) {
            aValue <<= 8;
            aValue += aBuffer[i] >= 0 ? (long)aBuffer[i] : (long)(256 + aBuffer[i]);
            --i;
        }
        return aValue;
    }

    public BufferedInput read(SAP_BOOL v) throws IOException, StreamTypeException {
        this.checkType(BufferedIO.TyBool);
        boolean aValue = this.itsStream.read() != 0;
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_UC v) throws IOException, StreamTypeException, UIntValueException {
        this.checkType(BufferedIO.TyChar);
        char aValue = (char)this.readIntegral(1);
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_SHORT v) throws IOException, StreamTypeException {
        this.checkType(BufferedIO.TyShort);
        short aValue = (short)this.readIntegral(2);
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_USHORT v) throws IOException, StreamTypeException, UIntValueException {
        this.checkType(BufferedIO.TyUShort);
        int aValue = (int)this.readIntegral(2);
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_INT v) throws IOException, StreamTypeException {
        this.checkType(BufferedIO.TyInt);
        int aValue = (int)this.readIntegral(4);
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_UINT v) throws IOException, StreamTypeException, UIntValueException {
        this.checkType(BufferedIO.TyUInt);
        long aValue = this.readIntegral(4);
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_LLONG v) throws IOException, StreamTypeException {
        this.checkType(BufferedIO.TyLLong);
        long aValue = this.readIntegral(8);
        v.setValue(aValue);
        return this;
    }

    public BufferedInput read(SAP_DOUBLE v) throws IOException, StreamTypeException {
        this.checkType(BufferedIO.TyDouble);
        long aValue = this.readIntegral(8);
        double d = Double.longBitsToDouble(aValue);
        v.setValue(d);
        return this;
    }

    public BufferedInput read(SAP_STRING v) throws IOException, StreamTypeException {
        this.checkType(BufferedIO.TyString);
        int len = (int)this.readIntegral(4);
        byte[] bytes = this.read(len);
        v.setValue(new String(bytes));
        return this;
    }

    public BufferedInput readStream(OutputStream v) throws IOException, StreamTypeException {
        return this;
    }

    public void tie(BufferedOutput theOutputStream) {
        this.itsTiedStream = theOutputStream;
    }

    public long getBytesRead() {
        return this.itsBytesRead;
    }

    public void resetCounter() {
        this.itsBytesRead = 0L;
    }

    public void close() throws IOException {
        this.itsStream.close();
        this.itsTiedStream = null;
    }

    public static void main(String[] args) {
        try {
            long l = 65535L;
            short s = (short)l;
            System.out.println(l);
            System.out.println(s);
            int b = -1;
            System.out.println(b);
            l = b;
            System.out.println(l);
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

