/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.CompleteTerm;
import com.sapportals.trex.core.CompleteTerms;
import com.sapportals.trex.core.RelatedTerm;
import com.sapportals.trex.core.RelatedTerms;
import com.sapportals.trex.core.TextMiningManager;
import com.sapportals.trex.core.TrexFactory;

public class ExampleTopicMaps {
    private static final String MY_SEARCH_INDEX = "DPA_GERMAN";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "pgwdf117";
    private static final int HTTP_PORT = 8353;
    private static final String HTTP_FILE = "/TRexHttpServer/TRexHttpServer.dll?";

    public static void main(String[] args) throws TrexException {
        TextMiningManager mining = TrexFactory.getTextMiningManager();
        mining.addIndexId(MY_SEARCH_INDEX, "DRFUZZY", "", MODE, HTTP_HOST, 8353, HTTP_FILE);
        String termName = "woman";
        mining.setTermName(termName);
        CompleteTerms termIds = mining.getTermIds();
        System.out.println("Last error <Errorcode: " + termIds.getErrorCode().getCode() + ", Message: '" + termIds.getErrorCode().getMsg() + "'>");
        if (termIds == null || termIds.size() == 0) {
            System.out.println("No term ids found for '" + termName + "'");
            return;
        }
        System.out.println("Number of termIds: " + termIds.size());
        CompleteTerm completeTerm = termIds.getFirstTerm();
        while (completeTerm != null) {
            System.out.println("ID:                " + completeTerm.getTermId());
            System.out.println("  Term Name:       " + completeTerm.getTermName());
            System.out.println("  Term Description:" + completeTerm.getTermDescription());
            completeTerm = termIds.getNextTerm();
        }
        System.out.println();
        mining = TrexFactory.getTextMiningManager();
        mining.addIndexId(MY_SEARCH_INDEX, "DRFUZZY", "", MODE, HTTP_HOST, 8353, HTTP_FILE);
        completeTerm = termIds.getFirstTerm();
        if (completeTerm != null) {
            System.out.println("Thesaurus terms for the first Term ID: " + completeTerm.getTermId());
            mining.setTermId(completeTerm.getTermId(), 1.0f);
            mining.setMaxResults(50);
            RelatedTerms result = mining.getThesaurusTerms();
            RelatedTerm entry = result.getFirstEntry();
            System.out.println("Lasterror <Errorcode: " + result.getErrorCode().getCode() + " ,Message: '" + result.getErrorCode().getMsg() + "'>");
            while (entry != null) {
                System.out.println("ID:           " + entry.getId());
                System.out.println("  Term Name:  " + entry.getTermName());
                System.out.println("  Relation:   " + entry.getRelationName());
                System.out.println("  Role:       " + entry.getRoleName());
                System.out.println("  Weight:     " + entry.getRank());
                entry = result.getNextEntry();
            }
        }
    }
}

