/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchDocument;
import com.sapportals.trex.core.SimilarSearchResult;
import com.sapportals.trex.core.TextMiningManager;
import com.sapportals.trex.core.TrexFactory;

public class ExampleSimilarDocuments {
    private static final String MY_SEARCH_INDEX = "DPA_GERMAN";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "p67575";
    private static final int HTTP_PORT = 8354;
    private static final String HTTP_FILE = "/TrexHttpServer/TrexHttpServer.dll?";

    public static void main(String[] args) throws TrexException {
        TextMiningManager mining = TrexFactory.getTextMiningManager();
        mining.addIndexId(MY_SEARCH_INDEX, "DRFUZZY", "", MODE, HTTP_HOST, 8354, HTTP_FILE);
        mining.setMaxResults(5);
        mining.addRequestedAttribute("folder");
        mining.addRequestedAttribute("size");
        mining.addRequestedAttribute("title");
        mining.setRequestFlag(TextMiningManager.TREX_MINING_REQUEST_FEATURES, true);
        mining.setRequestFlag(TextMiningManager.TREX_MINING_REQUEST_CONTENTSNIPPETS, true);
        mining.setRequestFlag(TextMiningManager.TREX_MINING_REQUEST_TITLESNIPPET, true);
        mining.addHighlightAttribute("title");
        SearchDocument indoc = new SearchDocument();
        indoc.setIndexDocumentId("/DPA/Schlaglichter/Spotnews/hfk105_2_2406_0624182233.htm");
        mining.addSearchDocument(indoc);
        SimilarSearchResult result = mining.searchSimilarDocuments();
        System.out.println("Errorcode: " + result.getErrorCode().getCode());
        System.out.println("Errortext: " + result.getErrorCode().getMsg());
        System.out.println("Number of Hits: " + result.size());
        System.out.println("Number of all hits in Index: " + result.getNoOfAllHitsInIndex());
        System.out.println("Index size: " + result.getIndexSize());
        ResultDocument doc = result.getFirstResultDocument();
        while (doc != null) {
            System.out.print("Document Status: ");
            System.out.print(doc.getDocumentStatus());
            System.out.print(" Document Key: " + doc.getDocumentKey());
            System.out.print(" Rank value: ");
            System.out.println(doc.getRankValue());
            DocAttribute attr = doc.getFirstDocumentAttribute();
            while (attr != null) {
                System.out.println("    attribute " + attr.getAttributeName() + " " + attr.getValue1());
                attr = doc.getNextDocumentAttribute();
            }
            doc = result.getNextResultDocument();
        }
    }
}

