/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.ResultElement;
import com.sapportals.trex.core.TextMiningManager;
import com.sapportals.trex.core.TextMiningResult;
import com.sapportals.trex.core.TextMiningResultContainer;
import com.sapportals.trex.core.TrexFactory;

public class ExampleSimilarClasses {
    public static final String MY_SEARCH_INDEX = "DPA_GERMAN";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "pgwdf117";
    private static final int HTTP_PORT = 8353;
    private static final String HTTP_FILE = "/TrexHttpServer/TrexHttpServer.dll?";

    public static void main(String[] args) throws TrexException {
        try {
            TextMiningManager mining = TrexFactory.getTextMiningManager();
            mining.addIndexId(MY_SEARCH_INDEX, "DRFUZZY", "", MODE, HTTP_HOST, 8353, HTTP_FILE);
            mining.setMaxResults(5);
            mining.addSearchClass("/DPA/Wetter");
            mining.setClassifyAttribute("FOLDER");
            TextMiningResult result = mining.searchSimilarClasses();
            if (result == null) {
                System.err.println("Result null");
                return;
            }
            TextMiningResultContainer container = result.getFirstContainer();
            if (container == null) {
                System.err.println("Container null");
                return;
            }
            System.out.println("Errorcode: " + result.getErrorCode().getCode());
            System.out.println("Errortext: " + result.getErrorCode().getMsg());
            ResultElement element = container.getFirstElement();
            int i = 0;
            while (i < container.size()) {
                System.out.println("Similar Class: " + element.getName());
                System.out.print(" RankValue: ");
                System.out.println(element.getRankValue());
                element = container.getNextElement();
                ++i;
            }
        }
        catch (TrexException e) {
            System.err.println(e.getMessage());
        }
    }
}

