/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchManager;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.TrexFactory;

public class ExampleSearchGoogle {
    private static final String SEARCH_ENGINE = "google";

    public static void main(String[] args) throws TrexException {
        SearchManager search = TrexFactory.getSearchManager();
        search.addSearchEngine(SEARCH_ENGINE);
        search.setResultFromTo(1, 5);
        QueryEntry entry = new QueryEntry();
        entry.setValue("usa", "", "EQ");
        entry.setRowType("TERM");
        entry.setTermAction((byte)69);
        search.addQueryEntry(entry);
        SearchResult result = search.search();
        System.out.println("Errorcode: " + result.getLastError().getCode() + " " + result.getLastError().getMsg());
        ResultDocument doc = result.getFirstResultDocument();
        int i = 0;
        while (i < result.size()) {
            System.out.print("Document Status: ");
            System.out.print(doc.getDocumentStatus());
            System.out.print(" Document Key: " + doc.getDocumentKey());
            System.out.print(" Rank value: ");
            System.out.println(doc.getRankValue());
            DocAttribute attr = doc.getFirstDocumentAttribute();
            while (attr != null) {
                System.out.println("    attribute " + attr.getAttributeName() + " " + attr.getValue1());
                attr = doc.getNextDocumentAttribute();
            }
            doc = result.getNextResultDocument();
            ++i;
        }
    }
}

