/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AttributeDistributionOverview;
import com.sapportals.trex.core.AttributeDistributionRange;
import com.sapportals.trex.core.AttributeDistributionValue;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchManager;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.TrexFactory;

public class ExampleSearch {
    private static final String MY_SEARCH_INDEX = "DPA_GERMAN";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "p77894";
    private static final int HTTP_PORT = 8353;
    private static final String HTTP_FILE = "/TrexHttpServer/TrexHttpServerd.dll?";

    public static void main(String[] args) throws TrexException {
        DocAttribute attr;
        SearchManager search = TrexFactory.getSearchManager();
        search.addIndexId(MY_SEARCH_INDEX, "DE");
        search.setResultFromTo(1, 5);
        search.setRequestFlag(SearchManager.TREX_SEARCH_REQUEST_ADMINISTRATEDLINKS, true);
        search.addRequestedAttribute("folder");
        search.addRequestedAttribute("docname");
        search.addRequestedAttribute("size");
        search.addRequestedAttribute("mbsize");
        search.addRequestedAttribute("createdate");
        search.addRequestedAttribute("createtime");
        QueryEntry entry = new QueryEntry();
        entry.setValue("*", "", "EQ");
        entry.setRowType("TERM");
        entry.setTermAction((byte)69);
        search.addQueryEntry(entry);
        SearchResult result = search.search();
        System.out.println("Errorcode: " + result.getLastError().getCode() + " " + result.getLastError().getMsg());
        System.out.println("Number of Hits: " + result.size());
        System.out.println("Number of all hits in Index: " + result.getNoOfAllHitsInIndex());
        System.out.println("Index size: " + result.getIndexSize());
        System.out.println("Result Documents:");
        ResultDocument doc = result.getFirstResultDocument();
        int i = 0;
        while (i < result.size()) {
            System.out.println("Document Status: " + doc.getDocumentStatus());
            System.out.println(" Document Key: " + doc.getDocumentKey());
            System.out.println(" Rank value: " + doc.getRankValue());
            attr = doc.getFirstDocumentAttribute();
            while (attr != null) {
                System.out.print("    attribute " + attr.getAttributeName());
                System.out.print(" " + attr.getValue1() + " ");
                System.out.println(attr.getAttributeType());
                attr = doc.getNextDocumentAttribute();
            }
            doc = result.getNextResultDocument();
            ++i;
        }
        System.out.println("Administered Links:");
        doc = result.getFirstAdministeredResultDocument();
        while (doc != null) {
            System.out.println("  Document Key: " + doc.getDocumentKey());
            attr = doc.getFirstDocumentAttribute();
            while (attr != null) {
                System.out.print("    attribute " + attr.getAttributeName());
                System.out.print(" " + attr.getValue1() + " ");
                System.out.println(attr.getAttributeType());
                attr = doc.getNextDocumentAttribute();
            }
            doc = result.getNextAdministeredResultDocument();
        }
        System.out.println("Attribute Distribution Values:");
        AttributeDistributionValue adv = result.getFirstAttributeDistributionValue();
        while (adv != null) {
            System.out.println("  Value: " + adv.getValue());
            System.out.println("  Hits: " + String.valueOf(adv.getNumberOfHits()));
            adv = result.getNextAttributeDistributionValue();
        }
        System.out.println("Attribute Distribution Ranges:");
        AttributeDistributionRange adr = result.getFirstAttributeDistributionRange();
        while (adr != null) {
            System.out.print("  From: " + adr.getGroupNameFrom());
            System.out.println("  To:   " + adr.getGroupNameTo());
            System.out.println("  DistinctValues: " + String.valueOf(adr.getNumberOfDistinctValues()));
            System.out.println("  Docs: " + String.valueOf(adr.getNumberOfDocumentsInThisRange()));
            adr = result.getNextAttributeDistributionRange();
        }
        System.out.println("Attribute Distribution Overview:");
        AttributeDistributionOverview ado = result.getFirstAttributeDistributionOverview();
        while (ado != null) {
            System.out.println("  Attribute name: " + ado.getAttributeName());
            System.out.println("  Discrimination value:   " + ado.getDiscriminationValue());
            System.out.println("  DistinctValues: " + String.valueOf(ado.getNumberOfDistinctValues()));
            System.out.println("  Docs: " + String.valueOf(ado.getNumberOfDocumentsWithThisAttribute()));
            ado = result.getNextAttributeDistributionOverview();
        }
    }
}

