/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.CreateIndexManager;
import com.sapportals.trex.core.IndexDocument;
import com.sapportals.trex.core.IndexManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.admin.AdminManager;
import com.sapportals.trex.core.queueserver.DocStateReturn;
import com.sapportals.trex.core.queueserver.GetEntriesReturn;
import com.sapportals.trex.core.queueserver.QueueDocReturn;
import com.sapportals.trex.core.queueserver.QueueEntryChoice;
import com.sapportals.trex.core.queueserver.QueueList;
import com.sapportals.trex.core.queueserver.QueueParameter;
import com.sapportals.trex.core.queueserver.QueueParameters;
import com.sapportals.trex.core.queueserver.QueueReturn;
import com.sapportals.trex.core.queueserver.QueueServerManager;
import com.sapportals.trex.core.queueserver.QueueStateList;
import com.sapportals.trex.core.queueserver.QueueStateReturn;
import java.util.ArrayList;

public class ExampleQueueServer {
    public static void getQueues() throws TrexException {
        QueueStateList l = null;
        QueueServerManager qs = TrexFactory.getQueueServerManager();
        qs.addIndexId("news");
        qs.addIndexId("dpa");
        l = qs.getQueuesByIndexId();
        int i = 0;
        while (i < l.countQueueStateReturns()) {
            QueueStateReturn r = i == 0 ? l.getFirstQStateReturn() : l.getNextQStateReturn();
            System.out.println("=============================================");
            System.out.println("Index ID: " + r.getIndexId());
            System.out.println("Queue State: " + r.getQueueState());
            System.out.println("TimeStamp: " + r.getSince());
            System.out.println("Error Code: " + r.getTrexReturn().getCode());
            System.out.println("Error Message: " + r.getTrexReturn().getMsg());
            int j = 0;
            while (j < 7) {
                DocStateReturn dsr = j == 0 ? r.getFirstDocStateReturn() : r.getNextDocStateReturn();
                if (dsr != null) {
                    System.out.println("DocState: " + dsr.getDocState());
                    System.out.println("DocSum: " + dsr.getDocSum());
                }
                ++j;
            }
            ++i;
        }
        System.out.println("=============================================");
    }

    public static void deleteEntries() throws TrexException {
        QueueServerManager qs = TrexFactory.getQueueServerManager();
        qs.setIndexId("EllyIndex3");
        QueueEntryChoice q = new QueueEntryChoice();
        ArrayList l = new ArrayList();
        q.setDocumentState(6);
        qs.setQueueEntryChoice(q);
        QueueList ql = qs.deleteEntries();
        System.out.println("=============================================");
        System.out.println("Index ID: " + ql.getIndexId());
        System.out.println("" + ql.getFirstQueueReturn().getId());
        System.out.println("" + ql.getFirstQueueReturn().getTrexReturn().getCode());
        System.out.println("" + ql.getFirstQueueReturn().getTrexReturn().getMsg());
    }

    public static void getParameters() throws TrexException {
        QueueServerManager qs = TrexFactory.getQueueServerManager();
        qs.addIndexId("ak_clear");
        QueueParameters qps = qs.getQueueParameter();
        QueueParameter qp = null;
        int i = 0;
        while (i < qps.countParameters()) {
            qp = i == 0 ? qps.getFirstParameter() : qps.getNextParameter();
            System.out.println("Index ID: " + qp.getIndexId());
            System.out.println("Error Code: " + qp.getTrexReturn().getCode());
            System.out.println("Error Message: " + qp.getTrexReturn().getMsg());
            System.out.println("Trace Level: " + qp.getTraceLevel());
            System.out.println("Index Bulk Size: " + qp.getIndexBulkSize());
            System.out.println("Optimize Bulk Size: " + qp.getOptimizeBulkSize());
            System.out.println("Max Retry Count: " + qp.getMaxRetryCount());
            System.out.println("Schedule Type: " + qp.getScheduleType());
            System.out.println("Schedule Time: " + qp.getScheduleTime());
            System.out.println("Schedule Max Docs: " + qp.getScheduleMaxDocs());
            System.out.println("MergeTime: " + qp.getMergeTime());
            System.out.println("ReplicationTime: " + qp.getReplicationTime());
            System.out.println("ReplicateAfterOptimize: " + (qp.getReplicateAfterOptimize() ? "YES" : "NO"));
            ++i;
        }
    }

    public static void setParameters() throws TrexException {
        QueueServerManager qs = TrexFactory.getQueueServerManager();
        QueueParameter qp = new QueueParameter();
        qp.setIndexId("ak_clear");
        qp.setReplicateAfterOptimize(true);
        qs.setQueueParameter(qp);
    }

    public static void getEntries() throws TrexException {
        QueueServerManager qs = TrexFactory.getQueueServerManager();
        qs.setIndexId("cnn");
        QueueEntryChoice q = new QueueEntryChoice();
        q.addDocumentKey("");
        qs.setQueueEntryChoice(q);
        GetEntriesReturn g = qs.getEntries();
        System.out.println("============================================");
        System.out.println("Index ID: " + g.getIndexId());
        System.out.println("No of Docs: " + g.getNoOfDocs());
        QueueDocReturn qd = g.getFirstQDocReturn();
        int i = 0;
        while (i < g.countQDocReturn()) {
            qd = i == 0 ? g.getFirstQDocReturn() : g.getNextQDocReturn();
            System.out.println("Doc ID: " + qd.getDocId());
            System.out.println("Doc Action: " + qd.getQDocAction());
            System.out.println("Doc State: " + qd.getQDocState());
            System.out.println("Doc RetryCount: " + qd.getRetryCount());
            System.out.println("Return Code: " + qd.getTrexReturn().getCode());
            ++i;
        }
        System.out.println("============================================");
    }

    public static void flush() throws TrexException {
        QueueServerManager q = TrexFactory.getQueueServerManager();
        q.addIndexId("Barbara1", "DRFUZZY", "http", "us0060", 8080, "/TREX");
        QueueList r = q.flushQueues();
        System.out.println("=================================================");
        System.out.println("Index ID: " + r.getFirstQueueReturn().getId());
        System.out.println("Return Code: " + r.getFirstQueueReturn().getTrexReturn().getCode());
        System.out.println("Return Msg: " + r.getFirstQueueReturn().getTrexReturn().getMsg());
        System.out.println("=================================================");
    }

    public static void suspend() throws TrexException {
        QueueServerManager q = TrexFactory.getQueueServerManager();
        q.addIndexId("");
        q.addIndexId("XXX-300");
        q.addIndexId("XXX-400");
        QueueList r = q.suspendQueues();
        System.out.println("=================================================");
        System.out.println("Index ID: " + r.getFirstQueueReturn().getId());
        System.out.println("Return Code: " + r.getFirstQueueReturn().getTrexReturn().getCode());
        System.out.println("Return Msg: " + r.getFirstQueueReturn().getTrexReturn().getMsg());
        System.out.println("=================================================");
        QueueReturn qr = r.getNextQueueReturn();
        System.out.println("Index ID: " + qr.getId());
        System.out.println("Return Code: " + qr.getTrexReturn().getCode());
        System.out.println("Return Msg: " + qr.getTrexReturn().getMsg());
        System.out.println("=================================================");
        qr = r.getNextQueueReturn();
        System.out.println("Index ID: " + qr.getId());
        System.out.println("Return Code: " + qr.getTrexReturn().getCode());
        System.out.println("Return Msg: " + qr.getTrexReturn().getMsg());
        System.out.println("=================================================");
    }

    public static void activate() throws TrexException {
        QueueServerManager q = TrexFactory.getQueueServerManager();
        q.addIndexId("XXX-200");
        q.addIndexId("XXX-300");
        q.addIndexId("XXX-400");
        QueueList r = q.activateQueues();
        System.out.println("=================================================");
        System.out.println("Index ID: " + r.getFirstQueueReturn().getId());
        System.out.println("Return Code: " + r.getFirstQueueReturn().getTrexReturn().getCode());
        System.out.println("Return Msg: " + r.getFirstQueueReturn().getTrexReturn().getMsg());
        System.out.println("=================================================");
        QueueReturn qr = r.getNextQueueReturn();
        System.out.println("Index ID: " + qr.getId());
        System.out.println("Return Code: " + qr.getTrexReturn().getCode());
        System.out.println("Return Msg: " + qr.getTrexReturn().getMsg());
        System.out.println("=================================================");
        qr = r.getNextQueueReturn();
        System.out.println("Index ID: " + qr.getId());
        System.out.println("Return Code: " + qr.getTrexReturn().getCode());
        System.out.println("Return Msg: " + qr.getTrexReturn().getMsg());
        System.out.println("=================================================");
    }

    public static void indexing() throws TrexException {
        IndexManager i = TrexFactory.getIndexManager();
        i.setIndexId("CALC", "http", "p54529.wdf.sap-ag.de", 8353, "/trexhttpserver/trexhttpserver.dll");
        IndexDocument d1 = new IndexDocument();
        d1.setDocumentLanguage("DE");
        d1.setDocumentKey("http://www.spiegel.de/politik/deutschland/0,1518,197343,00.html");
        d1.setUrl("http://www.spiegel.de/politik/deutschland/0,1518,197343,00.html");
        d1.setDocumentAction((byte)73);
        i.addDocument(d1);
        IndexDocument d2 = new IndexDocument();
        d2.setDocumentLanguage("DE");
        d2.setDocumentKey("http://www.spiegel.de/wirtschaft/0,1518,197273,00.html");
        d2.setUrl("http://www.spiegel.de/wirtschaft/0,1518,197273,00.html");
        d2.setDocumentAction((byte)73);
        IndexDocument d3 = new IndexDocument();
        d3.setDocumentAction((byte)73);
        d3.setDocumentKey("http://www.spiegel.de/panorama/0,1518,197327,00.html");
        d3.setUrl("http://www.spiegel.de/panorama/0,1518,197327,00.html");
        d3.setDocumentLanguage("DE");
        IndexDocument d4 = new IndexDocument();
        d4.setDocumentAction((byte)73);
        d4.setDocumentKey("http://www.spiegel.de/auto/aktuell/0,1518,197297,00.html");
        d4.setUrl("http://www.spiegel.de/auto/aktuell/0,1518,197297,00.html");
        d4.setDocumentLanguage("DE");
        IndexDocument d5 = new IndexDocument();
        d5.setDocumentAction((byte)73);
        d5.setDocumentKey("http://www.spiegel.de/auto/aktuell/0,1518,197297,00.html");
        d5.setUrl("http://www.spiegel.de/auto/aktuell/0,1518,197297,00.html");
        d5.setDocumentLanguage("DE");
        i.addDocument(d2);
        i.addDocument(d3);
        i.addDocument(d4);
        i.addDocument(d5);
        i.index();
        i.optimize();
    }

    public static void deleteIndex() throws TrexException {
        AdminManager adm = TrexFactory.getAdminManager();
        adm.setIndexId("abcdef");
        adm.deleteIndex();
    }

    public static void resetFailed() throws TrexException {
        QueueServerManager qu = TrexFactory.getQueueServerManager();
        qu.setQueueServerLocation("us0060", 8352);
        qu.addIndexId("1", "DRFUZZY", "http", "us0060", 8080, "/TREX");
        QueueList ql = qu.resetFailedEntriesByQueueServerLocation(0);
        int i = 0;
        while (i < ql.countQueueReturns()) {
            if (i == 0) {
                System.out.println("Index ID: " + ql.getFirstQueueReturn().getId());
            } else {
                System.out.println("Index ID: " + ql.getNextQueueReturn().getId());
            }
            ++i;
        }
    }

    public static void deindexing() throws TrexException {
        IndexManager i = TrexFactory.getIndexManager();
        i.setIndexId("YYY-100", "http", "p54529", 80, "/TREX/TRexHTTPServerD.dll?");
        IndexDocument d1 = new IndexDocument();
        d1.setDocumentKey("http://www.spiegel.de/wirtschaft/0,1518,145335,00.html");
        d1.setUrl("http://www.spiegel.de/wirtschaft/0,1518,145509,00.html");
        d1.setDocumentAction((byte)68);
        IndexDocument d2 = new IndexDocument();
        d2.setDocumentAction((byte)68);
        d2.setDocumentKey("http://www.spiegel.de/wirtschaft/0,1518,145509,00.html");
        d2.setUrl("http://www.spiegel.de/wirtschaft/0,1518,145509,00.html");
        i.addDocument(d1);
        i.addDocument(d2);
        i.index();
    }

    public static void createIndex() throws TrexException {
        CreateIndexManager c = TrexFactory.getCreateIndexManager();
        c.setIndexId("nagut1", "http", "us0060", 8080, "/TREX");
        c.setIndexServerLocation("us0060", 8351);
        c.setQServerLocation("us0060", 8352);
        c.useQueueServer(true);
        c.setSearchEngine("DRFUZZY");
        c.setMiningFlag(true);
        c.createIndex();
        String index = c.getIndexId();
        System.out.println("Index Id: " + index);
    }

    public static void main(String[] args) throws Exception {
        ExampleQueueServer.setParameters();
        ExampleQueueServer.getParameters();
    }
}

