/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AttributeDistribution;
import com.sapportals.trex.core.AttributeDistributionOverview;
import com.sapportals.trex.core.AttributeDistributionRange;
import com.sapportals.trex.core.AttributeDistributionValue;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchManager;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.TrexFactory;

public class ExampleGuidedNav {
    private static final String MY_SEARCH_INDEX = "dpa_german";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "p78121";
    private static final int HTTP_PORT = 8353;
    private static final String HTTP_FILE = "/TrexHttpServer/TrexHttpServerD.dll";

    public static void main(String[] args) throws TrexException {
        int noOfDistributions;
        SearchManager search = TrexFactory.getSearchManager();
        search.addIndexId(MY_SEARCH_INDEX, "DRFUZZY", "", MODE, HTTP_HOST, 8353, HTTP_FILE);
        search.setResultFromTo(1, 10000000);
        search.addRequestedAttribute("size");
        search.addRequestedAttribute("folder");
        QueryEntry entry = new QueryEntry();
        entry.setValue("a*", "", "EQ");
        entry.setRowType("TERM");
        entry.setTermAction((byte)69);
        search.addQueryEntry(entry);
        search.setRequestedSearchResults(SearchManager.ATTRIBUTE_DISTRIBUTION_REQUESTED);
        SearchResult result = search.search();
        System.out.println("Errorcode: " + result.getLastError().getCode() + " " + result.getLastError().getMsg());
        System.out.println("Number of Hits: " + result.size());
        System.out.println("Number of all hits in Index: " + result.getNoOfAllHitsInIndex());
        System.out.println("Index size: " + result.getIndexSize());
        ResultDocument doc = result.getFirstResultDocument();
        int i = 0;
        while (i < result.size()) {
            System.out.println("Document Status: " + doc.getDocumentStatus());
            System.out.println(" Document Key: " + doc.getDocumentKey());
            System.out.println(" Rank value: " + doc.getRankValue());
            DocAttribute attr = doc.getFirstDocumentAttribute();
            while (attr != null) {
                System.out.println("    attribute " + attr.getAttributeName() + " " + attr.getValue1() + " " + attr.getAttributeType());
                attr = doc.getNextDocumentAttribute();
            }
            doc = result.getNextResultDocument();
            ++i;
        }
        int i2 = 1;
        if (result.countAttributeDistributionOverviews() > 0) {
            AttributeDistributionOverview ado = result.getFirstAttributeDistributionOverview();
            System.out.println("--- START ---- Attribute Distribution Overview --------------");
            System.out.println("count: " + result.countAttributeDistributionOverviews());
            while (ado != null) {
                System.out.println(i2 + ".AttrName= " + ado.getAttributeName());
                System.out.println("  discrimination value= " + ado.getDiscriminationValue());
                System.out.println("  number of distinct values= " + ado.getNumberOfDistinctValues());
                System.out.println("  number of documents with this attribute= " + ado.getNumberOfDocumentsWithThisAttribute());
                ado = result.getNextAttributeDistributionOverview();
                ++i2;
            }
            System.out.println("--- END ---- Attribute Distribution Overview --------------");
        }
        if ((noOfDistributions = result.countAttributeDistributions()) > 0) {
            AttributeDistribution ad = result.getFirstAttributeDistribution();
            do {
                System.out.println("----- attribute = " + ad.getAttributeName());
                if (ad.countAttributeDistributionValues() > 0) {
                    System.out.println("--- START ---- Attribute Distribution Value --------------");
                    System.out.println("count: " + ad.countAttributeDistributionValues());
                    AttributeDistributionValue adv = ad.getFirstAttributeDistributionValue();
                    i2 = 1;
                    int sum = 0;
                    while (adv != null) {
                        int noOfHits = adv.getNumberOfHits();
                        System.out.println(i2 + ". Value= " + adv.getValue() + " occurs : " + adv.getNumberOfHits() + " times");
                        adv = ad.getNextAttributeDistributionValue();
                        ++i2;
                        sum += noOfHits;
                    }
                    System.out.println("sum: " + sum + "--- END ---- Attribute Distribution Value --------------");
                }
                if (ad.countAttributeDistributionRanges() <= 0) continue;
                System.out.println("--- START ---- Attribute Distribution Ranges --------------");
                System.out.println("count: " + ad.countAttributeDistributionRanges());
                AttributeDistributionRange adr = ad.getFirstAttributeDistributionRange();
                i2 = 1;
                while (adr != null) {
                    System.out.println(i2 + ". Group: " + "[" + adr.getGroupNameFrom() + ", " + adr.getGroupNameTo() + "]");
                    System.out.println("  number of distinct values: " + adr.getNumberOfDistinctValues());
                    System.out.println("  number of distinct values in this range: " + adr.getNumberOfDocumentsInThisRange());
                    adr = ad.getNextAttributeDistributionRange();
                    ++i2;
                }
                System.out.println("--- END ---- Attribute Distribution Value --------------");
            } while ((ad = result.getNextAttributeDistribution()) != null);
        }
    }
}

