/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.TaxonomyManager;
import com.sapportals.trex.core.TaxonomyNode;
import com.sapportals.trex.core.TaxonomyTerm;
import com.sapportals.trex.core.TaxonomyTree;
import com.sapportals.trex.core.TrexFactory;

public class ExampleGetTaxonomy {
    private static final String MY_SEARCH_INDEX = "myindex";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "p78121";
    private static final int HTTP_PORT = 8353;
    private static final String HTTP_FILE = "/TrexHttpServer/TrexHttpServerd.dll";
    private static final String MYCATEGORY = "topics2";

    public static void main(String[] args) throws TrexException {
        TaxonomyManager taxMan = TrexFactory.getTaxonomyManager();
        taxMan.setIndexId(MY_SEARCH_INDEX, "", MODE, HTTP_HOST, 8353, HTTP_FILE);
        TaxonomyTree taxTree = taxMan.getTaxonomy(MYCATEGORY);
        int count = taxTree.countNodes();
        System.out.println("Number of Nodes: " + count);
        TaxonomyNode taxNode = taxTree.getFirstNode();
        while (taxNode != null) {
            System.out.println("------ Node ------------------");
            System.out.println("Id: " + taxNode.getId());
            System.out.println("  Name: " + taxNode.getName());
            System.out.println("  ParentId: " + taxNode.getParentId());
            System.out.println("  ParentWeight: " + taxNode.getParentWeight());
            System.out.println("  SimVal: " + taxNode.getSimVal());
            QueryEntry qe = taxNode.getFirstQueryEntry();
            while (qe != null) {
                System.out.println("    ------ Query ------------------");
                System.out.println("    AttrName: " + qe.getLocation());
                System.out.println("    Value1:   " + qe.getValue1());
                System.out.println("    Value2:   " + qe.getValue2());
                System.out.println("    FuzzySimilarity: " + qe.getFuzzySimilarity());
                System.out.println("    NearOrder:   " + qe.getNearOrder());
                System.out.println("    NearRanking: " + qe.getNearRanking());
                System.out.println("    NearWidth:   " + qe.getNearWidth());
                System.out.println("    Operator:    " + qe.getOperator());
                System.out.println("    RowType:     " + qe.getRowType());
                System.out.println("    TermWeight:  " + qe.getTermWeight());
                System.out.println("    TermAction:  " + qe.getTermAction());
                qe = taxNode.getNextQueryEntry();
            }
            TaxonomyTerm taxTerm = taxNode.getFirstTerm();
            while (taxTerm != null) {
                System.out.println("    ------ TaxTerm ------------------");
                System.out.println("    TaxName:  " + taxTerm.getAttribute());
                System.out.println("    Value1:   " + taxTerm.getValue1());
                System.out.println("    Value2:   " + taxTerm.getValue2());
                System.out.println("    Operator: " + taxTerm.getOperator());
                System.out.println("    Weight:   " + taxTerm.getWeight());
                taxTerm = taxNode.getNextTerm();
            }
            System.out.println("end Id: " + taxNode.getId());
            taxNode = taxTree.getNextNode();
        }
    }
}

