/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.ResultElement;
import com.sapportals.trex.core.SearchDocument;
import com.sapportals.trex.core.TextMiningManager;
import com.sapportals.trex.core.TextMiningResult;
import com.sapportals.trex.core.TextMiningResultContainer;
import com.sapportals.trex.core.TrexFactory;

public class ExampleDocumentFeatures {
    private static final String MY_SEARCH_INDEX = "DPA_GERMAN";
    private static final String MODE = "http";
    private static final String HTTP_HOST = "pgwdf117";
    private static final int HTTP_PORT = 8353;
    private static final String HTTP_FILE = "/TrexHttpServer/TrexHttpServer.dll?";

    public static void main(String[] args) throws TrexException {
        try {
            TextMiningManager mine = TrexFactory.getTextMiningManager();
            mine.addIndexId(MY_SEARCH_INDEX, "DRFUZZY", "", MODE, HTTP_HOST, 8353, HTTP_FILE);
            mine.setResultFromTo(1, 6);
            SearchDocument doc = new SearchDocument();
            doc.setIndexDocumentId("/DPA/Thema/Donnerstag/onl33_8_3105_0601070316.htm");
            mine.addSearchDocument(doc);
            TextMiningResult result = mine.getDocumentFeatures();
            TextMiningResultContainer container = result.getFirstContainer();
            int j = 0;
            while (j < result.size()) {
                ResultElement element = container.getFirstElement();
                while (element != null) {
                    System.out.println("Feature: " + element.getName());
                    System.out.print(" RankValue: ");
                    System.out.println(element.getRankValue());
                    element = container.getNextElement();
                }
                container = result.getNextContainer();
                ++j;
            }
        }
        catch (TrexException e) {
            System.err.println(e.getMessage());
        }
    }
}

