/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.example;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexVersion;
import com.sapportals.trex.core.CreateIndexManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.admin.AddIndex;
import com.sapportals.trex.core.admin.AdminIndex;
import com.sapportals.trex.core.admin.AdminManager;
import com.sapportals.trex.core.admin.GetPathReturn;
import com.sapportals.trex.core.admin.IndexShortDescription;
import com.sapportals.trex.core.admin.ServerIndexList;
import com.sapportals.trex.core.admin.TaxonomyInfo;
import com.sapportals.trex.core.admin.TrexSettings;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.Location;
import com.sapportals.trex.core.util.LocationList;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ExampleAdmin {
    public static void showQueueServer() throws TrexException {
        AdminManager adm = TrexFactory.getAdminManager();
        LocationList locationList = adm.showQueueServer();
    }

    public static void showIndexServer() throws TrexException {
        AdminManager adm = TrexFactory.getAdminManager();
        LocationList l = adm.showIndexServer();
        System.out.println("Index Server Host" + l.getFirstServerLocation().getHost());
        System.out.println("Index Server Port: " + l.getFirstServerLocation().getPort());
    }

    public static void showHttpServer() throws TrexException {
        AdminManager adm = TrexFactory.getAdminManager();
        ArrayList l = adm.showHttpServer();
        Iterator it = ((AbstractList)l).iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public static void getPath() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setIndexServerLocation("pgwdf123", 8351);
        admin.setTMEngineName("DRFUZZY");
        GetPathReturn gp = admin.getPath();
        System.out.println("TM Name: " + gp.getTMEngineName());
        System.out.println("BackupPath: " + gp.getTMEngineBackupPath());
        System.out.println("DataPath: " + gp.getTMEngineDataPath());
    }

    public static void getAllIndices() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setIndexServerLocation("p54529", 8351);
        ServerIndexList l = admin.getAllIndices();
        IndexShortDescription is = null;
        int i = 0;
        while (i < l.countIndexes()) {
            is = i == 0 ? l.getFirstIndexShortDescription() : l.getNextIndexShortDescription();
            System.out.println("===================================");
            System.out.println("IndexID: " + is.getIndexId());
            System.out.println("Description: " + is.getDescription());
            System.out.println("===================================");
            ++i;
        }
    }

    public static void showIndex() throws TrexException {
        AddIndex ai;
        TaxonomyInfo at = null;
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setIndexServerLocation("p78121", 31003);
        admin.setIndexId("logicLanguages", "http", "p78121", 31005, "/TRexHttpServer/TRexHttpserverd.dll");
        AdminIndex i = admin.showIndex();
        System.out.println("Index Id: " + i.getIndexId());
        System.out.println("UseQueueServerFlag: " + i.getUseQueueServerFlag());
        System.out.println("IsSearchable: " + i.getIsSearchable());
        System.out.println("IsWritable: " + i.getIsWritable());
        System.out.println("IsAutoReplication: " + i.getIsAutoReplication());
        System.out.println("keepContent: " + i.getKeepContent());
        System.out.println("preCalculatedFeatures: " + i.getPrecalculatedFeatures());
        System.out.println("AutoCreateLanguages: " + i.getAutoCreateLanguages());
        int j = 0;
        while (j < i.countLanguages()) {
            if (j == 0) {
                System.out.println("Laiso: " + i.getFirstLanguage());
            } else {
                System.out.println("Laiso: " + i.getNextLanguage());
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < i.countTaxonomyInfos()) {
            if (j2 == 0) {
                at = i.getFirstTaxonomyInfo();
                System.out.println("Tax - Name: " + at.getTaxonomyName());
                System.out.println("Tax - Laiso: " + at.getLanguage());
            } else {
                at = i.getNextTaxonomyInfo();
                System.out.println("Tax - Name: " + at.getTaxonomyName());
                System.out.println("Tax - Laiso: " + at.getLanguage());
            }
            ++j2;
        }
        System.out.println("Description: " + i.getDescription());
        int g = 0;
        while (g < i.countDocumentAttribute()) {
            if (g == 0) {
                System.out.println("doc name: " + i.getFirstDocumentAttribute().getName());
            } else {
                System.out.println("doc name: " + i.getNextDocumentAttribute().getName());
            }
            ++g;
        }
        System.out.println("IndexType :" + i.getIndexType());
        System.out.println("LogicalIndexType :" + i.getLogicalIndexType());
        if (i.countLanguageIndexList() != 0) {
            System.out.println("LanguageIndexList count: " + i.countLanguageIndexList());
            ai = i.getFirstLanguagePart();
            while (ai != null) {
                System.out.println("LanguageParts: IndexName=" + ai.getIndexName() + " IndexServer=" + ai.getIndexServer());
                ai = i.getNextLanguagePart();
            }
        }
        if (i.countPhysicalIndexList() != 0) {
            System.out.println("PhysicalIndexList count: " + i.countPhysicalIndexList());
            ai = i.getFirstPhysicalPart();
            while (ai != null) {
                System.out.println("PhysicalParts: IndexName=" + ai.getIndexName() + " IndexServer=" + ai.getIndexServer());
                ai = i.getNextPhysicalPart();
            }
        }
    }

    public static void getSettings() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setIndexServerLocation("iwdf9913", 8351);
        TrexSettings trexSettings = admin.getSettings();
    }

    public static void defineIndexAttribute() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setDocumentAttribute("neuesAttr2", "STRING", true);
        admin.setIndexId("dpa", "http", "pgwdf121", 8353, "/trexhttpserver/trexhttpserverd.dll");
        admin.defineAttribute();
    }

    public static void getQueueServerVersion() throws TrexException {
        AdminManager adminManager = TrexFactory.getAdminManager();
    }

    public static void getHTTPServerVersions() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        ArrayList ll = admin.showHttpServer();
        int i = 0;
        while (i < ll.size()) {
            String strURL = "";
            URL urlHTTPServer = null;
            strURL = (String)ll.get(i);
            urlHTTPServer = HttpServerURL.getURL(strURL);
            System.out.println("HTTP Server : " + urlHTTPServer.getHost() + ":" + urlHTTPServer.getPort() + " Protocol: " + urlHTTPServer.getProtocol());
            ++i;
        }
    }

    public static void getTREXServerVersion() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        Location location = new Location();
        location.setHost("P54896");
        location.setPort(8352);
        TrexVersion version = admin.getTREXVersionInfo(location);
        System.out.println("TREX Server : " + location.getHost() + ":" + location.getPort());
        System.out.println("TREXVersion : " + version.getTREXVersion() + " BuildNr: " + version.getBuildNr() + " BuildTime " + version.getBuildTime());
        System.out.println("Major Version: " + version.getMajorVersion() + ", Minor Version: " + version.getMinorVersion() + ", SupportPackage: " + version.getSupportPackageVersion());
        System.out.println("-----------------------------");
    }

    public static void deleteIndex() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setIndexId("bla");
        admin.deleteIndex();
    }

    public static void replicateIndices() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.setLocigalIndex("Test");
        admin.addIndexLaiso("ak-2", "EN");
        admin.replicateIndices();
    }

    public static void createIndex() throws TrexException {
        CreateIndexManager c = TrexFactory.getCreateIndexManager();
        c.setIndexId("bs-1", "https", "p72458.wdf.sap-ag.de", 444, "/TRexHTTPServer/Trexhttpserver.dll");
        c.useQueueServer(true);
        c.setSearchEngine("DRFUZZY");
        c.setMiningFlag(true);
        c.setSSLData("F:/crypto/keystore", "F:/crypto/truststore");
        c.createIndex();
    }

    public static void modifyIndexReplication() throws TrexException {
        AdminManager admin = TrexFactory.getAdminManager();
        admin.addIndexId("dpa");
        String id = admin.modifyIndexReplication(2, false);
        System.out.println("ModifyIndexReplication id: " + id);
    }

    public static void main(String[] args) throws TrexException {
        ExampleAdmin.modifyIndexReplication();
    }
}

