/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.base64;

import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.SAXException;

public class Base64 {
    private static final int BLOCK_SIZE = 20;
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        int i = 0;
        while (i < raw.length) {
            encoded.append(Base64.encodeBlock(raw, i));
            i += 3;
        }
        return encoded.toString();
    }

    public static void encodeBlockedIntoXMLWriter(byte[] raw, XMLWriter w) throws SAXException {
        int blockSizeInByte = 60;
        char[] encoded = new char[80];
        int i = 0;
        while (i < raw.length) {
            int encodedPos = 0;
            int endBlock = i + blockSizeInByte;
            if (endBlock > raw.length) {
                endBlock = raw.length;
            }
            int j = i;
            while (j < endBlock) {
                char[] encodedBlock = Base64.encodeBlock(raw, j);
                int k = 0;
                while (k < 4) {
                    encoded[encodedPos++] = encodedBlock[k];
                    ++k;
                }
                j += 3;
            }
            w.characters(encoded, 0, encodedPos);
            i += blockSizeInByte;
        }
    }

    public static void encodeBlockedIntoWriter(byte[] raw, Writer w) throws IOException {
        int blockSizeInByte = 60;
        char[] encoded = new char[80];
        int i = 0;
        while (i < raw.length) {
            int encodedPos = 0;
            int endBlock = i + blockSizeInByte;
            if (endBlock > raw.length) {
                endBlock = raw.length;
            }
            int j = i;
            while (j < endBlock) {
                char[] encodedBlock = Base64.encodeBlock(raw, j);
                int k = 0;
                while (k < 4) {
                    encoded[encodedPos++] = encodedBlock[k];
                    ++k;
                }
                j += 3;
            }
            w.write(encoded, 0, encodedPos);
            i += blockSizeInByte;
        }
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        int i = 0;
        while (i <= end) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
            ++i;
        }
        char[] base64 = new char[4];
        int i2 = 0;
        while (i2 < 4) {
            int sixbit = block >>> 6 * (3 - i2) & 0x3F;
            base64[i2] = Base64.getChar(sixbit);
            ++i2;
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    public static byte[] decode(String base64) {
        char[] chars = base64.toCharArray();
        return Base64.decode(chars);
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }

    public static char[] encode2(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(char[] data) {
        int tempLen = data.length;
        int ix = 0;
        while (ix < data.length) {
            if (data[ix] > '\u00ff' || codes[data[ix]] < 0) {
                --tempLen;
            }
            ++ix;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix2 = 0;
        while (ix2 < data.length) {
            int value;
            int n = value = data[ix2] > '\u00ff' ? -1 : codes[data[ix2]];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix2;
        }
        if (index != out.length) {
            throw new Error("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }

    static {
        int i = 0;
        while (i < 256) {
            Base64.codes[i] = -1;
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            Base64.codes[i2] = (byte)(i2 - 65);
            ++i2;
        }
        int i3 = 97;
        while (i3 <= 122) {
            Base64.codes[i3] = (byte)(26 + i3 - 97);
            ++i3;
        }
        int i4 = 48;
        while (i4 <= 57) {
            Base64.codes[i4] = (byte)(52 + i4 - 48);
            ++i4;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }
}

