/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.admin;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexVersion;
import com.sapportals.trex.core.admin.AbstractAdmin;
import com.sapportals.trex.core.admin.AdminIndex;
import com.sapportals.trex.core.admin.BackupIndexRequest;
import com.sapportals.trex.core.admin.ClearIndexRequest;
import com.sapportals.trex.core.admin.CopyIndexRequest;
import com.sapportals.trex.core.admin.DefineAttributeRequest;
import com.sapportals.trex.core.admin.DeleteIndexAttributeRequest;
import com.sapportals.trex.core.admin.DeleteIndexRequest;
import com.sapportals.trex.core.admin.DeleteReplicatedIndicesRequest;
import com.sapportals.trex.core.admin.GetAllIndicesRequest;
import com.sapportals.trex.core.admin.GetHttpServerVersionRequest;
import com.sapportals.trex.core.admin.GetIndexServerVersionRequest;
import com.sapportals.trex.core.admin.GetIndexedLanguagesRequest;
import com.sapportals.trex.core.admin.GetPathRequest;
import com.sapportals.trex.core.admin.GetPathReturn;
import com.sapportals.trex.core.admin.GetQueueServerVersionRequest;
import com.sapportals.trex.core.admin.GetSettingsRequest;
import com.sapportals.trex.core.admin.GetTREXVersionRequest;
import com.sapportals.trex.core.admin.GetTopologyRequest;
import com.sapportals.trex.core.admin.IndexLaiso;
import com.sapportals.trex.core.admin.IndexServerVersionReturn;
import com.sapportals.trex.core.admin.IndexedLanguagesResult;
import com.sapportals.trex.core.admin.ModifyIndexReplicationRequest;
import com.sapportals.trex.core.admin.MoveIndexRequest;
import com.sapportals.trex.core.admin.ReplicateIndicesRequest;
import com.sapportals.trex.core.admin.RestoreIndexRequest;
import com.sapportals.trex.core.admin.ServerIndexList;
import com.sapportals.trex.core.admin.ServerInfoList;
import com.sapportals.trex.core.admin.SetIndexPropertyRequest;
import com.sapportals.trex.core.admin.SetPathRequest;
import com.sapportals.trex.core.admin.SetSettingsRequest;
import com.sapportals.trex.core.admin.ShowIndexRequest;
import com.sapportals.trex.core.admin.ShowIndexServerRequest;
import com.sapportals.trex.core.admin.ShowQueueServerRequest;
import com.sapportals.trex.core.admin.ShowServersRequest;
import com.sapportals.trex.core.admin.TrexSettings;
import com.sapportals.trex.core.util.LocationList;
import com.sapportals.trex.tns.TNode;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.io.IOException;
import org.xml.sax.SAXException;

class HttpAdmin
extends AbstractAdmin {
    private TrexSettings m_settings = null;

    HttpAdmin() {
    }

    public void deleteIndex() throws TrexException {
        DeleteIndexRequest request = new DeleteIndexRequest();
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpAdmin(this);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatDeleteIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("DeleteIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.indexServerLocation != null) {
            w.startElement("IndexServerLocation");
            w.dataElement("Host", this.indexServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
            w.endElement("IndexServerLocation");
        }
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        w.endElement("DeleteIndex");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void backupIndex() throws TrexException {
        BackupIndexRequest request = new BackupIndexRequest();
        request.setHttpAdmin(this);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatBackupIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("BackupIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        w.endElement("BackupIndex");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void clearIndex() throws TrexException {
        ClearIndexRequest request = new ClearIndexRequest();
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpAdmin(this);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatClearIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("ClearIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        if (this.m_cleardefinitions) {
            w.dataElement("clearDefinitions", "YES");
        }
        w.endElement("ClearIndex");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void restoreIndex() throws TrexException {
        RestoreIndexRequest request = new RestoreIndexRequest();
        request.setHttpAdmin(this);
        request.run();
    }

    public void formatRestoreIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("RestoreIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        w.endElement("RestoreIndex");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void moveIndex(String destination) throws TrexException {
        MoveIndexRequest request = new MoveIndexRequest();
        request.setHttpAdmin(this);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatMoveIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("MoveIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        w.endElement("MoveIndex");
        w.endElement("AdminRequest");
        w.endDocument();
        throw new UnsupportedOperationException("Method formatMoveIndex() not yet implemented.");
    }

    public void copyIndex(String destination) throws TrexException {
        CopyIndexRequest request = new CopyIndexRequest();
        request.setHttpAdmin(this);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatCopyIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("CopyIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.language != null) {
            w.dataElement("LAISO", this.language);
        }
        w.endElement("CopyIndex");
        w.endElement("AdminRequest");
        w.endDocument();
        throw new UnsupportedOperationException("Method formatCopyIndex() not yet implemented.");
    }

    public AdminIndex showIndex() throws TrexException {
        ShowIndexRequest request = new ShowIndexRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().showIndex();
    }

    public void formatShowIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 12);
        w.startElement("ShowIndex");
        w.dataElement("IndexID", this.indexId);
        if (this.indexServerLocation != null) {
            w.startElement("IndexServerLocation");
            w.dataElement("Host", this.indexServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
            w.endElement("IndexServerLocation");
        }
        w.endElement("ShowIndex");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public ServerIndexList getAllIndices() throws TrexException {
        GetAllIndicesRequest request = new GetAllIndicesRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.run();
        return request.getParser().getAllIndices();
    }

    public void formatGetAllIndicesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("GetAllIndices");
        if (this.indexServerLocation != null) {
            w.startElement("IndexServerLocation");
            w.dataElement("Host", this.indexServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
            w.endElement("IndexServerLocation");
        }
        if (this.nameSpace != null) {
            w.dataElement("NameSpace", this.nameSpace);
        }
        w.endElement("GetAllIndices");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void formatGetPathRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("GetPath");
        w.startElement("IndexServerLocation");
        w.dataElement("Host", this.indexServerLocation.getHost());
        w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
        w.endElement("IndexServerLocation");
        w.dataElement("TMEngineName", this.tmEngineName);
        w.endElement("GetPath");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public GetPathReturn getPath() throws TrexException {
        GetPathRequest request = new GetPathRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getPath();
    }

    public void formatGetIndexServerVersionRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("GetVersion");
        w.startElement("IndexServerLocation");
        w.dataElement("Host", this.indexServerLocation.getHost());
        w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
        w.endElement("IndexServerLocation");
        w.endElement("GetVersion");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public IndexServerVersionReturn getIndexServerVersion() throws TrexException {
        GetIndexServerVersionRequest request = new GetIndexServerVersionRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getIndexServerVersion();
    }

    public void formatGetQueueServerVersionRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("GetVersion");
        w.startElement("QueueServerLocation");
        w.dataElement("Host", this.queueServerLocation.getHost());
        w.dataElement("Port", String.valueOf(this.queueServerLocation.getPort()));
        w.endElement("QueueServerLocation");
        w.endElement("GetVersion");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void formatGetTREXVersionRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 0);
        w.startElement("GetTREXVersion");
        if (this.serverLocation != null) {
            w.startElement("Location");
            w.dataElement("Host", this.serverLocation.getHost());
            w.dataElement("Port", String.valueOf(this.serverLocation.getPort()));
            w.endElement("Location");
        } else {
            w.dataElement("HTTPServerFlag", "");
        }
        w.endElement("GetTREXVersion");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public String getQueueServerVersion() throws TrexException {
        GetQueueServerVersionRequest request = new GetQueueServerVersionRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getQueueServerVersion();
    }

    public void formatGetHttpServerVersionRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 6);
        w.startElement("GetVersion");
        w.startElement("HTTPServerLocation");
        if (this.httpServerLocation != null) {
            w.dataElement("Host", this.httpServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.httpServerLocation.getPort()));
        }
        w.endElement("HTTPServerLocation");
        w.endElement("GetVersion");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public String getHttpServerVersion() throws TrexException {
        GetHttpServerVersionRequest request = new GetHttpServerVersionRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getHttpServerVersion();
    }

    public TrexVersion getHttpServerVersion2() throws TrexException {
        GetHttpServerVersionRequest request = new GetHttpServerVersionRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getHttpServerVersion2();
    }

    public TrexVersion getTREXVersionInfo(boolean bForHTTPServer) throws TrexException {
        GetTREXVersionRequest request = new GetTREXVersionRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.run();
        return request.getParser().getTREXVersionRequest();
    }

    public void formatShowIndexServerRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("ShowIndexServer");
        w.endElement("ShowIndexServer");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public LocationList showIndexServer() throws TrexException {
        ShowIndexServerRequest request = new ShowIndexServerRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.run();
        return request.getParser().showIndexServer();
    }

    public void formatShowQueueServerRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("ShowQueueServer");
        w.endElement("ShowQueueServer");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public LocationList showQueueServer() throws TrexException {
        ShowQueueServerRequest request = new ShowQueueServerRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.run();
        return request.getParser().showQueueServer();
    }

    public void formatSetPathRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("SetPath");
        w.startElement("IndexServerLocation");
        w.dataElement("Host", this.indexServerLocation.getHost());
        w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
        w.endElement("IndexServerLocation");
        w.dataElement("TMEngineName", this.tmEngineName);
        w.startElement("TMEnginePath");
        if (this.tmEngineDataPath != null || !this.tmEngineDataPath.equals("")) {
            w.dataElement("DataPath", this.tmEngineDataPath);
        }
        if (this.tmEngineBackupPath != null || !this.tmEngineBackupPath.equals("")) {
            w.dataElement("BackupPath", this.tmEngineBackupPath);
        }
        w.endElement("TMEnginePath");
        w.endElement("SetPath");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void setPath() throws TrexException {
        SetPathRequest request = new SetPathRequest();
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpAdmin(this);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public ServerInfoList showServers() throws TrexException {
        ShowServersRequest request = new ShowServersRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().reactor.getShowServersResult();
    }

    public void formatShowServersRequest(XMLWriter w) throws SAXException, IOException {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("ShowServers");
        w.dataElement("ServerType", String.valueOf(this.serverType));
        if (!this.isActive) {
            w.dataElement("isActive", "NO");
        }
        w.endElement("ShowServers");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public TrexSettings getSettings() throws TrexException {
        GetSettingsRequest request = new GetSettingsRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().reactor.getSettings();
    }

    public void formatGetSettingsRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("GetProperties");
        if (this.indexServerLocation != null) {
            w.startElement("IndexDef");
            w.dataElement("Host", this.indexServerLocation.getHost());
            w.dataElement("Port", String.valueOf(this.indexServerLocation.getPort()));
            w.endElement("IndexDef");
        }
        w.endElement("GetProperties");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void setSettings(TrexSettings settings) throws TrexException {
        this.m_settings = settings;
        SetSettingsRequest request = new SetSettingsRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatSetSettingsRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("SetProperties");
        if (this.indexServerLocation != null) {
            w.startElement("IndexDef");
            w.dataElement("Host", this.indexServerLocation.getHost());
            w.dataElement("Port", this.indexServerLocation.getHost());
            w.endElement("IndexDef");
        }
        String key = this.m_settings.getFirstKey();
        while (key != null) {
            w.startElement("Property");
            w.dataElement("Key", key);
            w.dataElement("Value", this.m_settings.getValue(key));
            key = this.m_settings.getNextKey();
            w.endElement("Property");
        }
        key = this.m_settings.getFirstKeyForRemoval();
        while (key != null) {
            w.startElement("Property");
            w.dataElement("Key", key);
            key = this.m_settings.getNextKeyForRemoval();
            w.endElement("Property");
        }
        w.endElement("SetProperties");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void replicateIndices() throws TrexException {
        ReplicateIndicesRequest request = new ReplicateIndicesRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void deleteReplicatedIndices() throws TrexException {
        DeleteReplicatedIndicesRequest request = new DeleteReplicatedIndicesRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatReplicateIndicesRequest(XMLWriter w) throws Exception {
        IndexLaiso il = null;
        w.startDocument();
        w.startElement("AdminRequest", 2);
        w.startElement("ReplicateIndices");
        if (this.logicalIndex != null && !this.logicalIndex.equals("")) {
            w.dataElement("LogicalIndex", this.logicalIndex);
        }
        if (this.indexLaisoList != null && this.indexLaisoList.countIndexLaisoList() != 0) {
            w.startElement("IndexLAISOList");
            int j = 0;
            while (j < this.indexLaisoList.countIndexLaisoList()) {
                w.startElement("IndexLAISO");
                il = j == 0 ? this.indexLaisoList.getFirstIndexLaiso() : this.indexLaisoList.getNextIndexLaiso();
                w.dataElement("IndexID", il.getIndexId());
                w.dataElement("LAISO", il.getLaiso());
                w.endElement("IndexLAISO");
                ++j;
            }
            w.endElement("IndexLAISOList");
        }
        w.endElement("ReplicateIndices");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void formatDeleteReplicatedIndicesRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("DeleteReplicatedIndices");
        w.startElement("IndexLAISOList");
        int i = 0;
        while (i < this.indexLaisoList.countIndexLaisoList()) {
            IndexLaiso il = i == 0 ? this.indexLaisoList.getFirstIndexLaiso() : this.indexLaisoList.getNextIndexLaiso();
            w.startElement("IndexLAISO");
            w.dataElement("IndexID", il.getIndexId());
            w.dataElement("LAISO", il.getLaiso());
            w.endElement("IndexLAISO");
            ++i;
        }
        w.endElement("IndexLAISOList");
        w.endElement("DeleteReplicatedIndices");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void formatDefineAttributeRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("DefineIndexAttribute");
        w.dataElement("IndexID", this.indexId);
        w.startElement("DocAttribute");
        w.dataElement("Name", this.attributeDefinition.getName());
        w.dataElement("Type", this.attributeDefinition.getType());
        if (this.attributeDefinition.getTextMiningRelevant()) {
            w.dataElement("TextMiningFlag", "YES");
        } else {
            w.dataElement("TextMiningFlag", "NO");
        }
        if (this.attributeDefinition.getDefaultWeight() != -1.0f) {
            w.dataElement("DefaultWeight", String.valueOf(this.attributeDefinition.getDefaultWeight()));
        }
        if (this.attributeDefinition.getGroup() != null) {
            w.dataElement("Group", this.attributeDefinition.getGroup());
        }
        if (this.attributeDefinition.getImplementationFlags() != -1) {
            w.dataElement("ImplementationFlags", String.valueOf(this.attributeDefinition.getImplementationFlags()));
        }
        if (this.attributeDefinition.getImplementationParameters() != null) {
            w.dataElement("ImplementationParams", this.attributeDefinition.getImplementationParameters());
        }
        w.endElement("DocAttribute");
        w.endElement("DefineIndexAttribute");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void defineAttribute() throws TrexException {
        DefineAttributeRequest request = new DefineAttributeRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void deleteIndexAttribute() throws TrexException {
        DeleteIndexAttributeRequest request = new DeleteIndexAttributeRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatDeleteIndexAttribute(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("DeleteIndexAttribute");
        w.dataElement("IndexID", this.indexId);
        w.dataElement("Name", this.m_docAttributeName);
        w.endElement("DeleteIndexAttribute");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public IndexedLanguagesResult getIndexedLanguages() throws TrexException {
        GetIndexedLanguagesRequest request = new GetIndexedLanguagesRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().reactor.getIndexedLanguagesResult();
    }

    public void formatGetIndexedLanguages(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("GetIndexedLanguages");
        w.startElement("IndexIDList");
        if (this.indexIdList != null) {
            int i = 0;
            while (i < this.indexIdList.size()) {
                w.dataElement("IndexID", (String)this.indexIdList.get(i));
                ++i;
            }
        }
        w.endElement("IndexIDList");
        w.endElement("GetIndexedLanguages");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public TNode getTopology() throws TrexException {
        GetTopologyRequest request = new GetTopologyRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getParser().reactor.getTopologyResult();
    }

    public void formatGetTopology(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("GetTopology");
        w.dataElement("Path", this.m_topologypath);
        w.endElement("GetTopology");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public void setIndexProperty() throws TrexException {
        SetIndexPropertyRequest request = new SetIndexPropertyRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
    }

    public void formatSetIndexProperty(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("SetIndexProperty");
        w.dataElement("IndexID", this.indexId);
        w.dataElement("Name", this.m_propertyName);
        w.dataElement("Value", this.m_propertyValue);
        w.endElement("SetIndexProperty");
        w.endElement("AdminRequest");
        w.endDocument();
    }

    public String modifyIndexReplication(int action, boolean sync) throws TrexException {
        ModifyIndexReplicationRequest request = new ModifyIndexReplicationRequest();
        request.setHttpAdmin(this);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getModifyIndexReplicationId();
    }

    public void formatModifyIndexReplicationRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("AdminRequest");
        w.startElement("modifyIndexReplication");
        w.startElement("IndexIDList");
        if (this.indexIdList != null) {
            int i = 0;
            while (i < this.indexIdList.size()) {
                w.dataElement("IndexID", (String)this.indexIdList.get(i));
                ++i;
            }
        }
        w.endElement("IndexIDList");
        w.dataElement("action", String.valueOf(this.m_replicationAction));
        if (this.m_sync) {
            w.dataElement("sync", "YES");
        } else {
            w.dataElement("sync", "NO");
        }
        w.endElement("modifyIndexReplication");
        w.endElement("AdminRequest");
        w.endDocument();
    }
}

