/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core.admin;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexVersion;
import com.sapportals.trex.core.AttributeDefinition;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.admin.AbstractAdmin;
import com.sapportals.trex.core.admin.AdminIndex;
import com.sapportals.trex.core.admin.GetPathReturn;
import com.sapportals.trex.core.admin.HttpAdmin;
import com.sapportals.trex.core.admin.IndexLaisoList;
import com.sapportals.trex.core.admin.IndexServerVersionReturn;
import com.sapportals.trex.core.admin.IndexedLanguagesResult;
import com.sapportals.trex.core.admin.ServerIndexList;
import com.sapportals.trex.core.admin.ServerInfo;
import com.sapportals.trex.core.admin.ServerInfoList;
import com.sapportals.trex.core.admin.TrexSettings;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.LocationList;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import com.sapportals.trex.tns.TNSClient;
import com.sapportals.trex.tns.TNode;
import com.sapportals.trex.util.cache.CacheManager;
import com.sapportals.trex.util.cache.WrappedCache;
import java.net.URL;
import java.util.ArrayList;

public class AdminManager
extends BaseManager {
    private String m_indexId;
    private String m_logicalIndex;
    private String m_language;
    private String m_searchEngine;
    private String m_tmEngineName;
    private String m_attributeName;
    private String m_topologypath;
    private boolean m_httpserverManuallySet = false;
    private com.sapportals.trex.core.util.Location indexServerLocation = null;
    private IndexLaisoList indexLaisoList = new IndexLaisoList();
    private AttributeDefinition attributeDefinition;
    private ArrayList m_indexIds = new ArrayList();
    private String mode;
    private String host;
    private int port;
    private String file;
    private String m_httpserverurl;
    public static final int SERVER_TYPE_UNKNOWN = -1;
    public static final int SERVER_TYPE_INDEX_SERVER = 0;
    public static final int SERVER_TYPE_QUEUE_SERVER = 1;
    public static final int SERVER_TYPE_PREPROCESSOR = 2;
    public static final int SERVER_TYPE_HTTP_SERVER = 3;
    public static final int SERVER_TYPE_NAME_SERVER = 4;
    public static final int SERVER_TYPE_RFC_SERVER = 5;
    public static final int SERVER_TYPE_ALL_SERVERS = 6;
    public static final int REPLICATION_ACTION_TRIGGER = 2;
    public static final int REPLICATION_ACTION_ABORT = 3;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$admin$AdminManager == null ? (class$com$sapportals$trex$core$admin$AdminManager = AdminManager.class$("com.sapportals.trex.core.admin.AdminManager")) : class$com$sapportals$trex$core$admin$AdminManager).getName());
    static /* synthetic */ Class class$com$sapportals$trex$core$admin$AdminManager;

    public void setIndexId(String indexName) throws TrexException {
        this.m_indexId = indexName;
        if (log.beDebug()) {
            log.debugT("Index '" + indexName + "': parameters were set to " + this.m_httpserverurl);
        }
    }

    public void setLocigalIndex(String logicalIndex) throws TrexException {
        this.m_logicalIndex = logicalIndex;
    }

    public void addIndexLaiso(String indexId, String language) throws TrexException {
        this.indexLaisoList.addIndexLaiso(indexId, language);
    }

    public void addIndexId(String id) {
        this.m_indexIds.add(id);
    }

    public void setIndexId(String indexId, String mode, String host, int port, String file) throws TrexException {
        this.m_indexId = indexId;
        this.mode = mode;
        this.host = host;
        this.port = port;
        this.file = file;
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
        this.m_httpserverManuallySet = true;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public void setSearchEngine(String searchEngine) throws TrexException {
        this.m_searchEngine = searchEngine.equals("DRFUZZY") || searchEngine.equals("VERITY") || searchEngine.equals("FULCRUM") ? searchEngine : "DRFUZZY";
    }

    public void deleteIndex() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            monitor.compAction("EP:KM:TREX:ADMIN", "delete index: " + this.m_indexId);
            AbstractAdmin admin = this.getNewAdminInstance();
            if (this.m_indexId == null) {
                throw new TrexException(7230);
            }
            admin.setIndexId(this.m_indexId);
            admin.setLanguage(this.m_language);
            admin.setSearchEngine(this.m_searchEngine);
            admin.setIndexUser(this.m_indexUser);
            log.infoT("Delete index " + this.m_indexId + " started");
            admin.deleteIndex();
            log.infoT("Delete Index " + this.m_indexId + " finished");
            Object var5_4 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            this.clearSearchCache();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            this.clearSearchCache();
            throw throwable;
        }
    }

    public void backupIndex() throws TrexException {
        throw new UnsupportedOperationException("Method backupIndex() not yet implemented.");
    }

    public void clearIndex() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:CLEAR");
            monitor.compAction("EP:KM:TREX:CLEAR", "clear index" + this.m_indexId);
            AbstractAdmin admin = this.getNewAdminInstance();
            if (this.m_indexId == null) {
                throw new TrexException(7230);
            }
            admin.setIndexId(this.m_indexId);
            admin.setLanguage(this.m_language);
            admin.setSearchEngine(this.m_searchEngine);
            admin.setIndexUser(this.m_indexUser);
            log.infoT("Clearing of Index " + this.m_indexId + " started");
            admin.clearIndex();
            log.infoT("Clearing of Index " + this.m_indexId + " finished");
            Object var4_3 = null;
            monitor.endComponent("EP:KM:TREX:CLEAR");
            monitor.endRequest();
            monitor = null;
            this.clearSearchCache();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:CLEAR");
            monitor.endRequest();
            monitor = null;
            this.clearSearchCache();
            throw throwable;
        }
    }

    public void clearIndex(boolean cleardefinitions) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:CLEAR");
            monitor.compAction("EP:KM:TREX:CLEAR", "clear index" + this.m_indexId);
            AbstractAdmin admin = this.getNewAdminInstance();
            if (this.m_indexId == null) {
                throw new TrexException(7230);
            }
            admin.setIndexId(this.m_indexId);
            admin.setLanguage(this.m_language);
            admin.setSearchEngine(this.m_searchEngine);
            admin.setIndexUser(this.m_indexUser);
            admin.setClearDefinitions(cleardefinitions);
            log.infoT("Clearing  of Index " + this.m_indexId + " started");
            admin.clearIndex();
            log.infoT("Clearing of Index " + this.m_indexId + " finised");
            Object var5_4 = null;
            monitor.endComponent("EP:KM:TREX:CLEAR");
            monitor.endRequest();
            monitor = null;
            this.clearSearchCache();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.endComponent("EP:KM:TREX:CLEAR");
            monitor.endRequest();
            monitor = null;
            this.clearSearchCache();
            throw throwable;
        }
    }

    public void restoreIndex() throws TrexException {
        throw new UnsupportedOperationException("Method restoreIndex() not yet implemented.");
    }

    public void moveIndex(String destination) throws TrexException {
        throw new UnsupportedOperationException("Method moveIndex() not yet implemented.");
    }

    public void copyIndex(String destination) throws TrexException {
        throw new UnsupportedOperationException("Method copyIndex() not yet implemented.");
    }

    public ServerIndexList getAllIndices() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            AbstractAdmin admin = this.getNewAdminInstance();
            admin.setNameSpace("");
            if (this.indexServerLocation != null) {
                monitor.compAction("EP:KM:TREX:ADMIN", "GetAllIndices on Server " + this.indexServerLocation.getHost() + ":" + this.indexServerLocation.getPort());
                admin.setIndexServerLocation(this.indexServerLocation);
            } else {
                monitor.compAction("EP:KM:TREX:ADMIN", "GetAllIndices on all Index Servers");
            }
            admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            log.infoT("GetAllIndices on all indexserver started");
            ServerIndexList sil = admin.getAllIndices();
            log.infoT("GetAllIndices on all indexservers finished.");
            ServerIndexList serverIndexList = sil;
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            return serverIndexList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public ServerIndexList getAllIndices(String nameSpace) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            AbstractAdmin admin = this.getNewAdminInstance();
            if (nameSpace != null || !nameSpace.equals("")) {
                admin.setNameSpace(nameSpace);
            }
            if (this.indexServerLocation != null) {
                monitor.compAction("EP:KM:TREX:ADMIN", "GetAllIndices on Server " + this.indexServerLocation.getHost() + ":" + this.indexServerLocation.getPort() + " NameSpace = " + nameSpace);
                admin.setIndexServerLocation(this.indexServerLocation);
            } else {
                monitor.compAction("EP:KM:TREX:ADMIN", "GetAllIndices on all Index Servers with namespace " + nameSpace);
            }
            admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            log.infoT("GetAllIndices started.");
            ServerIndexList sil = admin.getAllIndices();
            log.infoT("GetAllIndices for NameSpace " + nameSpace + "finished.");
            ServerIndexList serverIndexList = sil;
            Object var7_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            return serverIndexList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public ServerIndexList listIndexes() throws TrexException {
        return this.getAllIndices();
    }

    public void setIndexProperty(String name, String value) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        if (this.m_indexId == null || this.m_indexId.equals("")) {
            throw new TrexException(7230);
        }
        if (name == null || name.equals("")) {
            throw new TrexException(7801, name);
        }
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            AbstractAdmin admin = this.getNewAdminInstance();
            admin.setIndexId(this.m_indexId);
            log.infoT("SetIndexProperty of Index " + this.m_indexId + " started");
            admin.setPropertyName(name);
            admin.setPropertyValue(value);
            admin.setIndexProperty();
            log.infoT("SetIndexProperty of Index " + this.m_indexId + " finished");
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public AdminIndex showIndex() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            AbstractAdmin admin = this.getNewAdminInstance();
            admin.setIndexId(this.m_indexId);
            admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            if (this.indexServerLocation != null) {
                admin.setIndexServerLocation(this.indexServerLocation);
            }
            log.infoT("ShowIndex of Index " + this.m_indexId + " started");
            AdminIndex a = admin.showIndex();
            log.infoT("ShowIndex of Index " + this.m_indexId + " finished");
            AdminIndex adminIndex = a;
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            return adminIndex;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public IndexServerVersionReturn getIndexServerVersion() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            monitor.compAction("EP:KM:TREX:ADMIN", "get version from index server: " + this.indexServerLocation.getHost() + ":" + this.indexServerLocation.getPort());
            AbstractAdmin admin = this.getNewAdminInstance();
            admin.setIndexServerLocation(this.indexServerLocation);
            admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            log.infoT("GetIndexServerVersion started");
            IndexServerVersionReturn isvr = admin.getIndexServerVersion();
            log.infoT("GetIndexServerVersion ended");
            IndexServerVersionReturn indexServerVersionReturn = isvr;
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            return indexServerVersionReturn;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public String getQueueServerVersion(com.sapportals.trex.core.util.Location queueServerLocation) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            monitor.compAction("EP:KM:TREX:ADMIN", "get version from queue server: " + queueServerLocation.getHost() + ":" + queueServerLocation.getPort());
            AbstractAdmin admin = this.getNewAdminInstance();
            admin.setQueueServerLocation(queueServerLocation);
            admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            log.infoT("GetQueueServerVersion started");
            String qsv = admin.getQueueServerVersion();
            log.infoT("GetQueueServerVersion ended");
            String string = qsv;
            Object var7_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public String getHTTPServerVersion(com.sapportals.trex.core.util.Location httpServerLocation) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            monitor.compAction("EP:KM:TREX:ADMIN", "get version from HTTP server: " + httpServerLocation.getHost() + ":" + httpServerLocation.getPort());
            AbstractAdmin admin = this.getNewAdminInstance();
            admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            admin.setHttpServerLocation(httpServerLocation);
            log.infoT("Start of GetHTTPServerVersion");
            String hsv = admin.getHttpServerVersion();
            log.infoT("End of GetHTTPServerVersion");
            String string = hsv;
            Object var7_6 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TrexVersion getHTTPServerVersion2(URL httpServerURL) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            try {
                monitor.startComponent("EP:KM:TREX:ADMIN");
                monitor.compAction("EP:KM:TREX:ADMIN", "get version from HTTP server: " + httpServerURL.getHost() + ":" + httpServerURL.getPort());
                AbstractAdmin admin = this.getNewAdminInstance();
                admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
                log.infoT("Start of GetHTTPServerVersion");
                TrexVersion version = admin.getHttpServerVersion2();
                log.infoT("End of GetHTTPServerVersion");
                TrexVersion trexVersion = version;
                Object var7_8 = null;
                monitor.endComponent("EP:KM:TREX:ADMIN");
                monitor.endRequest();
                monitor = null;
                return trexVersion;
            }
            catch (TrexException e) {
                if (e.getCode() != 2981) {
                    throw e;
                }
                TrexVersion trexVersion = new TrexVersion();
                Object var7_9 = null;
                monitor.endComponent("EP:KM:TREX:ADMIN");
                monitor.endRequest();
                monitor = null;
                return trexVersion;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TrexVersion getTREXVersionInfo(URL httpServerURL) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            try {
                monitor.startComponent("EP:KM:TREX:ADMIN");
                monitor.compAction("EP:KM:TREX:ADMIN", "get version from HTTP server: " + httpServerURL.getHost() + ":" + httpServerURL.getPort());
                AbstractAdmin admin = this.getNewAdminInstance(httpServerURL);
                log.infoT("Start of GetHTTPServerVersion");
                TrexVersion version = admin.getHttpServerVersion2();
                log.infoT("End of GetHTTPServerVersion");
                TrexVersion trexVersion = version;
                Object var7_8 = null;
                monitor.endComponent("EP:KM:TREX:ADMIN");
                monitor.endRequest();
                monitor = null;
                return trexVersion;
            }
            catch (TrexException e) {
                if (e.getCode() != 2981) {
                    throw e;
                }
                TrexVersion trexVersion = new TrexVersion();
                Object var7_9 = null;
                monitor.endComponent("EP:KM:TREX:ADMIN");
                monitor.endRequest();
                monitor = null;
                return trexVersion;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TrexVersion getTREXVersionInfo(com.sapportals.trex.core.util.Location serverLocation) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            try {
                monitor.startComponent("EP:KM:TREX:ADMIN");
                monitor.compAction("EP:KM:TREX:ADMIN", "get version from TREX server: " + serverLocation.getHost() + ":" + serverLocation.getPort());
                AbstractAdmin admin = this.getNewAdminInstance();
                admin.setServerLocation(serverLocation);
                admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
                log.infoT("Start of getTREXVersionInfo");
                TrexVersion version = admin.getTREXVersionInfo(false);
                log.infoT("End of getTREXVersionInfo");
                TrexVersion trexVersion = version;
                Object var7_8 = null;
                monitor.endComponent("EP:KM:TREX:ADMIN");
                monitor.endRequest();
                monitor = null;
                return trexVersion;
            }
            catch (TrexException e) {
                if (e.getCode() != 2981) {
                    throw e;
                }
                TrexVersion trexVersion = new TrexVersion();
                Object var7_9 = null;
                monitor.endComponent("EP:KM:TREX:ADMIN");
                monitor.endRequest();
                monitor = null;
                return trexVersion;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public LocationList showIndexServer() throws TrexException {
        LocationList result = new LocationList();
        ServerInfo s = null;
        ServerInfoList sl = this.showServers(0, false);
        int i = 0;
        while (i < sl.countServerInfos()) {
            s = i == 0 ? sl.getFirstServerInfo() : sl.getNextServerInfo();
            com.sapportals.trex.core.util.Location l = s.getServerLocation();
            result.addLocationToServerLocationList(l);
            ++i;
        }
        return result;
    }

    public LocationList showQueueServer() throws TrexException {
        LocationList result = new LocationList();
        ServerInfoList sl = this.showServers(1, false);
        ServerInfo s = null;
        int i = 0;
        while (i < sl.countServerInfos()) {
            s = i == 0 ? sl.getFirstServerInfo() : sl.getNextServerInfo();
            com.sapportals.trex.core.util.Location l = s.getServerLocation();
            result.addLocationToServerLocationList(l);
            ++i;
        }
        return result;
    }

    public ServerInfoList showServers(int servertype, boolean isActive) throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setServerType(servertype);
        admin.setActive(isActive);
        return admin.showServers();
    }

    public ArrayList showHttpServer() throws TrexException {
        ArrayList result = new ArrayList();
        TNSClient client = new TNSClient();
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
        result = client.getAllHttpServers();
        return result;
    }

    public GetPathReturn getPath() throws TrexException {
        throw new UnsupportedOperationException("Method getPath() not yet implemented.");
    }

    public void setPath(String tmEngineName, String dataPath, String backupPath) throws TrexException {
        throw new UnsupportedOperationException("Method setPath() not yet implemented.");
    }

    public void setDocumentAttribute(String attributeName, String attributeType, boolean textMiningRelevant) {
        this.attributeDefinition = new AttributeDefinition(attributeName, attributeType, textMiningRelevant);
    }

    public void setDocumentAttribute(String attributeName, String attributeType, boolean textMiningRelevant, float defaultWeight, int implementationFlags, String implementationParams) {
        this.attributeDefinition = new AttributeDefinition(attributeName, attributeType, textMiningRelevant);
        this.attributeDefinition.setDefaultWeight(defaultWeight);
        this.attributeDefinition.setImplementationFlags(implementationFlags);
        this.attributeDefinition.setImplementationParameters(implementationParams);
    }

    public void setDocumentAttribute(AttributeDefinition attributeDefinition) {
        this.attributeDefinition = attributeDefinition;
    }

    public void defineAttribute() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:ADMIN");
            monitor.compAction("EP:KM:TREX:ADMIN", "define attribute: " + this.attributeDefinition.getName() + " type: " + this.attributeDefinition.getType() + " for index: " + this.m_indexId);
            AbstractAdmin admin = this.getNewAdminInstance();
            if (this.m_indexId == null || this.m_indexId.equals("")) {
                throw new TrexException(7230);
            }
            admin.setIndexId(this.m_indexId);
            admin.setDocAttribute(this.attributeDefinition);
            log.infoT("DefineAttribute " + this.attributeDefinition.getName() + " started");
            admin.defineAttribute();
            log.infoT("DefineAttribute " + this.attributeDefinition.getName() + " ended");
            Object var4_3 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:ADMIN");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void setIndexServerLocation(String host, int port) {
        this.indexServerLocation = new com.sapportals.trex.core.util.Location(host, port);
    }

    public void setTMEngineName(String tmEngineName) {
        this.m_tmEngineName = tmEngineName;
    }

    public TrexSettings getSettings() throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setIndexServerLocation(this.indexServerLocation);
        log.infoT("Getting TREX settings started");
        TrexSettings settings = admin.getSettings();
        log.infoT("Getting TREX settings finished");
        return settings;
    }

    public void setSettings(TrexSettings settings) throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setIndexServerLocation(this.indexServerLocation);
        log.infoT("Setting TREX settings started");
        admin.setSettings(settings);
        log.infoT("Setting TREX settings finished");
    }

    public void replicateIndices() throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setLogicalIndex(this.m_logicalIndex);
        admin.setIndexLaisoList(this.indexLaisoList);
        log.infoT("ReplicatedIndices started");
        admin.replicateIndices();
        log.infoT("ReplicatedIndices finished");
    }

    public void deleteReplicatedIndices() throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setLogicalIndex(this.m_logicalIndex);
        admin.setIndexLaisoList(this.indexLaisoList);
        log.infoT("DeleteReplicatedIndices started");
        admin.deleteReplicatedIndices();
        log.infoT("DeleteReplicatedIndices finished");
    }

    public String modifyIndexReplication(int action, boolean sync) throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setIndexIdList(this.m_indexIds);
        log.infoT("modifyIndexReplication started.");
        admin.setModifyIndexReplicationParam(action, sync);
        String id = admin.modifyIndexReplication(action, sync);
        log.infoT("modifyIndexReplication finished.");
        return id;
    }

    public void deleteIndexAttribute() throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        admin.setIndexId(this.m_indexId);
        admin.setDocAttributeName(this.m_attributeName);
        log.infoT("DeleteIndexAttribute started.");
        admin.deleteIndexAttribute();
        log.infoT("DeleteIndexAttribute finished.");
    }

    public void setAttributeName(String name) {
        this.m_attributeName = name;
    }

    public void setTopologyPath(String path) {
        this.m_topologypath = path;
    }

    public TNode getTopology() throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        TNode node = null;
        admin.setTopologyPath(this.m_topologypath);
        admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
        log.infoT("GetTopology started.");
        node = admin.getTopology();
        log.infoT("GetTopology finished.");
        return node;
    }

    public IndexedLanguagesResult getIndexedLanguages() throws TrexException {
        AbstractAdmin admin = this.getNewAdminInstance();
        IndexedLanguagesResult il = null;
        admin.setIndexIdList(this.m_indexIds);
        admin.setHttpServerManuallySet(this.m_httpserverManuallySet);
        log.infoT("GetIndexedLanguages started.");
        il = admin.getIndexedLanguages();
        log.infoT("GetIndexedLanguages finished.");
        return il;
    }

    private AbstractAdmin getNewAdminInstance() throws TrexException {
        HttpAdmin httpadmin = new HttpAdmin();
        httpadmin.setSSLApplicationPath(this.m_SSLApplicationPath);
        if (this.m_httpserverManuallySet) {
            httpadmin.setHttpServerManuallySet(this.m_httpserverManuallySet);
            try {
                httpadmin.setUrl(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException e1) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + e1.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        return httpadmin;
    }

    private AbstractAdmin getNewAdminInstance(URL httpServerURL) throws TrexException {
        HttpAdmin httpadmin = new HttpAdmin();
        httpadmin.setSSLApplicationPath(this.m_SSLApplicationPath);
        return httpadmin;
    }

    public ArrayList getActiveHttpServers() throws TrexException {
        TNSClient client = new TNSClient();
        return client.getActiveHttpServers();
    }

    private boolean clearSearchCache() {
        CacheManager cm = CacheManager.getInstance();
        WrappedCache cache = null;
        cache = cm.getCache("trexmemory");
        try {
            cache.clearCache();
        }
        catch (Exception e) {
            log.errorT("Warning clearing cache 'trexmemory' " + e.getMessage());
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

