/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.util.SSLConfigurationManager;
import com.sapportals.trex.util.cache.CacheManager;
import com.sapportals.trex.util.cache.WrappedCache;
import com.sapportals.trex.util.config.ConfigurationManager;
import com.sapportals.trex.util.config.IPropertyStore;
import com.sapportals.trex.util.config.PropertyStoreFactory;
import com.sapportals.trex.util.logging.LoggingInitializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class TrexConfigManager {
    public static final String CFG_SECTION_DEFAULT = "default";
    public static final String CFG_SECTION_INDEX = "index";
    public static final String CFG_SECTION_NAMESERVER = "nameserver";
    public static final String CFG_SECTION_CACHE = "cache";
    public static final String CFG_SECTION_QUERIES = "queries";
    public static final String CFG_SECTION_ADMIN_HTTPSERVER = "admin.httpserver";
    public static final String CFG_SECTION_ADMIN_INDEXSERVER = "admin.indexserver";
    public static final String CFG_SECTION_ADMIN_QUEUESERVER = "admin.queueserver";
    public static final String CFG_SECTION_CONTENTSERVER = "contentserver";
    public static final String CFG_SECTION_COMMUNICATION = "communication";
    public static final String CFG_INDEX_MODE = "mode";
    public static final String CFG_INDEX_SEARCHENGINE = "searchengine";
    public static final String CFG_INDEX_HTTPSERVER = "httpserver";
    public static final String CFG_DEFAULT_HTTPSERVER = "httpserver";
    public static final String CFG_DEFAULT_SSLPATH = "sslapplicationpath";
    public static final String CFG_DEFAULT_JARM = "usejarm";
    public static final String CFG_DEFAULT_KEYSTORE_VIEW = "keystore";
    public static final String CFG_DEFAULT_TRUSTSTORE_VIEW = "truststore";
    private static final String CFG_INIT_LOGGING = "initlogging";
    private static final String CFG_DEFAULT_CACHEHTTPSERVER = "cachehttpserver";
    public static final String CFG_USE_CACHE = "usecache";
    public static final String CFG_CACHE = "cache";
    public static final String CFG_CACHE_HTTPSERVERS = "cachehttpservers";
    public static final String CFG_USE_NAMESERVER = "usenameserver";
    public static final String CFG_NAMESERVER_ADDRESS = "address";
    public static final String CFG_NAMESERVER_BACKUP_LIST = "backupserverlist";
    public static final String CFG_REFRESHCOUNT = "refreshcount";
    public static final String CFG_USE_CONTENTSERVER = "usecontentserver";
    public static final String CFG_CONTENTSERVER_HOST = "host";
    public static final String CFG_CONTENTSERVER_PORT = "port";
    public static final String CFG_CONTENTSERVER_TIMEOUT = "timeout";
    public static final String CFG_ADMIN_ADDRESS = "address";
    public static final String CFG_ADMIN_ISACTIVE = "isactive";
    public static final String CFG_ADMIN_ACCESSCOUNT = "accesscount";
    public static final String CFG_COMMUNICATION_BUFFERSIZE = "buffersize";
    public static final String CFG_COMMUNICATION_MAXCHANNELS = "maxchannels";
    public static final String CFG_COMMUNICATION_MAXENDPOINTS = "maxendpoints";
    public static final String CFG_COMMUNICATION_ISSECURE = "issecure";
    public static final String CFG_COMMUNICATION_NONPROXYHOSTS = "nonproxyhosts";
    private static final String CONFIG_CLASS_NAMESERVER = "nameserver";
    private static final String CONFIG_CLASS_QUERIES = "queries";
    private static final String CONFIG_CLASS_COMMUNICATION = "communication";
    public static final String SERVER_TYPE_HTTPSERVER = "httpserver";
    public static final String SERVER_TYPE_QUEUESERVER = "queueserver";
    public static final String SERVER_TYPE_INDEXSERVER = "indexserver";
    public static final String CFG_CACHE_MEMORY = "memory";
    public static final String CFG_CACHE_MEMORY_AVERAGEENRYSIZE = "averageentrysize";
    public static final String CFG_CACHE_MEMORY_CAPACITY = "capacity";
    public static final String CFG_CACHE_MEMORY_CLASS = "class";
    public static final String CFG_CACHE_MEMORY_DEFAULTTIMETOLIVE = "defaulttimetolive";
    public static final String CFG_CACHE_MEMORY_MAXENTRYSIZE = "maxentrysize";
    public static final String CFG_CACHE_MEMORY_MAXSIZE = "maxsize";
    public static final String CFG_CACHE_MEMORY_SINGLETON = "singleton";
    public static final String CFG_CACHE_MEMORY_TYPE = "type";
    private static final String LIST_DELIMITER = ", \t\n\r\f";
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$TrexConfigManager == null ? (class$com$sapportals$trex$core$TrexConfigManager = TrexConfigManager.class$("com.sapportals.trex.core.TrexConfigManager")) : class$com$sapportals$trex$core$TrexConfigManager).getName());
    private static TrexConfigManager m_configManager = null;
    private IPropertyStore m_propertyStore = null;
    private Properties m_properties = null;
    private String m_nameServer = null;
    private List m_nameServerList = new ArrayList();
    private HashMap m_cacheCount = new HashMap();
    private boolean m_usejarm = false;
    private boolean m_usecache = false;
    private String m_searchCacheName = "";
    private String m_keystore = "";
    private String m_truststore = "";
    private Properties m_cacheProperties = null;
    private boolean m_issecure = false;
    private boolean m_cacheHttpServer = true;
    private String m_nonProxyHosts = "";
    static /* synthetic */ Class class$com$sapportals$trex$core$TrexConfigManager;

    private TrexConfigManager() throws TrexException {
        PropertyStoreFactory propertyStoreFactory = PropertyStoreFactory.getInstance();
        this.m_propertyStore = propertyStoreFactory.getPropertyStore();
        if (this.m_propertyStore.getClass().getName().equalsIgnoreCase("com.sapportals.trex.util.config.file.PropertyStoreFile")) {
            String strcache;
            String strjarm;
            boolean initLogging;
            String initLoggingStr;
            String tmp;
            this.m_nameServer = this.m_propertyStore.getProperty("nameserver", "address");
            if (this.m_nameServer == null || this.m_nameServer.equals("")) {
                log.errorT("Mandatory Property: nameserver: addressis not set correctly. Try to get a valid nameserver address from back-up-list.");
            }
            if (((tmp = this.m_propertyStore.getProperty("nameserver", CFG_NAMESERVER_BACKUP_LIST)) == null || tmp.equals("")) && (this.m_nameServer == null || this.m_nameServer.equals(""))) {
                log.warningT("Mandatory Property: nameserver: backupserverlist");
                throw new TrexException(7214, "nameserver", "address");
            }
            if (tmp != null) {
                StringTokenizer st = new StringTokenizer(tmp, LIST_DELIMITER);
                while (st.hasMoreTokens()) {
                    this.m_nameServerList.add((String)st.nextElement());
                }
            }
            if ((initLoggingStr = this.getProperty(CFG_SECTION_DEFAULT, CFG_INIT_LOGGING)) != null && (initLogging = Boolean.valueOf(initLoggingStr).booleanValue())) {
                LoggingInitializer loginit = LoggingInitializer.getInstance();
                loginit.registerConfigurationWithDefaultConfigFile();
            }
            if ((strjarm = this.getProperty(CFG_SECTION_DEFAULT, CFG_DEFAULT_JARM)) != null) {
                this.m_usejarm = Boolean.valueOf(strjarm);
            }
            if ((strcache = this.getProperty("queries", CFG_USE_CACHE)) != null) {
                this.m_usecache = Boolean.valueOf(strcache);
            }
            this.m_cacheProperties = this.getProperties("cache");
            try {
                String strissecure = this.getProperty("communication", CFG_COMMUNICATION_ISSECURE);
                if (strissecure != null) {
                    this.m_issecure = Boolean.valueOf(strissecure);
                }
            }
            catch (TrexException e) {
                this.m_issecure = false;
                log.warningT("missing Property: communication: issecure use default : false");
            }
            try {
                String cacheHttpServer = this.getProperty(CFG_SECTION_DEFAULT, CFG_DEFAULT_CACHEHTTPSERVER);
                if (cacheHttpServer != null) {
                    this.m_cacheHttpServer = Boolean.valueOf(cacheHttpServer);
                }
            }
            catch (TrexException e) {
                this.m_cacheHttpServer = true;
                log.warningT("missing Property: default: cachehttpserver use default : true");
            }
        }
    }

    private static TrexConfigManager internalGetInstance() throws TrexException {
        Class clazz = class$com$sapportals$trex$core$TrexConfigManager == null ? (class$com$sapportals$trex$core$TrexConfigManager = TrexConfigManager.class$("com.sapportals.trex.core.TrexConfigManager")) : class$com$sapportals$trex$core$TrexConfigManager;
        synchronized (clazz) {
            if (m_configManager == null) {
                m_configManager = new TrexConfigManager();
            }
            TrexConfigManager trexConfigManager = m_configManager;
            return trexConfigManager;
        }
    }

    public static TrexConfigManager getInstance() throws TrexException {
        return TrexConfigManager.internalGetInstance();
    }

    public Properties getProperties(String section) throws TrexException {
        Properties properties = null;
        properties = this.m_propertyStore.getProperties(section);
        if (properties == null || ((Hashtable)properties).size() == 0) {
            this.removeCacheCount(section, null);
        }
        return properties;
    }

    public String getProperty(String section, String key) throws TrexException {
        String ret = null;
        if (this.m_properties != null) {
            ret = this.m_properties.getProperty(section + "." + key);
        } else {
            if (key == null || section == null) {
                return null;
            }
            key = key.toLowerCase();
            section = section.toLowerCase();
            ret = this.m_propertyStore.getProperty(section, key);
            if (log.beDebug()) {
                log.debugT("Section '" + section + "', property '" + key + "' read from local configuration, value '" + ret + "'");
            }
        }
        return ret;
    }

    public void setProperty(String section, String key, String value) throws TrexException {
        section = section.toLowerCase();
        key = key.toLowerCase();
        String configClass = this.getConfigClassFromSection(section);
        this.m_propertyStore.setProperty(configClass, section, key, value);
    }

    public void setServiceProperties(Properties props) {
        SSLConfigurationManager conf;
        String nonProxyHosts;
        String cacheHttpServer;
        String strUseJarm;
        boolean initLogging;
        String initLoggingStr;
        this.m_properties = props;
        try {
            this.m_propertyStore.setProperties("", "", props);
        }
        catch (TrexException trexEx) {
            log.errorT("PropertyStore cannot be set." + trexEx.getCode() + ":" + trexEx.getMsg());
        }
        this.m_nameServer = props.getProperty("nameserver.address");
        String tmp = null;
        tmp = props.getProperty("nameserver.backupserverlist");
        this.m_nameServerList.clear();
        if (tmp != null) {
            StringTokenizer st = new StringTokenizer(tmp, LIST_DELIMITER);
            while (st.hasMoreTokens()) {
                this.m_nameServerList.add((String)st.nextElement());
            }
        }
        if ((initLoggingStr = props.getProperty("default.initlogging")) != null && (initLogging = Boolean.valueOf(initLoggingStr).booleanValue())) {
            LoggingInitializer loginit = LoggingInitializer.getInstance();
            loginit.registerConfigurationWithDefaultConfigFile();
        }
        if ((strUseJarm = props.getProperty("default.usejarm")) != null) {
            this.m_usejarm = Boolean.valueOf(strUseJarm);
        }
        this.m_cacheProperties = ConfigurationManager.getSubProperties(props, "cache");
        String strcache = props.getProperty("queries.usecache");
        if (strcache != null) {
            this.m_usecache = Boolean.valueOf(strcache);
        }
        this.m_searchCacheName = props.getProperty("queries.cache");
        this.m_truststore = props.getProperty("default.truststore");
        this.m_keystore = props.getProperty("default.keystore");
        CacheManager cm = CacheManager.getInstance();
        WrappedCache cache = null;
        cache = cm.getCache("trexadmin");
        try {
            cache.clearCache();
        }
        catch (Exception e) {
            log.errorT("Error clearing cache 'trexadmin' " + e.getMessage());
        }
        String strissecure = props.getProperty("communication.issecure");
        if (strissecure != null) {
            this.m_issecure = Boolean.valueOf(strissecure);
        }
        if ((cacheHttpServer = props.getProperty("default.cachehttpserver")) != null) {
            this.m_cacheHttpServer = Boolean.valueOf(cacheHttpServer);
        }
        if ((nonProxyHosts = props.getProperty("communication.nonproxyhosts")) != null) {
            this.m_nonProxyHosts = nonProxyHosts;
        }
        m_configManager = this;
        SSLConfigurationManager sSLConfigurationManager = conf = SSLConfigurationManager.getInstance();
        synchronized (sSLConfigurationManager) {
            conf.invalidateCache();
            conf = null;
        }
    }

    public void setProperties(String section, Properties props) throws TrexException {
        section = section.toLowerCase();
        String configClass = this.getConfigClassFromSection(section);
        this.m_propertyStore.setProperties(configClass, section, props);
    }

    public void removeSection(String section) throws TrexException {
        section = section.toLowerCase();
        this.m_propertyStore.removeConfigurable(section);
    }

    public IndexId getIndexId(String indexName) throws TrexException {
        IndexId id = new IndexId();
        id.setIndexName(indexName);
        id.setSearchEngine("DRFUZZY");
        id.setLanguage("EN");
        return id;
    }

    private void removeCacheCount(String section, String key) {
        HashMap hashMap = this.m_cacheCount;
        synchronized (hashMap) {
            this.m_cacheCount.remove(this.getCacheKey(section, key));
        }
    }

    private String getCacheKey(String section, String key) {
        if (key == null) {
            return section;
        }
        return section + '.' + key;
    }

    public static String buildIndexSection(String indexName) {
        return "index." + indexName;
    }

    private String getConfigClassFromSection(String section) {
        if (section.equals("nameserver")) {
            return "nameserver";
        }
        if (section.equals("queries")) {
            return "queries";
        }
        if (section.equals("communication")) {
            return "communication";
        }
        return "";
    }

    public String getMasterNameServer() {
        return this.m_nameServer;
    }

    public List getSlaveNameServers() throws TrexException {
        return this.m_nameServerList;
    }

    public boolean getUseJarm() {
        return this.m_usejarm;
    }

    public boolean getUseCache() {
        return this.m_usecache;
    }

    public String getCacheName() {
        return this.m_searchCacheName;
    }

    public Properties getCacheProperties() {
        return this.m_cacheProperties;
    }

    public String getKeyStore() {
        return this.m_keystore;
    }

    public String getTrustStore() {
        return this.m_truststore;
    }

    public boolean getIsSecure() {
        return this.m_issecure;
    }

    public String getNonProxyHosts() {
        return this.m_nonProxyHosts;
    }

    public synchronized void setNonProxyHostsSysEnv() {
        String nonProxy = this.getNonProxyHosts();
        if (nonProxy != null && !nonProxy.equals("")) {
            this.setNonProxyHostsSysEnv("http.nonProxyHosts", nonProxy);
            this.setNonProxyHostsSysEnv("https.nonProxyHosts", nonProxy);
        }
        Object var1_1 = null;
    }

    private synchronized void setNonProxyHostsSysEnv(String key, String value) {
        String envNonProxyHosts = System.getProperty(key);
        if (envNonProxyHosts != null) {
            log.infoT("current system property: " + key + "= " + envNonProxyHosts);
        }
        String newNonProxyHosts = envNonProxyHosts;
        if (value == null) {
            return;
        }
        if (envNonProxyHosts != null && !envNonProxyHosts.equals("")) {
            if (envNonProxyHosts.indexOf(value) == -1) {
                newNonProxyHosts = newNonProxyHosts + "|" + new String(value);
            }
        } else {
            newNonProxyHosts = new String(value);
        }
        try {
            if (newNonProxyHosts != null) {
                log.infoT("try to set: " + key + "= " + newNonProxyHosts);
                System.setProperty(key, newNonProxyHosts);
            }
        }
        catch (SecurityException ex) {
            log.errorT("environment cannot be set for: " + key + "= " + newNonProxyHosts + "because following exception caught: " + ex.getMessage());
        }
        newNonProxyHosts = null;
        Object var3_3 = null;
    }

    public boolean getCacheHttpServer() {
        return this.m_cacheHttpServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

