/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractTextMining;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.CompleteTerm;
import com.sapportals.trex.core.CompleteTerms;
import com.sapportals.trex.core.HttpTextMining;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.RelatedTerm;
import com.sapportals.trex.core.RelatedTerms;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.ResultElement;
import com.sapportals.trex.core.SearchDocument;
import com.sapportals.trex.core.SearchTerm;
import com.sapportals.trex.core.SimilarSearchResult;
import com.sapportals.trex.core.SortAttribute;
import com.sapportals.trex.core.TMRequestParser;
import com.sapportals.trex.core.TextMiningResult;
import com.sapportals.trex.core.TextMiningResultContainer;
import com.sapportals.trex.core.ThesaurusRelation;
import com.sapportals.trex.core.ThesaurusRole;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import com.sapportals.trex.util.cache.CacheManager;
import com.sapportals.trex.util.cache.WrappedCache;
import com.sapportals.trex.util.cache.WrappedCacheEntry;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TextMiningManager
extends BaseManager {
    public static final String CLASSIFICATION_METHOD_KNN = "KNN";
    public static final String CLASSIFICATION_METHOD_CENTROID = "CENTROID";
    public static final String CLASSIFICATION_METHOD_SAPMETHOD = "SAPMETHOD";
    public static final byte CLUSTERING_METHOD_GROUPAVERAGE = 1;
    public static final byte CLUSTERING_METHOD_STAR = 2;
    public static final byte CLUSTERING_METHOD_HYPERLINKSTAR = 3;
    public static final byte CLUSTERING_METHOD_KMEANS = 4;
    public static final byte CLUSTERING_METHOD_SINGLELINK = 5;
    public static final byte CLUSTERING_METHOD_COMPLETELINK = 6;
    public static final byte CLASSIFICATION_TYPE_UNDEFINED = 0;
    public static final byte CLASSIFICATION_TYPE_QUERY_BASED = 1;
    public static final byte CLASSIFICATION_TYPE_EXAMPLE_BASED = 2;
    public static final byte CLASSIFICATION_TYPE_BOTH = 3;
    public static final byte DOCUMENT_SIMILARITY_CONTENT = 1;
    public static final byte DOCUMENT_SIMILARITY_COCITATION = 2;
    public static final byte DOCUMENT_SIMILARITY_EXTENDEDCOCITATION = 3;
    public static final String TERM_WEIGHT_METHOD_TFIDF = "TFIDF";
    public static final String TERM_WEIGHT_METHOD_LTFIDF = "LTFIDF";
    public static byte TREX_MINING_REQUEST_FEATURES = 1;
    public static byte TREX_MINING_REQUEST_CONTENTSNIPPETS = (byte)2;
    public static byte TREX_MINING_REQUEST_TITLESNIPPET = (byte)4;
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$TextMiningManager == null ? (class$com$sapportals$trex$core$TextMiningManager = TextMiningManager.class$("com.sapportals.trex.core.TextMiningManager")) : class$com$sapportals$trex$core$TextMiningManager).getName());
    private List attributeList = new ArrayList();
    private List docList = new ArrayList();
    private List classList = new ArrayList();
    private List searchIndexList = new ArrayList();
    private List termList = new ArrayList();
    private List sortAttributes = new ArrayList();
    private List relations = new ArrayList();
    private int to;
    private int from;
    private float threshold = 0.0f;
    private String m_httpserverurl;
    private boolean m_httpserverManuallySet = false;
    private SearchTerm termId;
    private String classificationMethod = null;
    private String classifyAttribute;
    private Byte classificationType = null;
    private boolean m_useKeywords = false;
    private byte clusteringMethod = (byte)4;
    private byte documentSimilarityMethod = 1;
    private String clusteringAttribute = null;
    private String m_pattern = null;
    private String m_documentSelectionQuery = null;
    private List m_highlightAttributes = null;
    private byte m_requestFlags;
    private int m_maxSnippetWords;
    private static final int METHOD_SIMILAR_DOCS = 1;
    private static final int METHOD_SIMILAR_TERMS = 2;
    private static final int METHOD_SIMILAR_CLASSES = 3;
    private static final int METHOD_CLASSIFY_DOCS = 4;
    private static final int METHOD_DOC_FEATURES = 5;
    private static final int METHOD_CLASS_FEATURES = 6;
    private static final int METHOD_CALCULATE_CLUSTERS = 7;
    private static final int METHOD_GET_TERM_IDS = 8;
    private static final int METHOD_GET_THESAURUS_TERMS = 9;
    private static final int METHOD_DOCUMENT_LANGUAGE = 10;
    static /* synthetic */ Class class$com$sapportals$trex$core$TextMiningManager;
    static /* synthetic */ Class class$com$sapportals$trex$core$SearchManager;

    public void setThreshold(float threshold_) throws TrexException {
        this.threshold = threshold_;
    }

    protected float getThreshold() throws TrexException {
        return this.threshold;
    }

    public void setLanguage(String language) throws TrexException {
    }

    public void addIndexId(String indexName, String language) throws TrexException {
        IndexId indexId = new IndexId();
        indexId.setIndexName(indexName);
        indexId.setLanguage(language);
        indexId.setSearchEngine("DRFUZZY");
        this.searchIndexList.add(indexId);
    }

    public void addIndexId(String indexName, String searchEngine, String language, String mode, String host, int port, String file) throws TrexException {
        IndexId indexId = new IndexId();
        indexId.setIndexName(indexName, searchEngine, language);
        if (mode.equals("http") || mode.equals("https")) {
            indexId.setHttpServerUrl(mode, host, port, file);
        }
        this.searchIndexList.add(indexId);
        if (log.beDebug()) {
            log.debugT("Index '" + indexName + "': parameters were set manually to mode '" + mode + "', host '" + host + "', port '" + port + "', file '" + file + "', search engine '" + searchEngine + "', language '" + language + "'");
        }
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
        this.m_httpserverManuallySet = true;
    }

    public void setResultFromTo(int from, int to) throws TrexException {
        if (from < 1) {
            from = 1;
        }
        this.from = from;
        this.to = to;
    }

    public void setMaxResults(int max) throws TrexException {
        if (this.from < 1) {
            this.from = 1;
        }
        this.to = this.from + max - 1;
    }

    public void addSearchDocument(SearchDocument document) throws TrexException {
        this.docList.add(document);
    }

    public void addSearchTerm(String term, float weight) throws TrexException {
        this.termList.add(new SearchTerm(term, weight));
    }

    public void setResultTermPattern(String pattern) {
        this.m_pattern = pattern;
    }

    public void addSearchClass(String searchClass) throws TrexException {
        this.classList.add(searchClass);
    }

    public void addSortAttribute(String name, boolean sortAscending) throws TrexException {
        this.sortAttributes.add(new SortAttribute(name, sortAscending));
    }

    public void addRequestedAttribute(String name) throws TrexException {
        this.attributeList.add(name);
    }

    public void setClassifyAttribute(String classifyAttribute) throws TrexException {
        this.classifyAttribute = classifyAttribute;
    }

    public void setClassificationMethod(String method) throws TrexException {
        this.classificationMethod = method;
    }

    public void setClassificationType(byte type) throws TrexException {
        this.classificationType = new Byte(type);
    }

    public void setTermWeightMethod(String method) throws TrexException {
    }

    public void setDocumentSelectionQuery(String query) throws TrexException {
        this.m_documentSelectionQuery = query;
    }

    public void setUseKeywords(boolean useKeywords) throws TrexException {
        this.m_useKeywords = useKeywords;
    }

    public void setMaxSnippetWords(int maxWords) {
        this.m_maxSnippetWords = maxWords;
    }

    protected int getMaxSnippetWords() {
        return this.m_maxSnippetWords;
    }

    public void setRequestFlag(byte requestFlag, boolean value) {
        this.m_requestFlags = value ? (byte)(this.m_requestFlags | requestFlag) : (byte)(this.m_requestFlags & (0xFFFFFFFF & ~requestFlag));
    }

    protected boolean getRequestFlag(byte requestFlag) {
        return (this.m_requestFlags & requestFlag) > 0;
    }

    public void addHighlightAttribute(String name) throws TrexException {
        if (this.m_highlightAttributes == null) {
            this.m_highlightAttributes = new ArrayList();
        }
        this.m_highlightAttributes.add(name);
    }

    public SimilarSearchResult searchSimilarDocuments() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:SIMIDOC");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            SimilarSearchResult result = null;
            result = this.searchSimilarDocumentsOnOneServer(this.searchIndexList);
            if (log.beDebug()) {
                log.debugT("Error code: " + result.getErrorCode().getCode() + ", message: " + result.getErrorCode().getMsg());
                ResultDocument doc = result.getFirstResultDocument();
                int i = 0;
                while (i < result.size()) {
                    log.debugT("Result document " + i + ": " + doc.getDocumentKey() + ", rank value: " + doc.getRankValue());
                    doc = result.getNextResultDocument();
                    ++i;
                }
            }
            SimilarSearchResult similarSearchResult = result;
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:TM:SIMIDOC");
            monitor.endRequest();
            monitor = null;
            return similarSearchResult;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:TM:SIMIDOC");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResult getDocumentFeatures() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:DOCFEAT");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            mining.setMaxResults(this.to - this.from + 1);
            mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
            mining.addSearchDocuments(this.docList);
            TextMiningResult result = null;
            boolean cacheEnabled = false;
            String resultKey = "";
            WrappedCache cache = this.getCache();
            if (cache != null && (resultKey = this.getStringRepresentation(mining, 5)) != null) {
                cacheEnabled = true;
            }
            boolean executeSearch = true;
            if (cacheEnabled) {
                try {
                    WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                    result = (TextMiningResult)cacheEntry.getObject();
                }
                catch (Exception e) {
                    result = null;
                }
                if (result == null) {
                    executeSearch = true;
                    log.debugT("Document feature result not in cache");
                } else {
                    executeSearch = false;
                    log.debugT("Document feature result found in cache");
                }
            }
            if (executeSearch) {
                if (log.beInfo()) {
                    log.infoT("Document feature search started (search index '" + searchIndex.getIndexName() + "')");
                }
                if ((result = mining.getDocumentFeatures()) != null) {
                    monitor.compAction("EP:KM:TREX:TM:DOCFEAT", "number of documents: " + result.size());
                }
                log.infoT("Document feature search finished");
                if (cacheEnabled) {
                    try {
                        cache.addEntry(resultKey, result);
                        log.debugT("Document feature result is added to cache");
                    }
                    catch (Exception e) {
                        log.debugT("Document feature result could not be added to cache. Reason: " + e.getMessage());
                    }
                }
                if (log.beDebug() && result != null) {
                    log.debugT("Number of documents returned: " + result.size());
                }
            }
            this.logTextMiningResult(result);
            TextMiningResult textMiningResult = result;
            Object var11_12 = null;
            monitor.endComponent("EP:KM:TREX:TM:DOCFEAT");
            monitor.endRequest();
            monitor = null;
            return textMiningResult;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.endComponent("EP:KM:TREX:TM:DOCFEAT");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResultContainer searchSimilarTerms() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        TextMiningResultContainer result = null;
        try {
            monitor.startComponent("EP:KM:TREX:TM:SIMITERM");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            result = this.searchSimilarTermsOnOneServer(this.searchIndexList);
            if (log.beDebug()) {
                log.debugT("Error code: " + result.getErrorCode().getCode() + ", message: " + result.getErrorCode().getMsg());
                ResultElement element = result.getFirstElement();
                int i = 0;
                while (i < result.size()) {
                    log.debugT("Result term " + i + ": " + element.getName() + ", rank value: " + element.getRankValue());
                    element = result.getNextElement();
                    ++i;
                }
            }
            TextMiningResultContainer textMiningResultContainer = result;
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:TM:SIMITERM");
            monitor.endRequest();
            monitor = null;
            return textMiningResultContainer;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:TM:SIMITERM");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResult classifyDocuments() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:CLASSIFY");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            mining.setMaxResults(this.to - this.from + 1);
            mining.setThreshold(this.threshold);
            mining.setClassificationMethod(this.classificationMethod);
            mining.setClassificationType(this.classificationType);
            mining.setClassifyAttribute(this.classifyAttribute);
            mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
            mining.setUseKeywords(this.m_useKeywords);
            mining.addSearchDocuments(this.docList);
            TextMiningResult result = null;
            if (log.beInfo()) {
                log.infoT("Classification started (search index '" + searchIndex.getIndexName() + "')");
            }
            result = mining.classifyDocuments();
            log.infoT("Classification finished");
            if (log.beDebug() && result != null) {
                log.debugT("Number of documents returned: " + result.size());
            }
            this.logTextMiningResult(result);
            TextMiningResult textMiningResult = result;
            Object var7_6 = null;
            monitor.endComponent("EP:KM:TREX:TM:CLASSIFY");
            monitor.endRequest();
            monitor = null;
            return textMiningResult;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.endComponent("EP:KM:TREX:TM:CLASSIFY");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResult searchSimilarClasses() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:SIMICL");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            mining.setMaxResults(this.to - this.from + 1);
            mining.setThreshold(this.threshold);
            mining.setClassifyAttribute(this.classifyAttribute);
            mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
            mining.setUseKeywords(this.m_useKeywords);
            mining.addSearchClasses(this.classList);
            TextMiningResult result = null;
            boolean cacheEnabled = false;
            String resultKey = "";
            WrappedCache cache = this.getCache();
            if (cache != null && (resultKey = this.getStringRepresentation(mining, 3)) != null) {
                cacheEnabled = true;
            }
            boolean executeSearch = true;
            if (cacheEnabled) {
                try {
                    WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                    result = (TextMiningResult)cacheEntry.getObject();
                }
                catch (Exception e) {
                    result = null;
                }
                if (result == null) {
                    executeSearch = true;
                    log.debugT("Similar class search result not in cache");
                } else {
                    executeSearch = false;
                    log.debugT("Similar class search result found in cache");
                }
            }
            if (executeSearch) {
                if (log.beInfo()) {
                    log.infoT("Similar class search started (search index '" + searchIndex.getIndexName() + "')");
                }
                result = mining.searchSimilarClasses();
                log.infoT("Similar class search finished");
                if (cacheEnabled) {
                    try {
                        cache.addEntry(resultKey, result);
                        log.debugT("Similar class search result is added to cache");
                    }
                    catch (Exception e) {
                        log.debugT("Similar class search result could not be added to cache. Reason: " + e.getMessage());
                    }
                }
            }
            this.logTextMiningResult(result);
            TextMiningResult textMiningResult = result;
            Object var11_12 = null;
            monitor.endComponent("EP:KM:TREX:TM:SIMICL");
            monitor.endRequest();
            monitor = null;
            return textMiningResult;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.endComponent("EP:KM:TREX:TM:SIMICL");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResult getClassFeatures() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:CLFEAT");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            mining.setMaxResults(this.to - this.from + 1);
            mining.setClassifyAttribute(this.classifyAttribute);
            mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
            mining.setUseKeywords(this.m_useKeywords);
            mining.addSearchClasses(this.classList);
            TextMiningResult result = null;
            boolean cacheEnabled = false;
            String resultKey = "";
            WrappedCache cache = this.getCache();
            if (cache != null && (resultKey = this.getStringRepresentation(mining, 6)) != null) {
                cacheEnabled = true;
            }
            boolean executeSearch = true;
            if (cacheEnabled) {
                try {
                    WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                    result = (TextMiningResult)cacheEntry.getObject();
                }
                catch (Exception e) {
                    result = null;
                }
                if (result == null) {
                    executeSearch = true;
                    log.debugT("Class feature result not in cache");
                } else {
                    executeSearch = false;
                    log.debugT("Class feature result found in cache");
                }
            }
            if (executeSearch) {
                if (log.beInfo()) {
                    log.infoT("Class feature search started (search index '" + searchIndex.getIndexName() + "')");
                }
                result = mining.getClassFeatures();
                log.infoT("Class feature search finished");
                if (cacheEnabled) {
                    try {
                        cache.addEntry(resultKey, result);
                        log.debugT("Class feature result is added to cache");
                    }
                    catch (Exception e) {
                        log.debugT("Class feature result could not be added to cache. Reason: " + e.getMessage());
                    }
                }
                if (log.beDebug() && result != null) {
                    log.debugT("Number of classes returned: " + result.size());
                }
            }
            this.logTextMiningResult(result);
            TextMiningResult textMiningResult = result;
            Object var11_12 = null;
            monitor.endComponent("EP:KM:TREX:TM:CLFEAT");
            monitor.endRequest();
            monitor = null;
            return textMiningResult;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.endComponent("EP:KM:TREX:TM:CLFEAT");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResult calculateClusters() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:CLUSTER");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            mining.setMaxResults(this.to - this.from + 1);
            mining.setThreshold(this.threshold);
            mining.setClusteringMethod(this.clusteringMethod);
            mining.setClusteringAttribute(this.clusteringAttribute);
            mining.setDocumentSimilarityMethod(this.documentSimilarityMethod);
            mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
            mining.addSearchDocuments(this.docList);
            TextMiningResult result = null;
            boolean cacheEnabled = false;
            String resultKey = "";
            WrappedCache cache = this.getCache();
            if (cache != null && (resultKey = this.getStringRepresentation(mining, 7)) != null) {
                cacheEnabled = true;
            }
            boolean executeSearch = true;
            if (cacheEnabled) {
                try {
                    WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                    result = (TextMiningResult)cacheEntry.getObject();
                }
                catch (Exception e) {
                    result = null;
                }
                if (result == null) {
                    executeSearch = true;
                    log.debugT("Clustering result not in cache");
                } else {
                    executeSearch = false;
                    log.debugT("Clustering result found in cache");
                }
            }
            if (executeSearch) {
                if (log.beInfo()) {
                    log.infoT("Clustering started (search index '" + searchIndex.getIndexName() + "')");
                }
                result = mining.calculateClusters();
                log.infoT("Clustering finished");
                if (cacheEnabled) {
                    try {
                        cache.addEntry(resultKey, result);
                        log.debugT("Clustering result is added to cache");
                    }
                    catch (Exception e) {
                        log.debugT("Clustering result could not be added to cache. Reason: " + e.getMessage());
                    }
                }
                if (log.beDebug() && result != null) {
                    log.debugT("Number of clusters: " + result.size());
                }
            }
            this.logTextMiningResult(result);
            TextMiningResult textMiningResult = result;
            Object var11_12 = null;
            monitor.endComponent("EP:KM:TREX:TM:CLUSTER");
            monitor.endRequest();
            monitor = null;
            return textMiningResult;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.endComponent("EP:KM:TREX:TM:CLUSTER");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void addThesaurusRole(String relation, String role, float weight) {
        int i = 0;
        while (i < this.relations.size()) {
            ThesaurusRelation rel = (ThesaurusRelation)this.relations.get(i);
            if (rel.getName().equals(relation)) {
                rel.addRole(new ThesaurusRole(role, weight));
                return;
            }
            ++i;
        }
        log.infoT("Relation for role not found");
    }

    public void addThesaurusRelation(String relation, float weight) {
        this.relations.add(new ThesaurusRelation(relation, weight));
    }

    public void setTermId(String term, float weight) {
        this.termId = new SearchTerm(term, weight);
    }

    public RelatedTerms getThesaurusTerms() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:THESAUR");
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            if (this.to > 0) {
                mining.setMaxResults(this.to - this.from + 1);
            }
            mining.setTermId(this.termId);
            mining.addThesaurusRelations(this.relations);
            RelatedTerms result = null;
            boolean cacheEnabled = false;
            String resultKey = "";
            WrappedCache cache = this.getCache();
            if (cache != null && (resultKey = this.getStringRepresentation(mining, 9)) != null) {
                cacheEnabled = true;
            }
            boolean executeSearch = true;
            if (cacheEnabled) {
                try {
                    WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                    result = (RelatedTerms)cacheEntry.getObject();
                }
                catch (Exception e) {
                    result = null;
                }
                if (result == null) {
                    executeSearch = true;
                    log.debugT("Thesaurus result not in cache");
                } else {
                    executeSearch = false;
                    log.debugT("Thesaurus result found in cache");
                }
            }
            if (executeSearch) {
                if (log.beInfo()) {
                    if (this.termId == null) {
                        log.infoT("Thesaurus search started (term: 'null')");
                    } else {
                        log.infoT("Thesaurus search started (term: '" + this.termId.getTerm() + "')");
                    }
                }
                result = mining.getThesaurusTerms();
                log.infoT("Thesaurus search finished");
                if (cacheEnabled) {
                    try {
                        cache.addEntry(resultKey, result);
                        log.debugT("Thesaurus result is added to cache");
                    }
                    catch (Exception e) {
                        log.debugT("Thesaurus result could not be added to cache. Reason: " + e.getMessage());
                    }
                }
            }
            if (log.beDebug()) {
                log.debugT("Error code: " + result.getErrorCode().getCode() + ", message: " + result.getErrorCode().getMsg());
                RelatedTerm entry = result.getFirstEntry();
                while (entry != null) {
                    log.debugT("Term ID: " + entry.getId() + ", term name: " + entry.getTermName());
                    entry = result.getNextEntry();
                }
            }
            RelatedTerms relatedTerms = result;
            Object var11_12 = null;
            monitor.endComponent("EP:KM:TREX:TM:THESAUR");
            monitor.endRequest();
            monitor = null;
            return relatedTerms;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.endComponent("EP:KM:TREX:TM:THESAUR");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public CompleteTerms getTermIds() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:TERMIDS");
            CompleteTerms result = null;
            if (this.searchIndexList.isEmpty()) {
                throw new TrexException(7230);
            }
            IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
            if (this.searchIndexList.size() > 1) {
                log.errorT("Action cannot be executed on more than one index; only first index is taken");
            }
            AbstractTextMining mining = this.getTextMiningObject();
            mining.addIndexId(searchIndex);
            mining.addSearchTerms(this.termList);
            boolean cacheEnabled = false;
            String resultKey = "";
            WrappedCache cache = this.getCache();
            if (cache != null && (resultKey = this.getStringRepresentation(mining, 8)) != null) {
                cacheEnabled = true;
            }
            boolean executeSearch = true;
            if (cacheEnabled) {
                try {
                    WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                    result = (CompleteTerms)cacheEntry.getObject();
                }
                catch (Exception e) {
                    result = null;
                }
                if (result == null) {
                    executeSearch = true;
                    log.debugT("TermId result not in cache");
                } else {
                    executeSearch = false;
                    log.debugT("TermId result found in cache");
                }
            }
            if (executeSearch) {
                if (log.beInfo()) {
                    String termName = ((SearchTerm)this.termList.get(0)).getTerm();
                    if (termName == null) {
                        log.infoT("TermId search started (termName: 'null')");
                    } else {
                        log.infoT("TermId search started (termName: '" + termName + "')");
                    }
                }
                result = mining.getTermIds();
                log.infoT("TermId search finished");
                if (cacheEnabled) {
                    try {
                        cache.addEntry(resultKey, result);
                        log.debugT("TermId result is added to cache");
                    }
                    catch (Exception e) {
                        log.debugT("TermId result could not be added to cache. Reason: " + e.getMessage());
                    }
                }
            }
            if (log.beDebug()) {
                log.debugT("Error code: " + result.getErrorCode().getCode() + ", message: " + result.getErrorCode().getMsg());
                CompleteTerm completeTerm = result.getFirstTerm();
                while (completeTerm != null) {
                    log.debugT("Term id: " + completeTerm.getTermId() + ", term name: " + completeTerm.getTermName());
                    completeTerm = result.getNextTerm();
                }
            }
            CompleteTerms completeTerms = result;
            Object var11_12 = null;
            monitor.endComponent("EP:KM:TREX:TM:TERMIDS");
            monitor.endRequest();
            monitor = null;
            return completeTerms;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.endComponent("EP:KM:TREX:TM:TERMIDS");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void setTermName(String termName_) {
        this.termList.add(new SearchTerm(termName_, 1.0f));
    }

    public void setDocumentSimilarityMethod(byte method) {
        this.documentSimilarityMethod = method;
    }

    public void setClusteringMethod(byte method) {
        this.clusteringMethod = method;
    }

    public void setClusteringAttribute(String clusteringAttribute) {
        this.clusteringAttribute = clusteringAttribute;
    }

    public TextMiningResult getDocumentLanguage() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TM:LANG");
            AbstractTextMining mining = this.getTextMiningObject();
            mining.setHttpServerManuallySet(this.m_httpserverManuallySet);
            mining.addSearchDocuments(this.docList);
            TextMiningResult textMiningResult = mining.getDocumentLanguage();
            Object var5_4 = null;
            monitor.endComponent("EP:KM:TREX:TM:LANG");
            monitor.endRequest();
            monitor = null;
            return textMiningResult;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.endComponent("EP:KM:TREX:TM:LANG");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public TextMiningResult trexCommand(String trexCommand) throws TrexException {
        if (this.searchIndexList.isEmpty()) {
            throw new TrexException(7230);
        }
        IndexId searchIndex = (IndexId)this.searchIndexList.get(0);
        if (this.searchIndexList.size() > 1) {
            log.errorT("Action cannot be executed on more than one index; only first index is taken");
        }
        AbstractTextMining mining = this.getTextMiningObject();
        mining.addIndexId(searchIndex);
        mining.setHttpServerManuallySet(this.m_httpserverManuallySet);
        log.infoT("TrexCommand started (search index '" + searchIndex.getIndexName() + "')");
        TextMiningResult result = mining.trexCommand(trexCommand);
        log.infoT("TrexCommand finished");
        return result;
    }

    private SimilarSearchResult searchSimilarDocumentsOnOneServer(List indexIds) throws TrexException {
        AbstractTextMining mining = this.getTextMiningObject();
        mining.addIndexIds(indexIds);
        mining.addRequestedAttributes(this.attributeList);
        mining.addSearchDocuments(this.docList);
        mining.addSortAttributes(this.sortAttributes);
        mining.addHighlightAttributes(this.m_highlightAttributes);
        mining.setMaxResults(this.to - this.from + 1);
        mining.setResultFromTo(this.from, this.to);
        mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
        mining.setRequestFlags(this.m_requestFlags);
        mining.setMaxSnippetWords(this.m_maxSnippetWords);
        SimilarSearchResult newResult = null;
        boolean cacheEnabled = false;
        String resultKey = "";
        WrappedCache cache = this.getCache();
        if (cache != null && (resultKey = this.getStringRepresentation(mining, 1)) != null) {
            cacheEnabled = true;
        }
        boolean executeSearch = true;
        if (cacheEnabled) {
            try {
                WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                newResult = (SimilarSearchResult)cacheEntry.getObject();
            }
            catch (Exception e) {
                newResult = null;
            }
            if (newResult == null) {
                executeSearch = true;
                log.debugT("Similar document search result not in cache");
            } else {
                executeSearch = false;
                log.debugT("Similar document search result found in cache");
            }
        }
        if (executeSearch) {
            if (log.beInfo()) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < indexIds.size()) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append("'");
                    sb.append(((IndexId)indexIds.get(i)).getIndexName());
                    sb.append("'");
                    ++i;
                }
                log.infoT("Similar document search started (search index " + sb.toString() + ")");
            }
            newResult = mining.searchSimilarDocuments();
            log.infoT("Similar document search finished");
            if (cacheEnabled) {
                try {
                    cache.addEntry(resultKey, newResult);
                    log.debugT("Similar document search result is added to cache");
                }
                catch (Exception e) {
                    log.debugT("Similar document search result could not be added to cache. Reason: " + e.getMessage());
                }
            }
            if (log.beDebug() && newResult != null) {
                log.debugT("Number of documents found: " + newResult.size());
            }
        }
        return newResult;
    }

    private TextMiningResultContainer searchSimilarTermsOnOneServer(List indexIds) throws TrexException {
        AbstractTextMining mining = this.getTextMiningObject();
        mining.addIndexIds(indexIds);
        mining.setHttpServerManuallySet(this.m_httpserverManuallySet);
        mining.addSearchTerms(this.termList);
        mining.setMaxResults(this.to - this.from + 1);
        mining.setResultTermPattern(this.m_pattern);
        mining.setDocumentSelectionQuery(this.m_documentSelectionQuery);
        TextMiningResultContainer newResult = null;
        boolean cacheEnabled = false;
        String resultKey = "";
        WrappedCache cache = this.getCache();
        if (cache != null && (resultKey = this.getStringRepresentation(mining, 2)) != null) {
            cacheEnabled = true;
        }
        boolean executeSearch = true;
        if (cacheEnabled) {
            try {
                WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                newResult = (TextMiningResultContainer)cacheEntry.getObject();
            }
            catch (Exception e) {
                newResult = null;
            }
            if (newResult == null) {
                executeSearch = true;
                log.debugT("Similar term search result not in cache");
            } else {
                executeSearch = false;
                log.debugT("Similar term search result found in cache");
            }
        }
        if (executeSearch) {
            if (log.beInfo()) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < indexIds.size()) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append("'");
                    sb.append(((IndexId)indexIds.get(i)).getIndexName());
                    sb.append("'");
                    ++i;
                }
                log.infoT("Similar term search started (search index " + sb.toString() + ")");
            }
            newResult = mining.searchSimilarTerms();
            log.infoT("Similar term search finished");
            if (cacheEnabled) {
                try {
                    cache.addEntry(resultKey, newResult);
                    log.debugT("Similar term search result is added to cache");
                }
                catch (Exception e) {
                    log.debugT("Similar term search result could not be added to cache. Reason: " + e.getMessage());
                }
            }
            if (log.beDebug() && newResult != null) {
                log.debugT("Number of terms found: " + newResult.size());
            }
        }
        return newResult;
    }

    private AbstractTextMining getTextMiningObject() throws TrexException {
        HttpTextMining httpmining = new HttpTextMining();
        httpmining.setTicket(this.m_ticket);
        httpmining.setIndexUser(this.m_indexUser);
        httpmining.setHttpServerManuallySet(this.m_httpserverManuallySet);
        if (this.m_httpserverManuallySet) {
            httpmining.setHttpServerManuallySet(this.m_httpserverManuallySet);
            try {
                httpmining.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException ex) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        httpmining.setSSLData(this.m_keystore, this.m_truststore);
        return httpmining;
    }

    private String getXMLOfSimilarDocuments() {
        String str = null;
        try {
            str = this.getXML(1);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfSimilarDocuments: " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfCalculateClusters() {
        String str = null;
        try {
            str = this.getXML(7);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfCalculateClusters(): " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfClassifyDocuments() {
        String str = null;
        try {
            str = this.getXML(4);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfClassifyDocuments: " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfDocumentFeatures() {
        String str = null;
        try {
            str = this.getXML(5);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfDocumentFeatures: " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfClassFeatures() {
        String str = null;
        try {
            str = this.getXML(6);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfClassFeatures: " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfSimilarClasses() {
        String str = null;
        try {
            str = this.getXML(3);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfSimilarClasses: " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfSimilarTerms() {
        String str = null;
        try {
            str = this.getXML(2);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfSimilarTerms: " + e.getMessage());
            return null;
        }
        return str;
    }

    private String getXMLOfThesaurusTerms() {
        String str = null;
        try {
            str = this.getXML(9);
        }
        catch (TrexException e) {
            log.errorT("Error in getXMLOfThesaurusTerms: " + e.getMessage());
            return null;
        }
        return str;
    }

    private void setXML(String xml) throws TrexException {
        TMRequestParser parser = null;
        try {
            parser = new TMRequestParser(this);
        }
        catch (ParserConfigurationException e1) {
            throw new TrexException(7268, "TMRequestParser");
        }
        catch (SAXException e2) {
            throw new TrexException(7268, "TMRequestParser");
        }
        try {
            parser.parse(xml);
        }
        catch (SAXException e1) {
            throw new TrexException(7269, (class$com$sapportals$trex$core$SearchManager == null ? (class$com$sapportals$trex$core$SearchManager = TextMiningManager.class$("com.sapportals.trex.core.SearchManager")) : class$com$sapportals$trex$core$SearchManager).getName(), "TMRequestParser");
        }
        catch (IOException e2) {
            throw new TrexException(7269, (class$com$sapportals$trex$core$SearchManager == null ? (class$com$sapportals$trex$core$SearchManager = TextMiningManager.class$("com.sapportals.trex.core.SearchManager")) : class$com$sapportals$trex$core$SearchManager).getName(), "TMRequestParser");
        }
    }

    private WrappedCache getCache() throws TrexException {
        TrexConfigManager conf = TrexFactory.getTrexConfigManager();
        CacheManager cm = CacheManager.getInstance();
        WrappedCache cache = null;
        if (conf == null) {
            log.debugT("TrexConfigurationManager could not be initialized");
        } else if (cm != null) {
            boolean useCache = conf.getUseCache();
            if (useCache) {
                String cacheName = conf.getCacheName();
                if (cacheName == null) {
                    cache = null;
                    log.debugT("CacheManager not configured");
                } else {
                    cache = cm.getCache(cacheName);
                }
            } else {
                cache = null;
                log.debugT("Cache is switched off");
            }
        }
        if (cache == null) {
            log.debugT("CacheManager not loaded, all results are uncached");
        }
        return cache;
    }

    private void logTextMiningResult(TextMiningResult result) {
        if (log.beDebug()) {
            log.debugT("Error code: " + result.getErrorCode().getCode() + ", message: " + result.getErrorCode().getMsg());
            TextMiningResultContainer container = result.getFirstContainer();
            int j = 0;
            while (j < result.size()) {
                log.debugT("Container " + j + ": " + container.getKey());
                ResultElement element = container.getFirstElement();
                int i = 0;
                while (i < container.size()) {
                    log.debugT("Element " + i + ": " + element.getName() + ", rank value: " + element.getRankValue());
                    element = container.getNextElement();
                    ++i;
                }
                ResultElement property = container.getFirstProperty();
                int i2 = 0;
                while (i2 < container.countProperties()) {
                    log.debugT("Property " + i2 + ": " + property.getName() + ", rank value: " + property.getRankValue());
                    property = container.getNextProperty();
                    ++i2;
                }
                container = result.getNextContainer();
                ++j;
            }
        }
    }

    void transferData(List indexList, AbstractTextMining mining) throws TrexException {
        mining.addIndexIds(indexList);
        this.transferAllDataWithoutIndex(mining);
    }

    AbstractTextMining transferDataWithAllIndexes(TextMiningManager manager) throws TrexException {
        AbstractTextMining mining = manager.getTextMiningObject();
        mining.addIndexIds(this.searchIndexList);
        this.transferAllDataWithoutIndex(mining);
        return mining;
    }

    private void transferAllDataWithoutIndex(AbstractTextMining mining) throws TrexException {
        mining.setMaxResults(this.to - this.from + 1);
        mining.setResultFromTo(this.from, this.to);
        mining.setThreshold(this.threshold);
        mining.setClassificationMethod(this.classificationMethod);
        mining.setClassificationType(this.classificationType);
        mining.setClassifyAttribute(this.classifyAttribute);
        mining.setTermId(this.termId);
        mining.setClusteringAttribute(this.clusteringAttribute);
        mining.setClusteringMethod(this.clusteringMethod);
        mining.setDocumentSimilarityMethod(this.documentSimilarityMethod);
        mining.addRequestedAttributes(this.attributeList);
        mining.addSearchClasses(this.classList);
        mining.addSearchTerms(this.termList);
        mining.addSearchDocuments(this.docList);
        mining.addThesaurusRelations(this.relations);
        mining.addSortAttributes(this.sortAttributes);
    }

    private String getStringRepresentation(AbstractTextMining mining, int method) {
        String ret = null;
        StringBuffer sbuf = null;
        sbuf = this.getXMLAsStringBuffer(mining, method);
        if (sbuf != null && sbuf.length() != 0) {
            this.addServerToXML(sbuf, mining);
            ret = sbuf.toString();
        }
        return ret;
    }

    private String getXML(int method) throws TrexException {
        String ret = null;
        AbstractTextMining mining = this.getTextMiningObject();
        mining.addIndexIds(this.searchIndexList);
        this.transferAllDataWithoutIndex(mining);
        StringBuffer sbuf = this.getXMLAsStringBuffer(mining, method);
        if (sbuf != null) {
            ret = sbuf.toString();
        }
        return ret;
    }

    private StringBuffer getXMLAsStringBuffer(AbstractTextMining mining, int method) {
        StringBuffer ret = null;
        StringWriter stringWriter = new StringWriter();
        XMLWriter w = new XMLWriter();
        if (w != null) {
            w.setOutput(stringWriter);
            try {
                switch (method) {
                    case 1: {
                        mining.formatSearchSimilarDocumentsRequest(w);
                        break;
                    }
                    case 2: {
                        mining.formatSearchSimilarTermsRequest(w);
                        break;
                    }
                    case 3: {
                        mining.formatSearchSimilarClassesRequest(w);
                        break;
                    }
                    case 4: {
                        mining.formatClassifyDocumentsRequest(w);
                        break;
                    }
                    case 5: {
                        mining.formatGetDocumentFeaturesRequest(w);
                        break;
                    }
                    case 6: {
                        mining.formatGetClassFeaturesRequest(w);
                        break;
                    }
                    case 7: {
                        mining.formatCalculateClustersRequest(w);
                        break;
                    }
                    case 8: {
                        mining.formatGetTermIDsRequest(w);
                        break;
                    }
                    case 9: {
                        mining.formatGetThesaurusTermsRequest(w);
                        break;
                    }
                    case 10: {
                        mining.formatGetDocumentLanguage(w);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (Exception e) {
                log.debugT("Can not get request as xml. Exception: " + e.getMessage());
                return null;
            }
            ret = stringWriter.getBuffer();
        }
        return ret;
    }

    private void addServerToXML(StringBuffer sbuf, AbstractTextMining mining) {
        Iterator it = mining.indexRefList.iterator();
        IndexId indexId = null;
        if (it != null && it.hasNext()) {
            indexId = (IndexId)it.next();
            if (indexId.getMode().equals("http") || indexId.getMode().equals("https")) {
                sbuf.append(indexId.getHttpServerUrl().toString());
            } else {
                sbuf.append("jni");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

