/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.TaxonomyNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TaxonomyTree {
    private TrexReturn m_return = null;
    private List m_nodes = new ArrayList();
    private Iterator m_nodeIterator = null;
    private Iterator m_childrenIterator = null;
    private boolean m_hashMapCalculated = false;
    private HashMap m_hashMap = new HashMap();
    static /* synthetic */ Class class$com$sapportals$trex$core$TaxonomyTree;

    public TaxonomyNode getFirstNode() throws TrexException {
        this.m_nodeIterator = this.m_nodes.iterator();
        if (this.m_nodeIterator.hasNext()) {
            return (TaxonomyNode)this.m_nodeIterator.next();
        }
        return null;
    }

    public TaxonomyNode getNextNode() throws TrexException {
        if (this.m_nodeIterator == null) {
            return null;
        }
        if (this.m_nodeIterator.hasNext()) {
            return (TaxonomyNode)this.m_nodeIterator.next();
        }
        return null;
    }

    public TaxonomyNode getNode(String nodeId) throws TrexException {
        this.calculateHashMap();
        NodeInfo nodeInfo = (NodeInfo)this.m_hashMap.get(nodeId);
        if (nodeInfo == null || nodeInfo.node == null) {
            return null;
        }
        return nodeInfo.node;
    }

    public TaxonomyNode getParent(String nodeId) throws TrexException {
        this.calculateHashMap();
        NodeInfo nodeInfo = (NodeInfo)this.m_hashMap.get(nodeId);
        if (nodeInfo == null || nodeInfo.node == null) {
            return null;
        }
        nodeInfo = (NodeInfo)this.m_hashMap.get(nodeInfo.parentId);
        if (nodeInfo == null || nodeInfo.node == null) {
            return null;
        }
        return nodeInfo.node;
    }

    public TaxonomyNode getFirstChild(String nodeId) throws TrexException {
        this.calculateHashMap();
        NodeInfo nodeInfo = (NodeInfo)this.m_hashMap.get(nodeId);
        if (nodeInfo == null || nodeInfo.children == null || nodeInfo.children.size() == 0) {
            return null;
        }
        this.m_childrenIterator = nodeInfo.children.iterator();
        if (this.m_childrenIterator.hasNext()) {
            return (TaxonomyNode)this.m_childrenIterator.next();
        }
        return null;
    }

    public TaxonomyNode getNextChild() throws TrexException {
        if (this.m_childrenIterator == null) {
            return null;
        }
        if (this.m_childrenIterator.hasNext()) {
            return (TaxonomyNode)this.m_childrenIterator.next();
        }
        return null;
    }

    public TrexReturn getLastError() {
        if (this.m_return == null) {
            this.m_return = new TrexReturn(0);
        }
        return this.m_return;
    }

    public int countNodes() {
        return this.m_nodes.size();
    }

    public int countChildren(String nodeId) {
        this.calculateHashMap();
        NodeInfo nodeInfo = (NodeInfo)this.m_hashMap.get(nodeId);
        if (nodeInfo == null || nodeInfo.children == null) {
            return 0;
        }
        return nodeInfo.children.size();
    }

    public void addNode(TaxonomyNode node) throws TrexException {
        if (node == null) {
            throw new TrexException(7203, "node", "null", "addNode()", (class$com$sapportals$trex$core$TaxonomyTree == null ? (class$com$sapportals$trex$core$TaxonomyTree = TaxonomyTree.class$("com.sapportals.trex.core.TaxonomyTree")) : class$com$sapportals$trex$core$TaxonomyTree).getName());
        }
        if (node.getId() == null) {
            throw new TrexException(7203, "node.Id", "null", "addNode()", (class$com$sapportals$trex$core$TaxonomyTree == null ? (class$com$sapportals$trex$core$TaxonomyTree = TaxonomyTree.class$("com.sapportals.trex.core.TaxonomyTree")) : class$com$sapportals$trex$core$TaxonomyTree).getName());
        }
        this.m_nodes.add(node);
    }

    private void calculateHashMap() {
        if (!this.m_hashMapCalculated) {
            TaxonomyNode node;
            String id = null;
            NodeInfo info = new NodeInfo();
            info.node = null;
            info.parentId = null;
            Iterator it2 = this.m_nodes.iterator();
            while (it2.hasNext()) {
                node = (TaxonomyNode)it2.next();
                if (node.getParentId() != null) continue;
                info.children.add(node);
            }
            this.m_hashMap.put(id, info);
            Iterator it = this.m_nodes.iterator();
            while (it.hasNext()) {
                node = (TaxonomyNode)it.next();
                id = node.getId();
                info = new NodeInfo();
                info.node = node;
                info.parentId = node.getParentId();
                it2 = this.m_nodes.iterator();
                while (it2.hasNext()) {
                    node = (TaxonomyNode)it2.next();
                    if (node.getParentId() == null || !node.getParentId().equals(id)) continue;
                    info.children.add(node);
                }
                this.m_hashMap.put(id, info);
            }
            this.m_hashMapCalculated = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NodeInfo {
        public TaxonomyNode node;
        public String parentId;
        public List children = new ArrayList();

        private NodeInfo() {
        }
    }
}

