/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.TaxonomyTerm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TaxonomyNode {
    private String m_id;
    private String m_name;
    private String m_parentId;
    private float m_parentWeight;
    private List m_termList = new ArrayList();
    private List m_queryEntryList = new ArrayList();
    private Iterator m_queryEntryIterator = null;
    private Iterator m_termListIterator = null;
    private float m_simVal;

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParentId() {
        return this.m_parentId;
    }

    public float getParentWeight() {
        return this.m_parentWeight;
    }

    public float getSimVal() {
        return this.m_simVal;
    }

    public TaxonomyTerm getFirstTerm() {
        this.m_termListIterator = this.m_termList.iterator();
        if (this.m_termListIterator.hasNext()) {
            return (TaxonomyTerm)this.m_termListIterator.next();
        }
        return null;
    }

    public TaxonomyTerm getNextTerm() {
        if (this.m_termListIterator == null) {
            return null;
        }
        if (this.m_termListIterator.hasNext()) {
            return (TaxonomyTerm)this.m_termListIterator.next();
        }
        return null;
    }

    public QueryEntry getFirstQueryEntry() {
        this.m_queryEntryIterator = this.m_queryEntryList.iterator();
        if (this.m_queryEntryIterator.hasNext()) {
            return (QueryEntry)this.m_queryEntryIterator.next();
        }
        return null;
    }

    public QueryEntry getNextQueryEntry() {
        if (this.m_queryEntryIterator == null) {
            return null;
        }
        if (this.m_queryEntryIterator.hasNext()) {
            return (QueryEntry)this.m_queryEntryIterator.next();
        }
        return null;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void addTerm(TaxonomyTerm term) {
        this.m_termList.add(term);
    }

    public void addQueryEntry(QueryEntry queryEntry) {
        this.m_queryEntryList.add(queryEntry);
    }

    public void clearQuery() {
        this.m_queryEntryList = new ArrayList();
        this.m_queryEntryIterator = null;
    }

    public void clearTerms() {
        this.m_termList = new ArrayList();
        this.m_termListIterator = null;
    }

    public void setParentId(String id) {
        this.m_parentId = id;
    }

    public void setParentWeight(float weight) {
        this.m_parentWeight = weight;
    }

    public void setSimVal(float simVal) {
        this.m_simVal = simVal;
    }
}

