/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractTaxonomy;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.HttpTaxonomy;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.TaxonomyNode;
import com.sapportals.trex.core.TaxonomyTree;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;

public class TaxonomyManager
extends BaseManager {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$TaxonomyManager == null ? (class$com$sapportals$trex$core$TaxonomyManager = TaxonomyManager.class$("com.sapportals.trex.core.TaxonomyManager")) : class$com$sapportals$trex$core$TaxonomyManager).getName());
    private IndexId m_indexId = null;
    private String m_httpserverurl;
    private boolean m_httpserverManuallySet = false;
    static /* synthetic */ Class class$com$sapportals$trex$core$TaxonomyManager;

    protected TaxonomyManager() {
    }

    public void setIndexId(String indexName, String language) throws TrexException {
        this.m_indexId = new IndexId();
        this.m_indexId.setIndexName(indexName);
        this.m_indexId.setLanguage(language);
    }

    public void setIndexId(String indexName, String language, String mode, String host, int port, String file) throws TrexException {
        this.m_indexId = new IndexId();
        this.m_indexId.setIndexName(indexName);
        this.m_indexId.setLanguage(language);
        this.m_httpserverManuallySet = true;
        this.m_httpserverurl = HttpServerURL.getURL(mode, host, port, file).toString();
        this.m_indexId.setHttpServerUrl(mode, host, port, file);
        this.m_httpserverManuallySet = true;
    }

    public TaxonomyTree getTaxonomy(String attribute) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("Getting of taxonomy '" + attribute + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "get taxonomy " + attribute + " for index" + this.m_indexId);
            TaxonomyTree tree = taxonomy.getTaxonomy(attribute);
            log.infoT("Getting of taxonomy '" + attribute + "' finished");
            TaxonomyTree taxonomyTree = tree;
            Object var7_6 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            return taxonomyTree;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void setTaxonomy(String attribute, TaxonomyTree tree) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            if (tree == null) {
                throw new TrexException(7203, "tree", "null", "setTaxonomy()", (class$com$sapportals$trex$core$TaxonomyManager == null ? (class$com$sapportals$trex$core$TaxonomyManager = TaxonomyManager.class$("com.sapportals.trex.core.TaxonomyManager")) : class$com$sapportals$trex$core$TaxonomyManager).getName());
            }
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("Setting of taxonomy '" + attribute + "' for index '" + this.m_indexId + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "set taxonomy for taxonomy '" + attribute + "' for index" + this.m_indexId);
            taxonomy.setTaxonomy(attribute, tree);
            log.infoT("Setting of taxonomy '" + attribute + "' finished");
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void setTaxonomyNode(String attribute, TaxonomyNode node) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            if (node == null) {
                throw new TrexException(7203, "node", "null", "setTaxonomyNode()", (class$com$sapportals$trex$core$TaxonomyManager == null ? (class$com$sapportals$trex$core$TaxonomyManager = TaxonomyManager.class$("com.sapportals.trex.core.TaxonomyManager")) : class$com$sapportals$trex$core$TaxonomyManager).getName());
            }
            if (node.getId() == null || node.getId().length() < 1) {
                throw new TrexException(7203, "node.getId()", "null", "setTaxonomyNode()", (class$com$sapportals$trex$core$TaxonomyManager == null ? (class$com$sapportals$trex$core$TaxonomyManager = TaxonomyManager.class$("com.sapportals.trex.core.TaxonomyManager")) : class$com$sapportals$trex$core$TaxonomyManager).getName());
            }
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("Setting of taxonomy node '" + node.getId() + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "set taxonomy node " + node.getId() + " for taxonomy " + attribute + " for index" + this.m_indexId);
            taxonomy.setTaxonomyNode(attribute, node);
            log.infoT("Setting of taxonomy node '" + node.getId() + "' finished");
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void deleteTaxonomyNode(String attribute, String nodeId) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("Deletion of taxonomy node '" + nodeId + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "delete taxonomy node " + nodeId + " for taxonomy " + attribute + " for index" + this.m_indexId);
            taxonomy.deleteTaxonomyNode(attribute, nodeId);
            log.infoT("Deletion of taxonomy node '" + nodeId + "' finished");
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void deleteTaxonomy(String attribute) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("Deletion of taxonomy '" + attribute + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "delete taxonomy " + attribute + " for index" + this.m_indexId);
            taxonomy.deleteTaxonomy(attribute);
            log.infoT("Deletion of taxonomy '" + attribute + "' finished");
            Object var5_4 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public SearchResult getDocuments4Node(String attribute, String nodeId) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("GetDocuments4Node for node '" + nodeId + "' in taxonomy '" + attribute + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "get documents for node " + nodeId + " for taxonomy " + attribute + " for index" + this.m_indexId);
            SearchResult result = taxonomy.getDocuments4Node(attribute, nodeId);
            log.infoT("GetDocuments4Node for node '" + nodeId + "' in taxonomy '" + attribute + "' finished");
            SearchResult searchResult = result;
            Object var8_7 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            return searchResult;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public String[] projectNodeDeletion(String attribute, String nodeId) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("ProjectNodeDeletion for node '" + nodeId + "' in taxonomy '" + attribute + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "project node deletion for node " + nodeId + " for taxonomy " + attribute + " for index" + this.m_indexId);
            String[] result = taxonomy.projectNodeDeletion(attribute, nodeId);
            log.infoT("ProjectNodeDeletion for node '" + nodeId + "' in taxonomy '" + attribute + "' finished");
            String[] stringArray = result;
            Object var8_7 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public String[] projectAssignmentMutation(String attribute, String nodeId, String parentId) throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("ProjectAssignmentMutation for node '" + nodeId + "' in taxonomy '" + attribute + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "projectAssignmentMutation for node " + nodeId + "new parent " + parentId + " for taxonomy " + attribute + " for index" + this.m_indexId);
            String[] result = taxonomy.projectAssignmentMutation(attribute, nodeId, parentId);
            log.infoT("ProjectAssignmentMutation for node '" + nodeId + "' in taxonomy '" + attribute + "' finished");
            String[] stringArray = result;
            Object var9_8 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void updateIndex() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:TAX");
            AbstractTaxonomy taxonomy = this.getNewTaxonomyInstance();
            taxonomy.setIndexId(this.m_indexId);
            log.infoT("Update of index '" + this.m_indexId.getIndexName() + "' started");
            monitor.compAction("EP:KM:TREX:TAX", "taxonomy update of index " + this.m_indexId);
            taxonomy.updateIndex();
            log.infoT("Update of index '" + this.m_indexId.getIndexName() + "' finished");
            Object var4_3 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:TAX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    private AbstractTaxonomy getNewTaxonomyInstance() throws TrexException {
        if (this.m_indexId == null || this.m_indexId.getIndexName() == null) {
            throw new TrexException(7230);
        }
        HttpTaxonomy httpTaxonomy = new HttpTaxonomy();
        httpTaxonomy.setIndexId(this.m_indexId);
        httpTaxonomy.setSSLData(this.m_keystore, this.m_truststore);
        httpTaxonomy.setIndexUser(this.m_indexUser);
        if (this.m_httpserverManuallySet) {
            try {
                httpTaxonomy.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException ex) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        return httpTaxonomy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

