/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.AttributeDistribution;
import com.sapportals.trex.core.AttributeDistributionOverview;
import com.sapportals.trex.core.CompleteTerm;
import com.sapportals.trex.core.CompleteTerms;
import com.sapportals.trex.core.DocAttribute;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.QueryTermInfo;
import com.sapportals.trex.core.RelatedTerm;
import com.sapportals.trex.core.RelatedTerms;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.ResultElement;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.SimilarSearchResult;
import com.sapportals.trex.core.TaxonomyNode;
import com.sapportals.trex.core.TaxonomyTerm;
import com.sapportals.trex.core.TaxonomyTree;
import com.sapportals.trex.core.TextMiningResult;
import com.sapportals.trex.core.TextMiningResultContainer;
import com.sapportals.trex.core.base64.BASE64Decoder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class TMResponseReactor {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$TMResponseReactor == null ? (class$com$sapportals$trex$core$TMResponseReactor = TMResponseReactor.class$("com.sapportals.trex.core.TMResponseReactor")) : class$com$sapportals$trex$core$TMResponseReactor).getName());
    private int returnCode;
    private String errorText;
    private String indexId;
    private String indexLanguage;
    private String searchEngine;
    private TextMiningResult textMiningResult = null;
    private TextMiningResultContainer textMiningResultContainer = null;
    private ResultElement resultElement = null;
    private ResultElement resultProperty = null;
    private SearchResult m_searchResult = null;
    private SimilarSearchResult m_similarSearchResult = null;
    private DocAttribute docAttribute;
    private TrexReturn returnForException = null;
    private RelatedTerms relatedTerms = null;
    private RelatedTerm relatedTerm = null;
    private CompleteTerms completeTerms = null;
    private CompleteTerm completeTerm = null;
    private ResultDocument m_resultDocument = null;
    private ArrayList m_resultDocuments = null;
    private TaxonomyNode m_taxonomyNode = null;
    private TaxonomyTree m_taxonomyTree = null;
    private QueryEntry m_queryEntry = null;
    private QueryTermInfo m_queryTermInfo = null;
    private TaxonomyTerm m_taxonomyTerm = null;
    private List m_nodeList = null;
    private boolean m_isAddingFeatures = false;
    static /* synthetic */ Class class$com$sapportals$trex$core$TMResponseReactor;

    TMResponseReactor() {
    }

    public void createResultDocument() {
        this.m_resultDocument = new ResultDocument();
    }

    public void setDocumentKeyInResultDocument(String key) {
        this.m_resultDocument.setDocumentKey(key);
    }

    public void setDocumentStateInResultDocument() {
        try {
            this.m_resultDocument.setDocumentStatus(this.returnCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLanguageInResultDocument(String language) {
        this.m_resultDocument.setDocumentLanguage(language);
    }

    public void setContentInResultDocument(String content) {
        if (content.length() == 0) {
            this.m_resultDocument.setContent("");
        } else {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] contentBytes = decoder.decodeBuffer(content);
            try {
                this.m_resultDocument.setContent(new String(contentBytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    public void setIndexIdInResultDocument(String indexName) {
        try {
            this.m_resultDocument.setIndexId(indexName, "DRFUZZY", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addResultDocument() {
        if (this.m_resultDocuments == null) {
            this.m_resultDocuments = new ArrayList();
        }
        this.m_resultDocuments.add(this.m_resultDocument);
    }

    public ArrayList getResultDocuments() {
        return this.m_resultDocuments;
    }

    public void createTextMiningResult() {
        this.textMiningResult = new TextMiningResult();
    }

    public void createTextMiningResultContainer() {
        this.textMiningResultContainer = new TextMiningResultContainer();
    }

    public void setErrorCodeInTextMiningResult() {
        TrexReturn ret = null;
        ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.textMiningResult.setErrorCode(ret);
    }

    public void setErrorCodeInCompleteTerms() {
        TrexReturn ret = null;
        ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.completeTerms.setErrorCode(ret);
    }

    public void setKeyInTextMiningResultContainer(String key) {
        try {
            this.textMiningResultContainer.setKey(key);
        }
        catch (TrexException e) {
            log.errorT("Exception when setting the document key " + key);
        }
    }

    public void addTextMiningResultContainerToTextMiningResult() {
        TrexReturn ret = null;
        ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.textMiningResultContainer.setErrorCode(ret);
        try {
            this.textMiningResult.addContainer(this.textMiningResultContainer);
        }
        catch (TrexException e) {
            log.errorT("Exception when adding container to TextMiningResult");
        }
    }

    public void addTrexCommandResultToTextMiningResult(String command) {
        this.textMiningResult.setTrexCommandResult(command);
    }

    public void createResultElement() {
        this.resultElement = new ResultElement();
    }

    public void createResultFeature() {
        this.resultProperty = new ResultElement();
    }

    public void addResultElementToTextMiningResultContainer() {
        try {
            this.textMiningResultContainer.addElement(this.resultElement);
        }
        catch (TrexException e) {
            log.errorT("Exception when adding an element to a container");
        }
    }

    public void addResultFeatureToTextMiningResultContainer() {
        try {
            this.textMiningResultContainer.addProperty(this.resultProperty);
        }
        catch (TrexException e) {
            log.errorT("Exception when adding a property to a container");
        }
    }

    public void setNameInResultElement(String name) {
        this.resultElement.setName(name);
    }

    public boolean isNameInResultElementSet() {
        return this.resultElement != null && this.resultElement.getName() != null;
    }

    public void setClassificationTypeInResultElement(byte value) {
        this.resultElement.setClassificationType(value);
    }

    public void setRankValueInResultElement(float value) {
        this.resultElement.setRankValue(value);
    }

    public void setNameInResultFeature(String name) {
        this.resultProperty.setName(name);
    }

    public void setRankValueInResultFeature(float value) {
        this.resultProperty.setRankValue(value);
    }

    public void setClassificationTypeInResultFeature(byte value) {
        this.resultProperty.setClassificationType(value);
    }

    public void setReturnCode(String code) {
        this.returnCode = Integer.parseInt(code);
    }

    public void setErrorText(String eText) {
        this.errorText = eText;
    }

    public void setCurrentIndexID(String indexId_) {
        this.indexId = indexId_;
        this.searchEngine = null;
    }

    public void setSearchEngineExtern(String searchEngine_) {
        this.searchEngine = searchEngine_;
        this.indexId = null;
        this.indexLanguage = null;
    }

    public void setCurrentIndexLanguage(String language) {
        this.indexLanguage = language;
    }

    public void createSearchResult() {
        this.m_searchResult = new SearchResult();
    }

    public void createDocAttribute() {
        this.docAttribute = new DocAttribute();
    }

    public void setNoOfHitsInSearchResult(int n) {
        if (this.m_searchResult == null) {
            this.m_searchResult = new SearchResult();
        }
        this.m_searchResult.setNoOfHits(n);
    }

    public void setNoOfAllHitsInIndexInSearchResult(int n) {
        this.m_searchResult.setNoOfAllHitsInIndex(n);
    }

    public void setIndexSizeInSearchResult(int size) {
        this.m_searchResult.setIndexSize(size);
    }

    public void setRequestedSearchResultsInSearchResult(byte requestedSearchResults) {
        this.m_searchResult.setRequestedSearchResults(requestedSearchResults);
    }

    public void setRankValueInResultDocument(float value) {
        this.m_resultDocument.setRankValue(value);
    }

    public void setCodePageInResultDocument(String codepage) {
        log.errorT("CodePage cannot be set to value " + codepage);
    }

    public void setAttributeNameInDocAttribute(String name) {
        this.docAttribute.setAttributeName(name);
    }

    public void setAttributeValue1InDocAttribute(String value) {
        this.docAttribute.setValue1(value);
    }

    public void setAttributeValue2InDocAttribute(String value) {
        this.docAttribute.setValue2(value);
    }

    public void setAttributeTypeInDocAttribute(String value) {
        this.docAttribute.setAttributeType(value);
    }

    public void createCompleteTerms() {
        this.completeTerms = new CompleteTerms();
    }

    public void createCompleteTerm() {
        this.completeTerm = new CompleteTerm();
    }

    public void setTermIdInCompleteTerm(String termId_) {
        this.completeTerm.setTermId(termId_);
    }

    public void setTermNameInCompleteTerm(String termName_) {
        this.completeTerm.setTermName(termName_);
    }

    public void setTermDescriptionInCompleteTerm(String termDescription_) {
        this.completeTerm.setTermDescription(termDescription_);
    }

    public void addCompleteTermToCompleteTerms() {
        try {
            this.completeTerms.addCompleteTerm(this.completeTerm);
        }
        catch (TrexException e) {
            log.errorT("CompleteTerm could not be added to completeTerms.");
        }
    }

    public void addDocAttributeToResultDocument() {
        this.m_resultDocument.addDocumentAttribute(this.docAttribute);
    }

    public void addResultDocumentToSearchResult() {
        try {
            this.m_searchResult.addResultDocument(this.m_resultDocument);
        }
        catch (TrexException e) {
            log.errorT("Document could not be added to search result");
        }
    }

    public void addResultDocumentToAdministeredSearchResult() {
        try {
            this.m_searchResult.addAdministeredResultDocument(this.m_resultDocument);
        }
        catch (TrexException e) {
            log.errorT("Document could not be added to administered search result");
        }
    }

    public void setIndexIdInResultDocument() {
        if (this.searchEngine == null || this.searchEngine.length() == 0) {
            this.searchEngine = "DRFUZZY";
        }
        try {
            this.m_resultDocument.setIndexId(this.indexId, this.searchEngine, "");
        }
        catch (TrexException e) {
            log.errorT("IndexId " + this.indexId + " could not be set in result document");
        }
    }

    public SearchResult getSearchResult() {
        return this.m_searchResult;
    }

    public TextMiningResult getTextMiningResult() {
        return this.textMiningResult;
    }

    public TextMiningResultContainer getTextMiningResultContainer() {
        return this.textMiningResultContainer;
    }

    public void createSimilarSearchResult() {
        this.m_similarSearchResult = new SimilarSearchResult();
    }

    public SimilarSearchResult getSimilarSearchResult() {
        return this.m_similarSearchResult;
    }

    public void setNoOfAllHitsInIndexInSimilarSearchResult(int n) {
        this.m_similarSearchResult.setNoOfAllHitsInIndex(n);
    }

    public void setIndexSizeInSimilarSearchResult(int n) {
        this.m_similarSearchResult.setIndexSize(n);
    }

    public void addResultDocumentToSimilarSearchResult() {
        try {
            this.m_similarSearchResult.addResultDocument(this.m_resultDocument);
        }
        catch (TrexException e) {
            log.errorT("Document could not be added to similar search result");
        }
    }

    public void setReturnCodeInSimilarSearchResult() {
        TrexReturn ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.m_similarSearchResult.setErrorCode(ret);
    }

    public void setErrorCodeForException() {
        TrexReturn ret;
        this.returnForException = ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
    }

    public TrexReturn getExceptionReturn() {
        return this.returnForException;
    }

    public void setErrorCodeInSearchResult() {
        TrexReturn ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.m_searchResult.setLastError(ret);
    }

    public void setErrorCodeInTextMiningResultContainer() {
        TrexReturn ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.textMiningResultContainer.setErrorCode(ret);
    }

    public void createRelatedTerms() {
        this.relatedTerms = new RelatedTerms();
    }

    public void createRelatedTerm() {
        this.relatedTerm = new RelatedTerm();
    }

    public void setTermIDInRelatedTerm(String name) {
        this.relatedTerm.setId(name);
    }

    public void setTermNameInRelatedTerm(String name) {
        this.relatedTerm.setTermName(name);
    }

    public void setRelationNameInRelatedTerm(String name) {
        this.relatedTerm.setRelationName(name);
    }

    public void setRoleNameInRelatedTerm(String name) {
        this.relatedTerm.setRoleName(name);
    }

    public void setRankValueInRelatedTerm(float rankValue) {
        this.relatedTerm.setRank(rankValue);
    }

    public void addRelatedTermToRelatedTerms() {
        this.relatedTerms.addRelatedTerm(this.relatedTerm);
    }

    public void setErrorCodeInRelatedTerms() {
        TrexReturn ret = null;
        ret = TrexReturn.createExternalError(this.returnCode, this.errorText);
        this.relatedTerms.setErrorCode(ret);
    }

    public RelatedTerms getRelatedTerms() {
        return this.relatedTerms;
    }

    public CompleteTerms getCompleteTerms() {
        return this.completeTerms;
    }

    public void createTaxonomyTree() {
        this.m_taxonomyTree = new TaxonomyTree();
    }

    public void createTaxonomyNode() {
        this.m_taxonomyNode = new TaxonomyNode();
    }

    public void createTaxonomyTerm() {
        this.m_taxonomyTerm = new TaxonomyTerm();
    }

    public void createQueryEntry() {
        this.m_queryEntry = new QueryEntry();
    }

    public void setValueInQueryEntry(String value1, String value2, String queryOperator) {
        try {
            this.m_queryEntry.setValue(value1, value2, queryOperator);
        }
        catch (TrexException e) {
            log.errorT("Values could not be set in QueryEntry");
        }
    }

    public void setRowTypeInQueryEntry(String rowType) {
        try {
            this.m_queryEntry.setRowType(rowType);
        }
        catch (TrexException e) {
            log.errorT("RowType could not be set in QueryEntry");
        }
    }

    public void setContentTypeInQueryEntry(String contentType) {
        try {
            byte[] buffer = contentType.getBytes();
            if (buffer.length > 0) {
                this.m_queryEntry.setContentType(buffer[0]);
            }
        }
        catch (TrexException e) {
            log.errorT("ContentType could not be set in QueryEntry");
        }
    }

    public void setTermWeightInQueryEntry(float termWeight) {
        try {
            this.m_queryEntry.setTermWeight(termWeight);
        }
        catch (TrexException e) {
            log.errorT("Term weight could not be set in QueryEntry");
        }
    }

    public void setTermActionInQueryEntry(String termAction) {
        try {
            byte[] buffer = termAction.getBytes();
            if (buffer.length > 0) {
                this.m_queryEntry.setTermAction(buffer[0]);
            }
        }
        catch (TrexException e) {
            log.errorT("TermAction could not be set in QueryEntry");
        }
    }

    public void setLocationInQueryEntry(String location) {
        try {
            this.m_queryEntry.setLocation(location);
        }
        catch (TrexException e) {
            log.errorT("Location could not be set in QueryEntry");
        }
    }

    public void setFuzzySimilarityInQueryEntry(float fuzzySimilarity) {
        this.m_queryEntry.setFuzzySimilarity(fuzzySimilarity);
    }

    public void setNearWidthInQueryEntry(int nearWidth) {
        this.m_queryEntry.setNearWidth(nearWidth);
    }

    public void setNearOrderInQueryEntry(int nearOrder) {
        this.m_queryEntry.setNearOrder(nearOrder);
    }

    public void setNearRankMethodInQueryEntry(int nearRanking) {
        this.m_queryEntry.setNearRanking(nearRanking);
    }

    public void setSearchTermFlags(int searchTermFlags) {
        this.m_queryEntry.setSearchTermFlags(searchTermFlags);
    }

    public void createQueryTermInfo() {
        this.m_queryTermInfo = new QueryTermInfo();
    }

    public void addQueryEntryToSearchResult() {
        this.m_searchResult.addAdaptedQueryEntry(this.m_queryEntry);
    }

    public void addQueryTermInfoToQueryEntry() {
        this.m_queryEntry.addTermInfo(this.m_queryTermInfo);
    }

    public void setActualTermInQueryTermInfo(int term) {
        this.m_queryTermInfo.setActualTerm(term);
    }

    public void setTermInQueryTermInfo(String term) {
        this.m_queryTermInfo.setTerm(term);
    }

    public void setFlagInQueryTermInfo(int flag) {
        if (flag == 1) {
            this.m_queryTermInfo.setTermChanged(true);
        }
    }

    public void setRankInQueryTermInfo(float rank) {
        this.m_queryTermInfo.setRank(rank);
    }

    public void setIdInTaxonomyNode(String id) {
        this.m_taxonomyNode.setId(id);
    }

    public void setNameInTaxonomyNode(String name) {
        this.m_taxonomyNode.setName(name);
    }

    public void setParentIdInTaxonomyNode(String parentId) {
        this.m_taxonomyNode.setParentId(parentId);
    }

    public void setParentWeightInTaxonomyNode(float parentWeight) {
        this.m_taxonomyNode.setParentWeight(parentWeight);
    }

    public void setSimValInTaxonomyNode(float simVal) {
        this.m_taxonomyNode.setSimVal(simVal);
    }

    public void addQueryEntryToTaxonomyNode() {
        this.m_taxonomyNode.addQueryEntry(this.m_queryEntry);
    }

    public void addTaxonomyTermToTaxonomyNode() {
        this.m_taxonomyNode.addTerm(this.m_taxonomyTerm);
    }

    public void addTaxonomyNodeToTaxonomyTree() throws TrexException {
        this.m_taxonomyTree.addNode(this.m_taxonomyNode);
    }

    public void setAttributeInTaxonomyTerm(String attribute) {
        this.m_taxonomyTerm.setAttribute(attribute);
    }

    public void setWeightInTaxonomyTerm(float weight) {
        this.m_taxonomyTerm.setWeight(weight);
    }

    public void setValue1InTaxonomyTerm(String value1) {
        this.m_taxonomyTerm.setValue1(value1);
    }

    public void setValue2InTaxonomyTerm(String value2) {
        this.m_taxonomyTerm.setValue2(value2);
    }

    public void setOperatorInTaxonomyTerm(String op) {
        this.m_taxonomyTerm.setOperator(op);
    }

    public TaxonomyTree getTaxonomy() {
        return this.m_taxonomyTree;
    }

    public void addNodeId(String nodeId) {
        if (this.m_nodeList == null) {
            this.m_nodeList = new ArrayList();
        }
        this.m_nodeList.add(nodeId);
    }

    public List getNodeIds() {
        if (this.m_nodeList == null) {
            return new ArrayList();
        }
        return this.m_nodeList;
    }

    public TrexReturn getReturn() {
        if (this.returnCode == 0) {
            return new TrexReturn(0);
        }
        return new TrexReturn(7202, String.valueOf(this.returnCode), this.errorText);
    }

    public void setIsAddingFeatures(boolean flag) {
        this.m_isAddingFeatures = flag;
    }

    public boolean getIsAddingFeatures() {
        return this.m_isAddingFeatures;
    }

    public void addAttributeDistribution(AttributeDistribution ad) {
        this.m_searchResult.addAttributeDistribution(ad);
    }

    public void addDistributionOverviewToSearchResult(AttributeDistributionOverview ado) {
        this.m_searchResult.addAttributeDistributionOverview(ado);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

