/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.SearchDocument;
import com.sapportals.trex.core.SearchManager;
import com.sapportals.trex.core.TextMiningManager;
import com.sapportals.trex.core.base64.BASE64Decoder;
import java.util.ArrayList;
import java.util.List;

class TMRequestReactor {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$TMRequestReactor == null ? (class$com$sapportals$trex$core$TMRequestReactor = TMRequestReactor.class$("com.sapportals.trex.core.TMRequestReactor")) : class$com$sapportals$trex$core$TMRequestReactor).getName());
    private static final byte STATE_DOC_ATTR_LIST = 1;
    private static final byte STATE_SORTED_BY = 2;
    private byte lastState = 0;
    private static final boolean DEFAULT_SORT_ASCENDING = true;
    private static final boolean DEFAULT_WHERE_CLAUSE_IS_IN_INFIX = true;
    private static final byte DEFAULT_TERM_ACTION = 69;
    private static final byte DEFAULT_CONTENT_TYPE = 78;
    private static final byte DEFAULT_DOC_TYPE = 0;
    private static final int DEFAULT_DOC_ID = 0;
    private SearchManager searchManager = null;
    private TextMiningManager miningManager = null;
    private QueryEntry queryEntry = null;
    private List docAttrList = new ArrayList();
    private List sortedByList = new ArrayList();
    private TrexReturn errorForException = null;
    private int from = 0;
    private int to = 0;
    private boolean whereClauseIsInInfix = true;
    private String indexID = null;
    private String laiso = null;
    private String docAttrName = null;
    private boolean sortAscending = true;
    private String queryLAISO = null;
    private String queryCodePage = null;
    private String qTName = null;
    private String qType = null;
    private String value1 = null;
    private String value2 = null;
    private String qOperator = null;
    private byte contentType = (byte)78;
    private byte termAction = (byte)69;
    private Float termWeight = null;
    private Float fuzzySimilarity = null;
    private String searchEngineExtern = null;
    private int maxSimilarDocs = 0;
    private String docGroup = null;
    private String docID = null;
    private byte docType = 0;
    private String codePage = null;
    private String content = null;
    static /* synthetic */ Class class$com$sapportals$trex$core$TMRequestReactor;

    TMRequestReactor() {
    }

    public void createIndex() {
    }

    public void setIndex() {
    }

    public void setSearchEngineExtern(String searchEngineExtern_) {
        this.searchEngineExtern = searchEngineExtern_;
    }

    public void setLaiso(String laiso_) {
        this.laiso = laiso_;
    }

    public void setFrom(String from_) {
        Integer parsedValue = this.parseInt(from_);
        if (parsedValue != null) {
            this.from = parsedValue;
        }
    }

    public void setTo(String to_) {
        Integer parsedValue = this.parseInt(to_);
        if (parsedValue != null) {
            this.to = parsedValue;
        }
    }

    public void setDocAttrNameSetValue(String docAttrName_) {
        this.docAttrName = docAttrName_;
    }

    public void setDocAttrNameDocAttrList(String docAttrName_) {
        if (docAttrName_ != null) {
            this.docAttrList.add(docAttrName_);
        }
    }

    public void createSortedBy() {
    }

    public void setSortedBy() {
        if (this.docAttrName != null) {
            SortedByContainer item = new SortedByContainer(this.docAttrName, this.sortAscending);
            this.sortedByList.add(item);
        }
        this.docAttrName = null;
        this.sortAscending = true;
    }

    public void setIndexID(String indexID_) {
        this.indexID = indexID_;
    }

    public void setSortAscending(String flag) {
        this.sortAscending = this.parseBoolean(flag, true);
    }

    public void setInterval() {
        try {
            this.searchManager.setResultFromTo(this.from, this.to);
        }
        catch (TrexException e) {
            log.throwing("Can not set ResultFromTo. from: " + this.from + " to: " + this.to, (Throwable)e);
        }
    }

    public void setQueryLAISO(String queryLAISO_) {
        this.queryLAISO = queryLAISO_;
    }

    public void setQueryCodePage(String queryCodePage_) {
        this.queryCodePage = queryCodePage_;
    }

    public void createIn() {
    }

    public void setIn() {
    }

    public void createWhere() {
    }

    public void setWhere() {
    }

    public void createSortedByList() {
        this.sortedByList.clear();
    }

    public void setSortedByListSearch() {
        if (!this.sortedByList.isEmpty()) {
            int i = 0;
            while (i < this.sortedByList.size()) {
                SortedByContainer item = (SortedByContainer)this.sortedByList.get(i);
                try {
                    this.searchManager.addSortAttribute(item.getDocAttrName(), item.getSortAscending());
                }
                catch (TrexException e) {
                    log.throwing("Can not add SortAttribute.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public void createDocAttrList() {
        this.docAttrList.clear();
    }

    public void setDocAttrListSearch() {
        if (!this.docAttrList.isEmpty()) {
            int i = 0;
            while (i < this.docAttrList.size()) {
                try {
                    this.searchManager.addRequestedAttribute((String)this.docAttrList.get(i));
                }
                catch (TrexException e) {
                    log.throwing("Can not add RequestedAttribute.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public void createIndexLoc() {
    }

    public void setIndexLocGetSimilarDocs() {
        if (this.indexID != null) {
            try {
                this.miningManager.addIndexId(this.indexID, this.laiso);
            }
            catch (TrexException e) {
                log.debugT("Can not add Index. indexID: " + this.indexID + ", laiso: " + this.laiso);
            }
        }
        this.indexID = null;
        this.laiso = null;
        this.searchEngineExtern = null;
    }

    public void setIndexLoc() {
        if (this.searchEngineExtern != null) {
            this.indexID = this.searchEngineExtern;
        }
        if (this.indexID != null) {
            try {
                this.searchManager.addIndexId(this.indexID, this.laiso);
            }
            catch (TrexException e) {
                log.throwing("Can not add indexID. indexID: " + this.indexID + ", laiso: " + this.laiso, (Throwable)e);
            }
        }
        this.indexID = null;
        this.laiso = null;
        this.searchEngineExtern = null;
    }

    public void setWhereClauseIsInInfix(String flag) {
        this.whereClauseIsInInfix = this.parseBoolean(flag, true);
    }

    public void createQTerm() {
        this.queryEntry = new QueryEntry();
    }

    public void setQTName(String qTName_) {
        this.qTName = qTName_;
    }

    public void setQType(String qType_) {
        this.qType = qType_;
        if (this.qType != null) {
            try {
                this.queryEntry.setRowType(this.qType);
            }
            catch (TrexException e) {
                log.throwing("Can not set RowType. RowType: " + this.qType, (Throwable)e);
            }
        }
    }

    public void setValue1(String value1_) {
        this.value1 = value1_;
    }

    public void setValue2(String value2_) {
        this.value2 = value2_;
    }

    public void setQOperator(String qOperator_) {
        this.qOperator = qOperator_;
    }

    public void setContentType(String contentType) {
        try {
            byte[] buffer = contentType.getBytes();
            this.queryEntry.setContentType(buffer[0]);
        }
        catch (TrexException e) {
            log.throwing("Can not set ContentType. ContentType: " + contentType, (Throwable)e);
        }
    }

    public void setTermAction(String termAction) {
        try {
            byte[] buffer = termAction.getBytes();
            this.queryEntry.setTermAction(buffer[0]);
        }
        catch (TrexException e) {
            log.debugT("Can not set TermAction. TermAction: " + termAction);
        }
    }

    public void setTermWeight(String termWeight_) {
        this.termWeight = this.parseFloat(termWeight_);
        if (this.termWeight != null) {
            try {
                this.queryEntry.setTermWeight(this.termWeight.floatValue());
            }
            catch (TrexException e) {
                log.debugT("Can not set TermWeight. TermWeight: " + this.termWeight);
            }
        }
    }

    public void setFuzzySimilarity(String fuzzySimilarity_) {
        this.fuzzySimilarity = this.parseFloat(fuzzySimilarity_);
        if (this.fuzzySimilarity != null) {
            this.queryEntry.setFuzzySimilarity(this.fuzzySimilarity.floatValue());
        }
    }

    public void setQTerm() {
        try {
            if (this.qType.equalsIgnoreCase("A")) {
                this.queryEntry.setLocation(this.qTName);
            }
            this.queryEntry.setValue(this.value1, this.value2, this.qOperator);
            this.searchManager.addQueryEntry(this.queryEntry);
        }
        catch (TrexException e) {
            log.throwing("Can not set QueryEntry. value1: " + this.value1 + ", vaule2: " + this.value2 + ", qOperator: " + this.qOperator, (Throwable)e);
        }
        this.qTName = null;
        this.qType = null;
        this.value1 = null;
        this.value2 = null;
        this.qOperator = null;
        this.contentType = (byte)78;
        this.termAction = (byte)69;
        this.termWeight = null;
        this.fuzzySimilarity = null;
    }

    public void setWithAttributes(String withAttributes_) {
    }

    public void setMaxSimilarDocs(String maxSimilarDocs_) {
        Integer intValue = this.parseInt(maxSimilarDocs_);
        if (intValue != null) {
            this.maxSimilarDocs = intValue;
        }
        try {
            this.miningManager.setMaxResults(this.maxSimilarDocs);
        }
        catch (TrexException e) {
            log.throwing("Can not set MaxResults. MaxResults: " + this.maxSimilarDocs, (Throwable)e);
        }
    }

    public void setIntervalGetSimilarDocs() {
        try {
            this.miningManager.setResultFromTo(this.from, this.to);
        }
        catch (TrexException e) {
            log.throwing("Can not set ResultFromTo. From: " + this.from + ", To: " + this.to, (Throwable)e);
        }
    }

    public void setDocAttrListGetSimilarDocs() {
        if (!this.docAttrList.isEmpty()) {
            int i = 0;
            while (i < this.docAttrList.size()) {
                try {
                    this.miningManager.addRequestedAttribute((String)this.docAttrList.get(i));
                }
                catch (TrexException e) {
                    log.throwing("Can not add RequestedAttribute.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public void createDocList() {
    }

    public void setDocListGetSimilarDocs() {
    }

    public void setSortedByListGetSimilarDocs() {
        if (!this.sortedByList.isEmpty()) {
            int i = 0;
            while (i < this.sortedByList.size()) {
                SortedByContainer item = (SortedByContainer)this.sortedByList.get(i);
                try {
                    this.miningManager.addSortAttribute(item.getDocAttrName(), item.getSortAscending());
                }
                catch (TrexException e) {
                    log.throwing("Can not add SortAttribute.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public void setDocGroup(String docGroup_) {
        this.docGroup = docGroup_;
    }

    public void setDocID(String docID_) {
        this.docID = docID_;
    }

    public void setDocType(String docType_) {
        this.docType = this.parseDocType(docType_);
    }

    public void setCodePage(String codePage_) {
        this.codePage = codePage_;
    }

    public void setContent(String content_) {
        this.content = content_;
    }

    protected void setSearchManager(SearchManager searchManager_) {
        this.searchManager = searchManager_;
    }

    public void setDocument() {
        SearchDocument document = new SearchDocument();
        if (this.codePage != null && this.codePage.length() != 0) {
            document.setContentCodePage(this.codePage);
        }
        if (this.laiso != null && this.laiso.length() != 0) {
            document.setLanguage(this.laiso);
        }
        if (this.docID != null && this.docID.length() != 0) {
            document.setIndexDocumentId(this.docID);
        }
        if (this.docGroup != null && this.docGroup.length() != 0) {
            document.setDocumentGroup(this.docGroup);
        }
        switch (this.docType) {
            case 2: {
                if (this.content == null || this.content.length() == 0) break;
                document.setContent(this.content);
                break;
            }
            case 3: {
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] contentBytes = decoder.decodeBuffer(this.content);
                document.setContent(contentBytes);
                break;
            }
            case 4: {
                if (this.content == null || this.content.length() == 0) break;
                document.setFileName(this.content);
                break;
            }
            case 1: {
                if (this.content == null || this.content.length() == 0) break;
                document.setUrl(this.content);
            }
        }
        try {
            this.miningManager.addSearchDocument(document);
        }
        catch (TrexException e) {
            log.throwing("Can not add SearchDocument.", (Throwable)e);
        }
        this.docGroup = null;
        this.docID = null;
        this.docType = 0;
        this.codePage = null;
        this.content = null;
    }

    private byte[] getByteArray(String str) {
        byte[] ret = new byte[str.length()];
        int i = 0;
        while (i < str.length()) {
            ret[i] = (byte)str.charAt(i);
            ++i;
        }
        return ret;
    }

    protected void setMiningManager(TextMiningManager miningManager_) {
        this.miningManager = miningManager_;
    }

    private void setErrorForException(TrexReturn ret) {
        this.errorForException = ret;
    }

    private Integer parseInt(String param) {
        int intValue;
        Integer ret = null;
        try {
            intValue = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            TrexReturn ex = new TrexReturn(7260);
            this.setErrorForException(ex);
            return ret;
        }
        ret = new Integer(intValue);
        return ret;
    }

    private Float parseFloat(String param) {
        Float ret = null;
        float floatValue = 0.0f;
        try {
            floatValue = Float.parseFloat(param);
        }
        catch (NumberFormatException e) {
            TrexReturn ex = new TrexReturn(7260);
            this.setErrorForException(ex);
            return ret;
        }
        ret = new Float(floatValue);
        return ret;
    }

    private boolean parseBoolean(String param, boolean defaultValue) {
        boolean ret = defaultValue;
        if (param != null && param.compareToIgnoreCase("YES") == 0) {
            ret = true;
        } else if (param != null && param.compareToIgnoreCase("NO") == 0) {
            ret = false;
        }
        return ret;
    }

    private byte parseDocType(String docType) {
        int ret = 0;
        if (docType != null) {
            String dtUpperCase = docType.toUpperCase();
            if (dtUpperCase.equals("U")) {
                ret = 1;
            } else if (dtUpperCase.equals("T")) {
                ret = 2;
            } else if (dtUpperCase.equals("F")) {
                ret = 4;
            } else if (dtUpperCase.equals("D")) {
                ret = 7;
            } else if (dtUpperCase.equals("B")) {
                ret = 3;
            }
        }
        return (byte)ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SortedByContainer {
        private String docAttrName = null;
        private boolean sortAscending = true;

        public SortedByContainer(String docAttrName_) {
            this.docAttrName = docAttrName_;
        }

        public SortedByContainer(String docAttrName_, boolean sortAscending_) {
            this.docAttrName = docAttrName_;
            this.sortAscending = sortAscending_;
        }

        public void setDocAttrName(String docAttrName_) {
            this.docAttrName = docAttrName_;
        }

        public String getDocAttrName() {
            return this.docAttrName;
        }

        public void setSortAscending(boolean sortAscending_) {
            this.sortAscending = sortAscending_;
        }

        public boolean getSortAscending() {
            return this.sortAscending;
        }
    }
}

