/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchResultDoc;
import java.io.Serializable;
import java.util.ArrayList;

public class SimilarSearchResult
implements Serializable {
    private ArrayList m_resultDocs = new ArrayList();
    private int m_docCounter = 0;
    private TrexReturn m_return = null;
    private int m_noOfAllHitsInIndex;
    private int m_indexSize;

    public TrexReturn getErrorCode() {
        if (this.m_return == null) {
            this.m_return = new TrexReturn(0);
        }
        return this.m_return;
    }

    protected void setErrorCode(TrexReturn return_) {
        this.m_return = return_;
    }

    protected void setNoOfAllHitsInIndex(int noOfAllHitsInIndex) {
        this.m_noOfAllHitsInIndex = noOfAllHitsInIndex;
    }

    public int getNoOfAllHitsInIndex() {
        return this.m_noOfAllHitsInIndex;
    }

    protected void setIndexSize(int indexSize) {
        this.m_indexSize = indexSize;
    }

    public int getIndexSize() {
        return this.m_indexSize;
    }

    public int size() {
        return this.m_resultDocs.size();
    }

    public SearchResultDoc getFirstDocument() {
        ResultDocument rdoc = this.getFirstResultDocument();
        return this.convert(rdoc);
    }

    public SearchResultDoc getNextDocument() {
        ResultDocument rdoc = this.getNextResultDocument();
        return this.convert(rdoc);
    }

    protected void addResultDocument(ResultDocument doc) throws TrexException {
        this.m_resultDocs.add(doc);
    }

    public ResultDocument getFirstResultDocument() {
        this.m_docCounter = 0;
        return this.getNextResultDocument();
    }

    public ResultDocument getNextResultDocument() {
        if (this.m_docCounter < this.m_resultDocs.size()) {
            ResultDocument doc = (ResultDocument)this.m_resultDocs.get(this.m_docCounter);
            ++this.m_docCounter;
            return doc;
        }
        return null;
    }

    private SearchResultDoc convert(ResultDocument rdoc) {
        if (rdoc == null) {
            return null;
        }
        SearchResultDoc sdoc = new SearchResultDoc();
        try {
            sdoc.setDocumentKey(rdoc.getDocumentKey());
            sdoc.setLanguage(rdoc.getDocumentLanguage());
        }
        catch (Exception e) {
            // empty catch block
        }
        sdoc.setDocumentStatus(rdoc.getDocumentStatus());
        sdoc.setRankValue(rdoc.getRankValue());
        sdoc.addDocumentAttributes(rdoc.getDocAttributes());
        IndexId indexId = rdoc.getIndexId();
        if (indexId != null) {
            try {
                sdoc.addIndexId(indexId.getIndexName(), indexId.getSearchEngine());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sdoc;
    }
}

