/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.AttributeDistribution;
import com.sapportals.trex.core.AttributeDistributionOverview;
import com.sapportals.trex.core.AttributeDistributionRange;
import com.sapportals.trex.core.AttributeDistributionValue;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchResultDoc;
import java.io.Serializable;
import java.util.ArrayList;

public class SearchResult
implements Serializable {
    private ArrayList m_resultDocs = new ArrayList();
    private int m_docCounter = 0;
    private ArrayList m_administeredResultDocs = null;
    private int m_administeredDocCounter = 0;
    private ArrayList m_adaptedQueryEntries = new ArrayList();
    private int m_queryEntryCounter = 0;
    private ArrayList m_attributeDistributions = null;
    private ArrayList m_attributeDistributionOverviews = null;
    private int m_distributionsCounter = 0;
    private int m_overviewsCounter = 0;
    private int m_noOfAllHitsInIndex = 0;
    private int m_noOfHits = 0;
    private int m_indexSize = 0;
    public static byte DOCUMENTS_REQUESTED = 1;
    public static byte ATTRIBUTE_DISTRIBUTION_REQUESTED = (byte)2;
    public static byte ATTRIBUTE_DISTRIBUTION_OVERVIEW_REQUESTED = (byte)3;
    private byte m_requestedSearchResults = 1;
    private TrexReturn m_return = null;

    protected void setNoOfAllHitsInIndex(int noOfAllHitsInIndex) {
        this.m_noOfAllHitsInIndex = noOfAllHitsInIndex;
    }

    public int getNoOfAllHitsInIndex() {
        return this.m_noOfAllHitsInIndex;
    }

    protected void setNoOfHits(int number) {
        this.m_noOfHits = number;
    }

    public int getNoOfHits() {
        return this.m_noOfHits;
    }

    protected void setIndexSize(int indexSize) {
        this.m_indexSize = indexSize;
    }

    public int getIndexSize() {
        return this.m_indexSize;
    }

    public int size() {
        return this.m_resultDocs.size();
    }

    public SearchResultDoc getFirstDocument() {
        ResultDocument rdoc = this.getFirstResultDocument();
        return this.convert(rdoc);
    }

    public SearchResultDoc getNextDocument() {
        ResultDocument rdoc = this.getNextResultDocument();
        return this.convert(rdoc);
    }

    protected void addResultDocument(ResultDocument doc) throws TrexException {
        this.m_resultDocs.add(doc);
    }

    public ResultDocument getFirstResultDocument() {
        this.m_docCounter = 0;
        return this.getNextResultDocument();
    }

    public ResultDocument getNextResultDocument() {
        if (this.m_docCounter < this.m_resultDocs.size()) {
            ResultDocument doc = (ResultDocument)this.m_resultDocs.get(this.m_docCounter);
            ++this.m_docCounter;
            return doc;
        }
        return null;
    }

    public ArrayList getResultDocuments() {
        return this.m_resultDocs;
    }

    public void setRequestedSearchResults(byte requestedResults) {
        this.m_requestedSearchResults = requestedResults;
    }

    public byte getRequestedSearchResults() {
        return this.m_requestedSearchResults;
    }

    protected void addAdaptedQueryEntry(QueryEntry queryEntry) {
        this.m_adaptedQueryEntries.add(queryEntry);
    }

    protected void setAdaptedQueryEntries(ArrayList queryEntries) {
        this.m_adaptedQueryEntries = queryEntries;
    }

    public int countAdaptedQueryEntries() {
        return this.m_adaptedQueryEntries.size();
    }

    public QueryEntry getFirstAdaptedQueryEntry() {
        this.m_queryEntryCounter = 0;
        return this.getNextAdaptedQueryEntry();
    }

    public QueryEntry getNextAdaptedQueryEntry() {
        if (this.m_queryEntryCounter < this.m_adaptedQueryEntries.size()) {
            QueryEntry qe = (QueryEntry)this.m_adaptedQueryEntries.get(this.m_queryEntryCounter);
            ++this.m_queryEntryCounter;
            return qe;
        }
        return null;
    }

    protected ArrayList getAdaptedQueryEntries() {
        return this.m_adaptedQueryEntries;
    }

    protected void addAdministeredResultDocument(ResultDocument doc) throws TrexException {
        if (this.m_administeredResultDocs == null) {
            this.m_administeredResultDocs = new ArrayList();
        }
        this.m_administeredResultDocs.add(doc);
    }

    public ResultDocument getFirstAdministeredResultDocument() {
        this.m_administeredDocCounter = 0;
        return this.getNextAdministeredResultDocument();
    }

    public ResultDocument getNextAdministeredResultDocument() {
        if (this.m_administeredResultDocs != null && this.m_administeredDocCounter < this.m_administeredResultDocs.size()) {
            ResultDocument doc = (ResultDocument)this.m_administeredResultDocs.get(this.m_administeredDocCounter);
            ++this.m_administeredDocCounter;
            return doc;
        }
        return null;
    }

    public int countAdministeredResultDocuments() {
        if (this.m_administeredResultDocs == null) {
            return 0;
        }
        return this.m_administeredResultDocs.size();
    }

    protected void addAttributeDistribution(AttributeDistribution ad) {
        if (this.m_attributeDistributions == null) {
            this.m_attributeDistributions = new ArrayList();
        }
        this.m_attributeDistributions.add(ad);
    }

    public int countAttributeDistributions() {
        if (this.m_attributeDistributions == null) {
            return 0;
        }
        return this.m_attributeDistributions.size();
    }

    public AttributeDistribution getFirstAttributeDistribution() {
        this.m_distributionsCounter = 0;
        return this.getNextAttributeDistribution();
    }

    public AttributeDistribution getNextAttributeDistribution() {
        if (this.m_attributeDistributions != null && this.m_distributionsCounter < this.m_attributeDistributions.size()) {
            AttributeDistribution ad = (AttributeDistribution)this.m_attributeDistributions.get(this.m_distributionsCounter);
            ++this.m_distributionsCounter;
            return ad;
        }
        return null;
    }

    public int countAttributeDistributionValues() {
        if (this.m_attributeDistributions == null) {
            return 0;
        }
        return ((AttributeDistribution)this.m_attributeDistributions.get(0)).countAttributeDistributionValues();
    }

    public AttributeDistributionValue getFirstAttributeDistributionValue() {
        if (this.m_attributeDistributions != null) {
            return ((AttributeDistribution)this.m_attributeDistributions.get(0)).getFirstAttributeDistributionValue();
        }
        return null;
    }

    public AttributeDistributionValue getNextAttributeDistributionValue() {
        if (this.m_attributeDistributions != null) {
            return ((AttributeDistribution)this.m_attributeDistributions.get(0)).getNextAttributeDistributionValue();
        }
        return null;
    }

    public int countAttributeDistributionRanges() {
        if (this.m_attributeDistributions != null) {
            return ((AttributeDistribution)this.m_attributeDistributions.get(0)).countAttributeDistributionRanges();
        }
        return 0;
    }

    public AttributeDistributionRange getFirstAttributeDistributionRange() {
        if (this.m_attributeDistributions != null) {
            return ((AttributeDistribution)this.m_attributeDistributions.get(0)).getFirstAttributeDistributionRange();
        }
        return null;
    }

    public AttributeDistributionRange getNextAttributeDistributionRange() {
        if (this.m_attributeDistributions != null) {
            return ((AttributeDistribution)this.m_attributeDistributions.get(0)).getNextAttributeDistributionRange();
        }
        return null;
    }

    protected void addAttributeDistributionOverview(AttributeDistributionOverview ado) {
        if (this.m_attributeDistributionOverviews == null) {
            this.m_attributeDistributionOverviews = new ArrayList();
        }
        this.m_attributeDistributionOverviews.add(ado);
    }

    public int countAttributeDistributionOverviews() {
        if (this.m_attributeDistributionOverviews == null) {
            return 0;
        }
        return this.m_attributeDistributionOverviews.size();
    }

    public AttributeDistributionOverview getFirstAttributeDistributionOverview() {
        this.m_overviewsCounter = 0;
        return this.getNextAttributeDistributionOverview();
    }

    public AttributeDistributionOverview getNextAttributeDistributionOverview() {
        if (this.m_attributeDistributionOverviews != null && this.m_overviewsCounter < this.m_attributeDistributionOverviews.size()) {
            AttributeDistributionOverview adv = (AttributeDistributionOverview)this.m_attributeDistributionOverviews.get(this.m_overviewsCounter);
            ++this.m_overviewsCounter;
            return adv;
        }
        return null;
    }

    public TrexReturn getLastError() {
        if (this.m_return == null) {
            this.m_return = new TrexReturn(0);
        }
        return this.m_return;
    }

    protected void setLastError(TrexReturn return_) {
        this.m_return = return_;
    }

    private SearchResultDoc convert(ResultDocument rdoc) {
        if (rdoc == null) {
            return null;
        }
        SearchResultDoc sdoc = new SearchResultDoc();
        try {
            sdoc.setDocumentKey(rdoc.getDocumentKey());
            sdoc.setLanguage(rdoc.getDocumentLanguage());
        }
        catch (Exception e) {
            // empty catch block
        }
        sdoc.setDocumentStatus(rdoc.getDocumentStatus());
        sdoc.setRankValue(rdoc.getRankValue());
        sdoc.addDocumentAttributes(rdoc.getDocAttributes());
        IndexId indexId = rdoc.getIndexId();
        if (indexId != null) {
            try {
                sdoc.addIndexId(indexId.getIndexName(), indexId.getSearchEngine());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sdoc;
    }
}

