/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractSearch;
import com.sapportals.trex.core.AttributeDistributionDefinition;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.HttpSearch;
import com.sapportals.trex.core.IndexId;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.ResultDocument;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.SortAttribute;
import com.sapportals.trex.core.TMRequestParser;
import com.sapportals.trex.core.TrexConfigManager;
import com.sapportals.trex.core.TrexFactory;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.Location;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import com.sapportals.trex.util.cache.CacheManager;
import com.sapportals.trex.util.cache.WrappedCache;
import com.sapportals.trex.util.cache.WrappedCacheEntry;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SearchManager
extends BaseManager {
    public static byte TREX_SEARCH_REQUEST_DIDYOUMEAN = 1;
    public static byte TREX_SEARCH_REQUEST_CONTENTSNIPPETS = (byte)2;
    public static byte TREX_SEARCH_REQUEST_TITLESNIPPET = (byte)4;
    public static byte TREX_SEARCH_REQUEST_SUGGESTEDSIMITERMS = (byte)8;
    public static byte TREX_SEARCH_REQUEST_SPONSOREDLINKS = (byte)16;
    public static byte TREX_SEARCH_REQUEST_ADMINISTRATEDLINKS = (byte)32;
    public static byte DOCUMENTS_REQUESTED = 1;
    public static byte ATTRIBUTE_DISTRIBUTION_REQUESTED = (byte)2;
    public static byte ATTRIBUTE_DISTRIBUTION_OVERVIEW_REQUESTED = (byte)3;
    public static final String ATTRIBUTE_DISTRIBUTION_ALGORITHM_EQUIDISTANCE = "equiDistance";
    public static final String ATTRIBUTE_DISTRIBUTION_ALGORITHM_EQUIDISTRIBUTION = "equiDistribution";
    public static final String ATTRIBUTE_DISTRIBUTION_ALGORITHM_TYPE_SPECIFIC = "typeSpecific";
    public static final String ATTRIBUTE_DISTRIBUTION_ALGORITHM_CLUSTERING = "clustering";
    private List m_queryEntryList = new ArrayList();
    private List m_attributeList = new ArrayList();
    private List m_indexList = new ArrayList();
    private List m_sortAttributeList = new ArrayList();
    private boolean m_httpserverManuallySet = false;
    private String m_httpserverurl;
    private List m_highlightAttributes = null;
    private int m_from = 1;
    private int m_to = 0;
    private byte m_requestFlags;
    private byte m_requestedSearchResults = 1;
    private int m_maxSnippetWords;
    private int m_oneSnippetWords;
    private boolean m_ignoreMissingLanguageIndex = false;
    private int m_optimalNumberOfValues = 10;
    private int m_maxNumberOfReturnValues = 50;
    private List m_attributeDistributionDefinitionList = new ArrayList();
    private int m_maxResults = 50;
    private boolean m_countOnlyFlag = false;
    private Location m_indexServerLocation = null;
    private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation((String)(class$com$sapportals$trex$core$SearchManager == null ? (class$com$sapportals$trex$core$SearchManager = SearchManager.class$("com.sapportals.trex.core.SearchManager")) : class$com$sapportals$trex$core$SearchManager).getName());
    static /* synthetic */ Class class$com$sapportals$trex$core$SearchManager;

    public SearchResult search() throws TrexException {
        SearchResult result = null;
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:SEARCH");
            if (this.m_indexList.isEmpty()) {
                throw new TrexException(7230);
            }
            this.consistencyCheckOfInterval();
            result = this.performSearch(this.m_indexList);
            if (log.beDebug()) {
                log.debugT("Error code: " + result.getLastError().getCode() + ", message: " + result.getLastError().getMsg());
                ResultDocument doc = result.getFirstResultDocument();
                int i = 0;
                while (i < result.size()) {
                    log.debugT("Result document " + i + ": " + doc.getDocumentKey() + ", rank value: " + doc.getRankValue());
                    doc = result.getNextResultDocument();
                    ++i;
                }
            }
            SearchResult searchResult = result;
            Object var6_5 = null;
            monitor.endComponent("EP:KM:TREX:SEARCH");
            monitor.endRequest();
            monitor = null;
            return searchResult;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.endComponent("EP:KM:TREX:SEARCH");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void addIndexId(String indexName, String language) throws TrexException {
        TrexConfigManager conf = TrexFactory.getTrexConfigManager();
        IndexId indexId = conf.getIndexId(indexName);
        indexId.setLanguage(language);
        this.m_indexList.add(indexId);
    }

    public void addIndexId(String indexName, String searchEngine, String language, String mode, String host, int port, String file) throws TrexException {
        IndexId indexId = new IndexId();
        indexId.setIndexName(indexName, searchEngine, language);
        if (mode.equals("http") || mode.equals("https")) {
            indexId.setHttpServerUrl(mode, host, port, file);
        }
        this.m_indexList.add(indexId);
        if (log.beDebug()) {
            log.debugT("Index '" + indexName + "': parameters were set manually to mode '" + mode + "', host '" + host + "', port '" + port + "', file '" + file + "', search engine '" + searchEngine + "', language '" + language + "'");
        }
    }

    public void addSearchEngine(String searchEngine) throws TrexException {
        if (searchEngine == null || searchEngine.length() == 0 || searchEngine.equals("DRFUZZY") || searchEngine.equals("VERITY") || searchEngine.equals("FULCRUM")) {
            throw new TrexException(7203, "searchEngine", searchEngine, "addSearchEngine", (class$com$sapportals$trex$core$SearchManager == null ? (class$com$sapportals$trex$core$SearchManager = SearchManager.class$("com.sapportals.trex.core.SearchManager")) : class$com$sapportals$trex$core$SearchManager).getName());
        }
        IndexId indexId = new IndexId();
        indexId.setIndexName(searchEngine);
        indexId.setSearchEngine(searchEngine);
        this.m_indexList.add(indexId);
    }

    public void addRequestedAttribute(String name) throws TrexException {
        this.m_attributeList.add(name);
    }

    public void addQueryEntry(QueryEntry queryEntry) throws TrexException {
        this.m_queryEntryList.add(queryEntry);
    }

    public void setResultFromTo(int from, int to) throws TrexException {
        this.m_from = from;
        this.m_to = to;
    }

    public void setMaxResults(int max) throws TrexException {
        this.m_maxResults = max;
    }

    public void setMaxSnippetWords(int maxWords) {
        this.m_maxSnippetWords = maxWords;
    }

    protected int getMaxSnippetWords() {
        return this.m_maxSnippetWords;
    }

    public void setOneSnippetWords(int maxWords) {
        this.m_oneSnippetWords = maxWords;
    }

    protected int getOneSnippetWords() {
        return this.m_oneSnippetWords;
    }

    public void setRequestFlag(byte requestFlag, boolean value) {
        this.m_requestFlags = value ? (byte)(this.m_requestFlags | requestFlag) : (byte)(this.m_requestFlags & (0xFFFFFFFF & ~requestFlag));
    }

    protected boolean getRequestFlag(byte requestFlag) {
        return (this.m_requestFlags & requestFlag) > 0;
    }

    public void setRequestedSearchResults(byte requestedResults) {
        this.m_requestedSearchResults = requestedResults;
    }

    public void setCountOnlyFlag(boolean countOnly) {
        this.m_countOnlyFlag = countOnly;
    }

    public byte getRequestedSearchResults() {
        return this.m_requestedSearchResults;
    }

    public void ignoreMissingLanguageIndex(boolean flag) {
        this.m_ignoreMissingLanguageIndex = flag;
    }

    public void addAttributeDistributionDefinition(AttributeDistributionDefinition attrDef) {
        this.m_attributeDistributionDefinitionList.add(attrDef);
    }

    public void addAttributeDistributionDefinition(String attrName, float browsingRelevance, int defaultClusterSize, String algorithm, String groupingRanges) {
        this.m_attributeDistributionDefinitionList.add(new AttributeDistributionDefinition(attrName, browsingRelevance, defaultClusterSize, algorithm, groupingRanges));
    }

    public void setOptimalNumberOfValues(int optimalNumberOfValues) {
        this.m_optimalNumberOfValues = optimalNumberOfValues;
    }

    public void setMaxNumberOfValues(int maxNumberOfReturnValues) {
        this.m_maxNumberOfReturnValues = maxNumberOfReturnValues;
    }

    public void setIndexServerLocation(String host, int port) {
        this.m_indexServerLocation = new Location(host, port);
    }

    public void addSortAttribute(String name, boolean sortAscending) throws TrexException {
        this.m_sortAttributeList.add(new SortAttribute(name, sortAscending));
    }

    public void addHighlightAttribute(String name) throws TrexException {
        if (this.m_highlightAttributes == null) {
            this.m_highlightAttributes = new ArrayList();
        }
        this.m_highlightAttributes.add(name);
    }

    private SearchResult performSearch(List indexIds) throws TrexException {
        if (indexIds.isEmpty()) {
            return new SearchResult();
        }
        AbstractSearch search = this.getNewSearchObject((IndexId)indexIds.get(0));
        this.transferParametersToSearch(indexIds, search);
        SearchResult newResult = null;
        boolean cacheEnabled = false;
        String resultKey = "";
        WrappedCache cache = this.getCache();
        if (cache != null && (resultKey = this.getStringRepresentationOfQuery(search)) != null) {
            cacheEnabled = true;
        }
        boolean executeSearch = true;
        if (cacheEnabled) {
            try {
                WrappedCacheEntry cacheEntry = cache.getEntry(resultKey);
                newResult = (SearchResult)cacheEntry.getObject();
            }
            catch (Exception e) {
                newResult = null;
            }
            if (newResult == null) {
                executeSearch = true;
                log.debugT("Search result not in cache");
            } else {
                executeSearch = false;
                log.infoT("Search result found in cache");
            }
        }
        if (executeSearch) {
            if (log.beInfo()) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < indexIds.size()) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append("'");
                    sb.append(((IndexId)indexIds.get(i)).getIndexName());
                    sb.append("' (" + ((IndexId)indexIds.get(i)).getSearchEngine() + ")");
                    ++i;
                }
                log.infoT("Search started (search index " + sb.toString() + ")");
            }
            newResult = search.search();
            log.infoT("Search finished");
            if (cacheEnabled) {
                try {
                    cache.addEntry(resultKey, newResult);
                    log.debugT("Search result is added to cache");
                }
                catch (Exception e) {
                    log.debugT("Search result could not be added to cache. Reason: " + e.getMessage());
                }
            }
        }
        if (log.beDebug() && newResult != null) {
            log.debugT("Number of documents found: " + newResult.size());
        }
        return newResult;
    }

    protected String getXML() throws TrexException {
        HttpSearch search = new HttpSearch();
        StringBuffer sbuf = null;
        String ret = null;
        this.transferParametersToSearch(this.m_indexList, search);
        sbuf = this.getXML(search);
        if (sbuf != null) {
            ret = sbuf.toString();
        }
        return ret;
    }

    protected void setXML(String xml) throws TrexException {
        TMRequestParser parser = null;
        try {
            parser = new TMRequestParser(this);
        }
        catch (ParserConfigurationException e1) {
            log.throwing("Exception: ", (Throwable)e1);
            throw new TrexException(7268, "TMRequestParser");
        }
        catch (SAXException e2) {
            log.throwing("Exception: ", (Throwable)e2);
            throw new TrexException(7268, "TMRequestParser");
        }
        try {
            parser.parse(xml);
        }
        catch (SAXException e1) {
            log.throwing("Exception: ", (Throwable)e1);
            throw new TrexException(7269, (class$com$sapportals$trex$core$SearchManager == null ? (class$com$sapportals$trex$core$SearchManager = SearchManager.class$("com.sapportals.trex.core.SearchManager")) : class$com$sapportals$trex$core$SearchManager).getName(), "TMRequestParser");
        }
        catch (IOException e2) {
            log.throwing("Exception: ", (Throwable)e2);
            throw new TrexException(7269, (class$com$sapportals$trex$core$SearchManager == null ? (class$com$sapportals$trex$core$SearchManager = SearchManager.class$("com.sapportals.trex.core.SearchManager")) : class$com$sapportals$trex$core$SearchManager).getName(), "TMRequestParser");
        }
    }

    private void transferParametersToSearch(List indexList, AbstractSearch search) throws TrexException {
        search.addIndexIds(indexList);
        search.addQueryEntries(this.m_queryEntryList);
        search.addRequestedAttributes(this.m_attributeList);
        search.addSortAttributes(this.m_sortAttributeList);
        search.addHighlightAttributes(this.m_highlightAttributes);
        search.setResultFromTo(this.m_from, this.m_to);
        search.setMaxSnippetWords(this.m_maxSnippetWords);
        search.setOneSnippetWords(this.m_oneSnippetWords);
        search.setRequestFlags(this.m_requestFlags);
        search.setRequestedSearchResults(this.m_requestedSearchResults);
        search.ignoreMissingLanguageIndex(this.m_ignoreMissingLanguageIndex);
        search.setIndexServerLocation(this.m_indexServerLocation);
        search.setAttributeDistributionDefinitionList(this.m_attributeDistributionDefinitionList);
        search.setOptimalNumberOfValues(this.m_optimalNumberOfValues);
        search.setCountOnlyFlag(this.m_countOnlyFlag);
        search.setMaxNumberOfReturnValues(this.m_maxNumberOfReturnValues);
    }

    private StringBuffer getXML(AbstractSearch search) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter w = new XMLWriter();
        StringBuffer ret = null;
        if (w != null) {
            w.setOutput(stringWriter);
            try {
                search.formatSearchRequest(w);
            }
            catch (Exception e) {
                log.warningT("Cannot get search request as xml. Exception: " + e.getMessage());
                return null;
            }
            ret = stringWriter.getBuffer();
            log.debugT("XML Request: " + ret);
        }
        return ret;
    }

    private String getStringRepresentationOfQuery(AbstractSearch search) {
        String ret = "";
        StringBuffer sbuf = null;
        sbuf = this.getXML(search);
        if (sbuf != null) {
            ret = sbuf.toString();
        }
        return ret;
    }

    private void consistencyCheckOfInterval() {
        if (this.m_maxResults == 0) {
            this.m_maxResults = 50;
        }
        if (this.m_from == 0) {
            this.m_from = 1;
        }
        if (this.m_to == 0) {
            this.m_to = this.m_from + this.m_maxResults - 1;
        }
    }

    private WrappedCache getCache() throws TrexException {
        TrexConfigManager conf = TrexFactory.getTrexConfigManager();
        CacheManager cm = CacheManager.getInstance();
        WrappedCache cache = null;
        if (conf == null) {
            log.debugT("TrexConfigManager could not be initialized");
        } else if (cm != null) {
            boolean useCache = conf.getUseCache();
            if (useCache) {
                String cacheName = conf.getCacheName();
                if (cacheName == null) {
                    cache = null;
                    log.debugT("CacheManager not configured");
                } else {
                    cache = cm.getCache(cacheName);
                }
            } else {
                cache = null;
                log.debugT("Cache is switched off");
                return null;
            }
        }
        if (cache == null) {
            log.debugT("CacheManager not loaded, all results are uncached");
        }
        return cache;
    }

    private AbstractSearch getNewSearchObject(IndexId index) throws TrexException {
        HttpSearch httpsearch = new HttpSearch();
        httpsearch.setIndexUser(this.m_indexUser);
        httpsearch.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverManuallySet) {
            httpsearch.setHttpServerManuallySet(this.m_httpserverManuallySet);
            try {
                httpsearch.setUrl(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException ex) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        return httpsearch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

