/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.QueryTermInfo;
import com.sapportals.trex.util.xmlwriter.XMLWriter;
import java.util.ArrayList;

public class QueryEntry {
    public static final byte CONTENT_TYPE_CONTENT = 67;
    public static final byte CONTENT_TYPE_AND = 65;
    public static final byte CONTENT_TYPE_OR = 79;
    public static final byte CONTENT_TYPE_PHRASE = 80;
    public static final byte CONTENT_TYPE_STRING = 83;
    public static final byte CONTENT_TYPE_DATE = 68;
    public static final byte CONTENT_TYPE_INTEGER = 73;
    public static final byte CONTENT_TYPE_FLOAT = 70;
    public static final byte CONTENT_TYPE_TIME = 84;
    public static final byte CONTENT_TYPE_TEXT = 78;
    public static final byte CONTENT_TYPE_ZONE = 90;
    public static final String ATTRIBUTE_OPERATOR_EQ = "EQ";
    public static final String ATTRIBUTE_OPERATOR_NE = "NE";
    public static final String ATTRIBUTE_OPERATOR_GT = "GT";
    public static final String ATTRIBUTE_OPERATOR_LT = "LT";
    public static final String ATTRIBUTE_OPERATOR_GE = "GE";
    public static final String ATTRIBUTE_OPERATOR_LE = "LE";
    public static final String ATTRIBUTE_OPERATOR_BT = "BT";
    public static final String QUERY_OPERATOR_NOT = "NOT";
    public static final String QUERY_OPERATOR_AND = "AND";
    public static final String QUERY_OPERATOR_OR = "OR";
    public static final String QUERY_OPERATOR_NEAR = "NEAR";
    public static final String ROW_TYPE_TERM = "TERM";
    public static final String ROW_TYPE_ATTRIBUTE = "ATTRIBUTE";
    public static final String ROW_TYPE_OPERATOR = "OPERATOR";
    public static final String ROW_TYPE_BRACKET_OPEN = "(";
    public static final String ROW_TYPE_BRACKET_CLOSE = ")";
    public static final String ROW_TYPE_EXPRESSION = "EXPRESSION";
    public static final byte TERM_ACTION_LINGUISTIC = 76;
    public static final byte TERM_ACTION_FUZZY = 70;
    public static final byte TERM_ACTION_EXACT = 69;
    public static final byte TERM_ACTION_WORD = 87;
    public static final byte TERM_ACTION_SOUNDEX = 83;
    public static final byte TERM_ACTION_NATURAL_TEXT = 78;
    public static final byte TERM_ACTION_TAXONOMY_EXPANSION = 84;
    public static final byte TERM_ACTION_NEAR_WIDTH = 88;
    public static final byte TERM_ACTION_NEAR_UNORDERED = 85;
    public static final byte TERM_ACTION_NEAR_ORDERED = 79;
    public static final byte TERM_ACTION_PHRASE_NEAR_RANK = 86;
    public static final byte NEAR_ORDER_ORDERED = 0;
    public static final byte NEAR_ORDER_UNORDERED = 1;
    public static final byte NEAR_RANKING_DISTANCE_RANKING = 0;
    public static final byte NEAR_RANKING_FREQUENCY_RANKING = 1;
    public static final byte NEAR_RANKING_COMBINED_RANKING = 2;
    private String m_value1 = null;
    private String m_value2 = null;
    private String m_queryOperator = "EQ";
    private byte m_termAction = (byte)69;
    private String m_location = null;
    private String m_rowType = "TERM";
    private byte m_contentType = (byte)78;
    private float m_termWeight = 1.0f;
    private float m_fuzzySimilarity = 1.0f;
    private int m_nearWidth = -1;
    private int m_nearOrder = -1;
    private int m_nearRanking = -1;
    private int m_searchTermFlags = -1;
    private ArrayList m_queryTermInfos;
    private int m_queryTermCounter;

    public void setValue(String value1, String value2, String queryOperator) throws TrexException {
        this.m_value1 = value1;
        this.m_value2 = value2;
        this.m_queryOperator = queryOperator;
    }

    public void setQueryString(String queryString) throws TrexException {
        this.m_value1 = queryString;
        this.m_value2 = null;
        this.m_rowType = ROW_TYPE_EXPRESSION;
        this.m_queryOperator = ATTRIBUTE_OPERATOR_EQ;
    }

    public void setLocation(String location) throws TrexException {
        this.m_location = location;
    }

    public void setRowType(String rowType) throws TrexException {
        this.m_rowType = rowType;
    }

    public void setContentType(byte contentType) throws TrexException {
        this.m_contentType = contentType;
    }

    public void setTermWeight(float weight) throws TrexException {
        this.m_termWeight = weight;
    }

    public void setTermAction(byte termAction) throws TrexException {
        this.m_termAction = termAction;
    }

    public void setFuzzySimilarity(float fuzzySimilarity) {
        this.m_fuzzySimilarity = fuzzySimilarity;
    }

    public void setPhraseParameter(int nearWidth, int nearOrder, int nearRanking) {
        this.m_nearWidth = nearWidth;
        this.m_nearOrder = nearOrder;
        this.m_nearRanking = nearRanking;
    }

    public void setPhraseParameter(int nearWidth, int nearOrder, int nearRanking, int searchTermFlags) {
        this.m_nearWidth = nearWidth;
        this.m_nearOrder = nearOrder;
        this.m_nearRanking = nearRanking;
        this.m_searchTermFlags = searchTermFlags;
    }

    protected void setNearWidth(int nearWidth) {
        this.m_nearWidth = nearWidth;
    }

    protected void setNearOrder(int nearOrder) {
        this.m_nearOrder = nearOrder;
    }

    protected void setNearRanking(int nearRanking) {
        this.m_nearRanking = nearRanking;
    }

    public void setSearchTermFlags(int searchTermFlags) {
        this.m_searchTermFlags = searchTermFlags;
    }

    public byte getTermAction() {
        return this.m_termAction;
    }

    public float getTermWeight() {
        return this.m_termWeight;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getRowType() {
        return this.m_rowType;
    }

    public byte getContentType() {
        return this.m_contentType;
    }

    public String getValue1() {
        return this.m_value1;
    }

    public String getValue2() {
        return this.m_value2;
    }

    public String getOperator() {
        return this.m_queryOperator;
    }

    public float getFuzzySimilarity() {
        return this.m_fuzzySimilarity;
    }

    public int getNearWidth() {
        return this.m_nearWidth;
    }

    public int getNearOrder() {
        return this.m_nearOrder;
    }

    public int getNearRanking() {
        return this.m_nearRanking;
    }

    public int getSearchTermFlags() {
        return this.m_searchTermFlags;
    }

    protected void addTermInfo(QueryTermInfo info) {
        if (this.m_queryTermInfos == null) {
            this.m_queryTermInfos = new ArrayList();
        }
        this.m_queryTermInfos.add(info);
    }

    public int countTermInfos() {
        if (this.m_queryTermInfos == null) {
            return 0;
        }
        return this.m_queryTermInfos.size();
    }

    public QueryTermInfo getFirstTermInfo() {
        this.m_queryTermCounter = 0;
        return this.getNextTermInfo();
    }

    public QueryTermInfo getNextTermInfo() {
        if (this.m_queryTermInfos == null) {
            return null;
        }
        if (this.m_queryTermCounter < this.m_queryTermInfos.size()) {
            QueryTermInfo qti = (QueryTermInfo)this.m_queryTermInfos.get(this.m_queryTermCounter);
            ++this.m_queryTermCounter;
            return qti;
        }
        return null;
    }

    protected void format(XMLWriter w) throws Exception {
        byte[] b = new byte[1];
        w.startElement("QTerm");
        if (this.getLocation() != null) {
            w.dataElement("QTName", this.getLocation());
        }
        w.dataElement("QType", String.valueOf(this.getRowType()));
        if (this.getValue1() != null && this.getValue1().length() > 0) {
            w.dataElement("Value1", this.getValue1());
        } else {
            w.dataElement("Value1", "");
        }
        if (this.getValue2() != null && this.getValue2().length() > 0) {
            w.dataElement("Value2", this.getValue2());
        }
        if (this.getOperator() != null) {
            w.dataElement("QOperator", this.getOperator());
        }
        b[0] = this.getContentType();
        w.dataElement("ContentType", new String(b));
        b[0] = this.getTermAction();
        w.dataElement("TermAction", new String(b));
        w.dataElement("TermWeight", String.valueOf(this.getTermWeight()));
        if (this.getTermAction() == 70) {
            w.dataElement("FuzzySimilarity", String.valueOf(this.getFuzzySimilarity()));
        }
        if (this.getNearWidth() >= 0) {
            w.dataElement("NearWidth", String.valueOf(this.getNearWidth()));
        }
        if (this.getNearOrder() >= 0) {
            w.dataElement("NearOrder", String.valueOf(this.getNearOrder()));
        }
        if (this.getNearRanking() >= 0) {
            w.dataElement("NearRankMethod", String.valueOf(this.getNearRanking()));
        }
        if (this.getSearchTermFlags() >= 0) {
            w.dataElement("SearchTermFlags", String.valueOf(this.getSearchTermFlags()));
        }
        w.endElement("QTerm");
    }
}

