/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractIndex;
import com.sapportals.trex.core.AttributeContainer;
import com.sapportals.trex.core.BaseManager;
import com.sapportals.trex.core.HttpIndex;
import com.sapportals.trex.core.IndexDocument;
import com.sapportals.trex.core.util.HttpServerURL;
import com.sapportals.trex.core.util.jARM.TREXIMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexManager
extends BaseManager {
    private String ADD_ATTRIBUTE_VALUE = "addValue";
    private String REMOVE_ATTRIBUTE_VALUE = "removeValue";
    private String REMOVE_ALL_ATTRIBUTE_VALUES = "removeAllValues";
    private List docList = new ArrayList();
    private String searchEngine = "DRFUZZY";
    private String m_httpserverurl;
    private String indexName;
    private String m_indexId;
    private String language;
    private AbstractIndex index;
    private boolean queueServerFlag = true;
    private boolean m_httpserverManuallySet = false;
    private List attributes = new ArrayList();
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$core$IndexManager == null ? (class$com$sapportals$trex$core$IndexManager = IndexManager.class$("com.sapportals.trex.core.IndexManager")) : class$com$sapportals$trex$core$IndexManager).getName());
    static /* synthetic */ Class class$com$sapportals$trex$core$IndexManager;

    public void setSearchEngine(String searchEngine) throws TrexException {
        this.searchEngine = searchEngine.equals("DRFUZZY") || searchEngine.equals("VERITY") || searchEngine.equals("FULCRUM") ? searchEngine : "DRFUZZY";
    }

    public void addDocument(IndexDocument doc) throws TrexException {
        this.docList.add(doc);
    }

    /*
     * Unable to fully structure code
     */
    public void index() throws TrexException {
        cnt = 0;
        errorDocs = null;
        iMaxRetries = 5;
        while (cnt < iMaxRetries) {
            block9: {
                block10: {
                    ++cnt;
                    try {
                        this.index2();
                        errorDocs = this.getIndexErrorDocuments();
                        if (errorDocs == null || errorDocs.length == 0) break;
                        if (IndexManager.log.beDebug()) {
                            i = 0;
                            while (i < errorDocs.length) {
                                IndexManager.log.debugT("Errornous Document: " + errorDocs[i].getDocumentKey() + "  " + errorDocs[i].getLastError().getMsg() + "  " + errorDocs[i].getLastError().getCode());
                                ++i;
                            }
                        }
                        break block9;
                    }
                    catch (TrexException ex) {
                        IndexManager.log.warningT("catched exception while trying to index: Error" + ex.getCode() + ":" + ex.getMsg() + " " + cnt + " tries");
                        if (ex.getCode() != 1 || !IndexManager.log.beDebug()) break block10;
                        docs = this.getIndexErrorDocuments();
                        i = 0;
                        ** while (i < docs.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        IndexManager.log.debugT("Errornous Document: " + docs[i].getDocumentKey() + "  " + docs[i].getLastError().getMsg() + "  " + docs[i].getLastError().getCode());
                        ++i;
                        continue;
                    }
                }
                if (cnt >= iMaxRetries) {
                    IndexManager.log.errorT("too many exceptions catched while trying to index:Error" + ex.getCode() + ":" + ex.getMsg() + " " + cnt + " tries");
                    throw ex;
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                IndexManager.log.errorT("caught exception while waiting " + e.getMessage());
            }
        }
    }

    private void index2() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:INDEX");
            this.index = this.getNewIndexInstance();
            this.index.setIndexId(this.m_indexId);
            this.index.setSearchEngine(this.searchEngine);
            this.index.useQueueServer(this.queueServerFlag);
            if (this.m_httpserverManuallySet) {
                this.index.setHttpServerManuallySet(this.m_httpserverManuallySet);
                try {
                    this.index.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                    log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
                }
                catch (TrexException ex) {
                    log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                    throw new TrexException(7219, this.m_httpserverurl);
                }
            }
            Iterator dit = this.docList.iterator();
            while (dit.hasNext()) {
                this.index.addDocument((IndexDocument)dit.next());
            }
            log.infoT("Indexing/deindexing for index " + this.m_indexId + " started");
            this.index.index();
            log.infoT("Indexing/deindexing for index " + this.m_indexId + " finished");
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:INDEX");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.endComponent("EP:KM:TREX:INDEX");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void optimize() throws TrexException {
        TREXIMonitor monitor = new TREXIMonitor();
        try {
            monitor.startComponent("EP:KM:TREX:INDEX:OPT");
            if (this.index == null) {
                this.index = this.getNewIndexInstance();
            }
            this.index.setIndexId(this.m_indexId);
            this.index.useQueueServer(this.queueServerFlag);
            this.index.setSearchEngine(this.searchEngine);
            this.index.setLanguage(this.language);
            this.index.setHttpServerManuallySet(this.m_httpserverManuallySet);
            if (this.m_httpserverManuallySet) {
                this.index.setHttpServerManuallySet(this.m_httpserverManuallySet);
                try {
                    this.index.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                    log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
                }
                catch (TrexException ex) {
                    log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                    throw new TrexException(7219, this.m_httpserverurl);
                }
            }
            log.infoT("Optimization for index " + this.m_indexId + " started");
            this.index.optimize();
            log.infoT("Optimization for index " + this.m_indexId + " finished");
            Object var4_3 = null;
            monitor.endComponent("EP:KM:TREX:INDEX:OPT");
            monitor.endRequest();
            monitor = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            monitor.endComponent("EP:KM:TREX:INDEX:OPT");
            monitor.endRequest();
            monitor = null;
            throw throwable;
        }
    }

    public void setIndexId(String indexName) throws TrexException {
        this.m_indexId = indexName;
        log.debugT("IndexId set to " + indexName);
    }

    public void setIndexId(String indexName, String mode, String host, int port, String file) throws TrexException {
        this.m_indexId = indexName;
        this.m_httpserverurl = mode + "://" + host + ":" + port + file;
        this.m_httpserverManuallySet = true;
        if (log.beDebug()) {
            log.debugT("Index '" + this.m_indexId + ": parameters were set manually " + this.m_httpserverurl);
        }
    }

    public void useQueueServer(boolean queueServerFlag) {
        this.queueServerFlag = queueServerFlag;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public IndexDocument[] getIndexErrorDocuments() {
        return this.index.getIndexErrorDocuments();
    }

    public IndexDocument[] getOptimizeErrorDocuments() {
        return this.index.getOptimizeErrorDocuments();
    }

    public IndexDocument[] getErrorDocuments() {
        return this.index.getIndexErrorDocuments();
    }

    private AbstractIndex getNewIndexInstance() throws TrexException {
        if (this.m_indexId == null) {
            throw new TrexException(7230);
        }
        HttpIndex httpindex = new HttpIndex();
        httpindex.setTicket(this.m_ticket);
        httpindex.setIndexUser(this.m_indexUser);
        httpindex.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverManuallySet) {
            httpindex.setHttpServerManuallySet(this.m_httpserverManuallySet);
            try {
                httpindex.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException ex) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        return httpindex;
    }

    public void addAttributeValue(String docid, String attribute, String value) throws TrexException {
        this.attributes.add(new AttributeContainer(docid, attribute, value, this.ADD_ATTRIBUTE_VALUE));
    }

    public void removeAttributeValue(String docid, String attribute, String value) throws TrexException {
        this.attributes.add(new AttributeContainer(docid, attribute, value, this.REMOVE_ATTRIBUTE_VALUE));
    }

    public void removeAllAttributeValues(String docid, String attribute) throws TrexException {
        this.attributes.add(new AttributeContainer(docid, attribute, null, this.REMOVE_ALL_ATTRIBUTE_VALUES));
    }

    public void updateDocumentAttributes() throws TrexException {
        this.index = this.getNewIndexInstance();
        this.index.setIndexId(this.m_indexId);
        this.index.setSearchEngine(this.searchEngine);
        this.index.setLanguage(this.language);
        this.index.setHttpServerManuallySet(this.m_httpserverManuallySet);
        if (this.m_httpserverManuallySet) {
            this.index.setHttpServerManuallySet(this.m_httpserverManuallySet);
            try {
                this.index.setURL(HttpServerURL.getURL(this.m_httpserverurl));
                log.infoT("URL manually set to: '" + this.m_httpserverurl + "'");
            }
            catch (TrexException ex) {
                log.errorT("URL: '" + this.m_httpserverurl + "' is not a valid URL: " + ex.getMessage());
                throw new TrexException(7219, this.m_httpserverurl);
            }
        }
        log.infoT("Updating of attribute values for index " + this.indexName + " started");
        this.index.updateDocumentAttributes(this.attributes);
        log.infoT("Updating of attribute values for index " + this.indexName + " finished");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

