/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.TrexReturn;
import com.sapportals.trex.core.AbstractTextMining;
import com.sapportals.trex.core.CompleteTerms;
import com.sapportals.trex.core.HttpCalculateClustersRequest;
import com.sapportals.trex.core.HttpClassifyDocumentsRequest;
import com.sapportals.trex.core.HttpGetClassFeaturesRequest;
import com.sapportals.trex.core.HttpGetDocumentFeaturesRequest;
import com.sapportals.trex.core.HttpGetDocumentLanguageRequest;
import com.sapportals.trex.core.HttpGetTermIdsRequest;
import com.sapportals.trex.core.HttpGetThesaurusTermsRequest;
import com.sapportals.trex.core.HttpSearchSimilarClassesRequest;
import com.sapportals.trex.core.HttpSearchSimilarDocumentsRequest;
import com.sapportals.trex.core.HttpSearchSimilarTermsRequest;
import com.sapportals.trex.core.HttpTrexCommandRequest;
import com.sapportals.trex.core.RelatedTerms;
import com.sapportals.trex.core.SimilarSearchResult;
import com.sapportals.trex.core.TextMiningResult;
import com.sapportals.trex.core.TextMiningResultContainer;

class HttpTextMining
extends AbstractTextMining {
    public SimilarSearchResult searchSimilarDocuments() throws TrexException {
        HttpSearchSimilarDocumentsRequest request = new HttpSearchSimilarDocumentsRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getSimilarSearchResult();
    }

    public TextMiningResult getDocumentFeatures() throws TrexException {
        HttpGetDocumentFeaturesRequest request = new HttpGetDocumentFeaturesRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTextMiningResult();
    }

    public TextMiningResultContainer searchSimilarTerms() throws TrexException {
        HttpSearchSimilarTermsRequest request = new HttpSearchSimilarTermsRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTextMiningResultContainer();
    }

    public TextMiningResult classifyDocuments() throws TrexException {
        HttpClassifyDocumentsRequest request = new HttpClassifyDocumentsRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTextMiningResult();
    }

    public TextMiningResult searchSimilarClasses() throws TrexException {
        HttpSearchSimilarClassesRequest request = new HttpSearchSimilarClassesRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTextMiningResult();
    }

    public TextMiningResult getClassFeatures() throws TrexException {
        HttpGetClassFeaturesRequest request = new HttpGetClassFeaturesRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTextMiningResult();
    }

    public TextMiningResult calculateClusters() throws TrexException {
        HttpCalculateClustersRequest request = new HttpCalculateClustersRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTextMiningResult();
    }

    public RelatedTerms getThesaurusTerms() throws TrexException {
        HttpGetThesaurusTermsRequest request = new HttpGetThesaurusTermsRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getThesaurusTerms();
    }

    public CompleteTerms getTermIds() throws TrexException {
        HttpGetTermIdsRequest request = new HttpGetTermIdsRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        return request.getParser().getTermIds();
    }

    public TextMiningResult getDocumentLanguage() throws TrexException {
        HttpGetDocumentLanguageRequest request = new HttpGetDocumentLanguageRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        TextMiningResult res = request.getParser().getTextMiningResult();
        TrexReturn ret = request.getParser().getExceptionReturn();
        if (ret.getCode() != 0 && ret.getCode() != 1) {
            throw new TrexException(ret);
        }
        if (ret.getCode() == 1) {
            res.setErrorCode(ret);
        }
        return res;
    }

    public TextMiningResult trexCommand(String trexCommand) throws TrexException {
        this.m_command = trexCommand;
        HttpTrexCommandRequest request = new HttpTrexCommandRequest();
        request.setTicket(this.m_ticket);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        request.setHttpTextMining(this);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
        TextMiningResult result = request.getParser().getTextMiningResult();
        TrexReturn ret = request.getParser().getExceptionReturn();
        if (ret.getCode() != 0) {
            throw new TrexException(ret);
        }
        return result;
    }

    public TextMiningResult getDocumentCodepage() throws TrexException {
        TextMiningResult result = null;
        return result;
    }
}

