/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.core;

import com.sapportals.trex.TrexException;
import com.sapportals.trex.core.AbstractTaxonomy;
import com.sapportals.trex.core.HttpDeleteTaxonomyNodeRequest;
import com.sapportals.trex.core.HttpDeleteTaxonomyRequest;
import com.sapportals.trex.core.HttpGetDocuments4NodeRequest;
import com.sapportals.trex.core.HttpGetTaxonomyRequest;
import com.sapportals.trex.core.HttpProjectAssignmentMutationRequest;
import com.sapportals.trex.core.HttpProjectNodeDeletionRequest;
import com.sapportals.trex.core.HttpSetTaxonomyNodeRequest;
import com.sapportals.trex.core.HttpSetTaxonomyRequest;
import com.sapportals.trex.core.HttpUpdateIndexRequest;
import com.sapportals.trex.core.QueryEntry;
import com.sapportals.trex.core.SearchResult;
import com.sapportals.trex.core.TaxonomyNode;
import com.sapportals.trex.core.TaxonomyTerm;
import com.sapportals.trex.core.TaxonomyTree;
import com.sapportals.trex.util.xmlwriter.XMLWriter;

class HttpTaxonomy
extends AbstractTaxonomy {
    private String m_attribute = null;
    private TaxonomyNode m_node = null;
    private TaxonomyTree m_tree = null;
    private String m_nodeId = null;
    private String m_parentId = null;

    public TaxonomyTree getTaxonomy(String attribute) throws TrexException {
        this.m_attribute = attribute;
        HttpGetTaxonomyRequest request = new HttpGetTaxonomyRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getTaxonomy();
    }

    public void formatGetTaxonomyRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 7);
        w.startElement("GetTaxonomy");
        this.formatTaxonomy(w);
        w.endElement("GetTaxonomy");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void setTaxonomy(String attribute, TaxonomyTree tree) throws TrexException {
        this.m_attribute = attribute;
        this.m_tree = tree;
        HttpSetTaxonomyRequest request = new HttpSetTaxonomyRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
    }

    public void formatSetTaxonomyRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("SetTaxonomy");
        this.formatTaxonomy(w);
        w.startElement("TaxonomyNodeList");
        this.m_node = this.m_tree.getFirstNode();
        if (this.m_node != null) {
            do {
                this.formatTaxonomyNode(w);
                this.m_node = this.m_tree.getNextNode();
            } while (this.m_node != null);
        }
        w.endElement("TaxonomyNodeList");
        w.endElement("SetTaxonomy");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void setTaxonomyNode(String attribute, TaxonomyNode node) throws TrexException {
        this.m_attribute = attribute;
        this.m_node = node;
        HttpSetTaxonomyNodeRequest request = new HttpSetTaxonomyNodeRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (!this.m_httpserverManuallySet) {
            request.run();
        } else {
            request.run(this.m_httpserverurl);
        }
    }

    public void formatSetTaxonomyNodeRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("SetTaxonomyNode");
        this.formatTaxonomy(w);
        this.formatTaxonomyNode(w);
        w.endElement("SetTaxonomyNode");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void deleteTaxonomyNode(String attribute, String nodeId) throws TrexException {
        this.m_attribute = attribute;
        this.m_nodeId = nodeId;
        HttpDeleteTaxonomyNodeRequest request = new HttpDeleteTaxonomyNodeRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
    }

    public void formatDeleteTaxonomyNodeRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("DeleteTaxonomyNode");
        this.formatTaxonomy(w);
        w.dataElement("ID", this.m_nodeId);
        w.endElement("DeleteTaxonomyNode");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void deleteTaxonomy(String attribute) throws TrexException {
        this.m_attribute = attribute;
        HttpDeleteTaxonomyRequest request = new HttpDeleteTaxonomyRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
    }

    public void formatDeleteTaxonomyRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("DeleteTaxonomy");
        this.formatTaxonomy(w);
        w.endElement("DeleteTaxonomy");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public SearchResult getDocuments4Node(String attribute, String nodeId) throws TrexException {
        this.m_nodeId = nodeId;
        this.m_attribute = attribute;
        HttpGetDocuments4NodeRequest request = new HttpGetDocuments4NodeRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getSearchResult();
    }

    public void formatGetDocuments4NodeRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("GetDocs4TaxNode");
        this.formatTaxonomy(w);
        w.dataElement("TaxNodeID", this.m_nodeId);
        w.endElement("GetDocs4TaxNode");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void updateIndex() throws TrexException {
        HttpUpdateIndexRequest request = new HttpUpdateIndexRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
    }

    public void formatUpdateIndexRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("UpdateTaxIndex");
        w.dataElement("IndexID", this.m_indexId.getIndexName());
        if (this.m_indexId.getLanguage() != null && this.m_indexId.getLanguage().length() > 1) {
            w.dataElement("LAISO", this.m_indexId.getLanguage());
        }
        w.endElement("UpdateTaxIndex");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public void formatTaxonomy(XMLWriter w) throws Exception {
        w.dataElement("IndexID", this.m_indexId.getIndexName());
        w.dataElement("TaxonomyName", this.m_attribute);
        if (this.m_indexId.getLanguage() != null && this.m_indexId.getLanguage().length() > 1) {
            w.dataElement("LAISO", this.m_indexId.getLanguage());
        }
    }

    public void formatTaxonomyNode(XMLWriter w) throws Exception {
        w.startElement("TaxonomyNode");
        w.dataElement("ID", this.m_node.getId());
        if (this.m_node.getName() != null) {
            w.dataElement("Name", this.m_node.getName());
        }
        if (this.m_node.getParentId() != null) {
            w.dataElement("ParentID", this.m_node.getParentId());
            w.dataElement("ParentWeight", String.valueOf(this.m_node.getParentWeight()));
        }
        w.startElement("Where");
        QueryEntry queryEntry = this.m_node.getFirstQueryEntry();
        while (queryEntry != null) {
            this.formatQueryEntry(w, queryEntry);
            queryEntry = this.m_node.getNextQueryEntry();
        }
        w.endElement("Where");
        w.startElement("TaxTermList");
        TaxonomyTerm taxTerm = this.m_node.getFirstTerm();
        while (taxTerm != null) {
            this.formatTerm(w, taxTerm);
            taxTerm = this.m_node.getNextTerm();
        }
        w.endElement("TaxTermList");
        if (this.m_node.getSimVal() != 0.0f) {
            w.dataElement("SimVal", String.valueOf(this.m_node.getSimVal()));
        }
        w.endElement("TaxonomyNode");
    }

    public void formatTerm(XMLWriter w, TaxonomyTerm taxTerm) throws Exception {
        if (taxTerm != null) {
            w.startElement("TaxTerm");
            if (taxTerm.getAttribute() != null) {
                w.dataElement("Name", taxTerm.getAttribute());
            }
            w.dataElement("Weight", String.valueOf(taxTerm.getWeight()));
            if (taxTerm.getValue1() != null) {
                w.dataElement("Value1", taxTerm.getValue1());
            }
            if (taxTerm.getValue2() != null) {
                w.dataElement("Value2", taxTerm.getValue2());
            }
            if (taxTerm.getOperator() != null) {
                w.dataElement("Operator", taxTerm.getOperator());
            }
            w.endElement("TaxTerm");
        }
    }

    public void formatQueryEntry(XMLWriter w, QueryEntry queryEntry) throws Exception {
        byte[] b = new byte[1];
        w.startElement("QTerm");
        if (queryEntry.getLocation() != null) {
            w.dataElement("QTName", queryEntry.getLocation());
        }
        w.dataElement("QType", String.valueOf(queryEntry.getRowType()));
        w.dataElement("Value1", queryEntry.getValue1());
        if (queryEntry.getValue2() != null && queryEntry.getValue2().length() > 0) {
            w.dataElement("Value2", queryEntry.getValue2());
        }
        if (queryEntry.getOperator() != null) {
            w.dataElement("QOperator", queryEntry.getOperator());
        }
        b[0] = queryEntry.getContentType();
        w.dataElement("ContentType", new String(b));
        b[0] = queryEntry.getTermAction();
        w.dataElement("TermAction", new String(b));
        w.dataElement("TermWeight", String.valueOf(queryEntry.getTermWeight()));
        if (queryEntry.getTermAction() == 70) {
            w.dataElement("FuzzySimilarity", String.valueOf(queryEntry.getFuzzySimilarity()));
        }
        w.endElement("QTerm");
    }

    public String[] projectNodeDeletion(String attribute, String nodeId) throws TrexException {
        this.m_nodeId = nodeId;
        this.m_attribute = attribute;
        HttpProjectNodeDeletionRequest request = new HttpProjectNodeDeletionRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getNodes();
    }

    public void formatProjectNodeDeletionRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("ProjectNodeDeletion");
        w.dataElement("IndexID", this.m_indexId.getIndexName());
        w.dataElement("TaxonomyName", this.m_attribute);
        if (this.m_indexId.getLanguage() != null) {
            w.dataElement("LAISO", this.m_indexId.getLanguage());
        }
        w.dataElement("TaxNodeID", this.m_nodeId);
        w.endElement("ProjectNodeDeletion");
        w.endElement("TMRequest");
        w.endDocument();
    }

    public String[] projectAssignmentMutation(String attribute, String nodeId, String parentId) throws TrexException {
        this.m_nodeId = nodeId;
        this.m_attribute = attribute;
        this.m_parentId = parentId;
        HttpProjectAssignmentMutationRequest request = new HttpProjectAssignmentMutationRequest(this);
        request.setIndexUser(this.m_indexUser);
        request.setSSLData(this.m_keystore, this.m_truststore);
        if (this.m_httpserverurl != null) {
            request.run(this.m_httpserverurl);
        } else {
            request.run();
        }
        return request.getNodes();
    }

    public void formatProjectAssignmentMutationRequest(XMLWriter w) throws Exception {
        w.startDocument();
        w.startElement("TMRequest", 0);
        w.startElement("ProjectAssignmentMutation");
        w.dataElement("IndexID", this.m_indexId.getIndexName());
        w.dataElement("TaxonomyName", this.m_attribute);
        if (this.m_indexId.getLanguage() != null) {
            w.dataElement("LAISO", this.m_indexId.getLanguage());
        }
        w.dataElement("TaxNodeID", this.m_nodeId);
        if (this.m_parentId != null) {
            w.dataElement("ParentID", this.m_parentId);
        } else {
            w.dataElement("ParentID", "");
        }
        w.endElement("ProjectAssignmentMutation");
        w.endElement("TMRequest");
        w.endDocument();
    }
}

